package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * pay_invo_no_bill_relation
 * </p>
 *
 * @author ultraman
 * @since 2022-06-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PayInvoNoBillRelation implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 申请ID
   */
  private String applyId;
  /**
   * 开票通知单号
   */
  private String invoiceNoticeNO;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 付款单ID
   */
  private Long payMentId;
  /**
   * 开票通知单ID
   */
  private Long invoiceNoticeBillId;
  /**
   * 已支付金额
   */
  private BigDecimal paidAmount;
  /**
   * 开票通知单明细ID
   */
  private Long invoiceNoticeBillTeamId;
  /**
   * 已支付数量
   */
  private BigDecimal paidQuantity;
  /**
   * 采购单号
   */
  private String preNo;
  /**
   * 开票通知单明细行号
   */
  private String itemNO;

  /**
   * 对一关联关系 关联对象 invoiceNoticeBillItem
   */
  private Long payInvoNoBillItemRelationId;
  /**
   * 对一关联关系 关联对象 paymentManage
   */
  private Long paymentInvoNoBillItemRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("invoiceNoticeNO", invoiceNoticeNO);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("payMentId", payMentId);
      map.put("invoiceNoticeBillId", invoiceNoticeBillId);
      map.put("paidAmount", paidAmount);
      map.put("invoiceNoticeBillTeamId", invoiceNoticeBillTeamId);
      map.put("paidQuantity", paidQuantity);
      map.put("preNo", preNo);
      map.put("itemNO", itemNO);

      map.put("payInvoNoBillItemRelation.id", payInvoNoBillItemRelationId);
      map.put("paymentInvoNoBillItemRelation.id", paymentInvoNoBillItemRelationId);
      return map;
  }

  public static PayInvoNoBillRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PayInvoNoBillRelation entity = new PayInvoNoBillRelation();

    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNO")) {
      Object obj = map.get("invoiceNoticeNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payMentId")) {
      Object obj = map.get("payMentId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayMentId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPayMentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPayMentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillId")) {
      Object obj = map.get("invoiceNoticeBillId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceNoticeBillId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceNoticeBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceNoticeBillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillTeamId")) {
      Object obj = map.get("invoiceNoticeBillTeamId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceNoticeBillTeamId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceNoticeBillTeamId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceNoticeBillTeamId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paidQuantity")) {
      Object obj = map.get("paidQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaidQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("preNo")) {
      Object obj = map.get("preNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNO")) {
      Object obj = map.get("itemNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNO((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("payInvoNoBillItemRelation.id")) {
       Object obj = map.get("payInvoNoBillItemRelation.id");
       if(obj instanceof Long) {
         entity.setPayInvoNoBillItemRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setPayInvoNoBillItemRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("paymentInvoNoBillItemRelation.id")) {
       Object obj = map.get("paymentInvoNoBillItemRelation.id");
       if(obj instanceof Long) {
         entity.setPaymentInvoNoBillItemRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setPaymentInvoNoBillItemRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeNO")) {
      Object obj = map.get("invoiceNoticeNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNoticeNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payMentId")) {
      Object obj = map.get("payMentId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPayMentId((Long)obj);
        } else if(obj instanceof String) {
            this.setPayMentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPayMentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeBillId")) {
      Object obj = map.get("invoiceNoticeBillId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceNoticeBillId((Long)obj);
        } else if(obj instanceof String) {
            this.setInvoiceNoticeBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceNoticeBillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeBillTeamId")) {
      Object obj = map.get("invoiceNoticeBillTeamId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceNoticeBillTeamId((Long)obj);
        } else if(obj instanceof String) {
            this.setInvoiceNoticeBillTeamId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceNoticeBillTeamId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("paidQuantity")) {
      Object obj = map.get("paidQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaidQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaidQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaidQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPaidQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaidQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("preNo")) {
      Object obj = map.get("preNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemNO")) {
      Object obj = map.get("itemNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemNO((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("payInvoNoBillItemRelation.id")) {
    Object obj = map.get("payInvoNoBillItemRelation.id");
    if(obj instanceof Long) {
        this.setPayInvoNoBillItemRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setPayInvoNoBillItemRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("paymentInvoNoBillItemRelation.id")) {
    Object obj = map.get("paymentInvoNoBillItemRelation.id");
    if(obj instanceof Long) {
        this.setPaymentInvoNoBillItemRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setPaymentInvoNoBillItemRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
