package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_order
 * </p>
 *
 * @author ultraman
 * @since 2022-06-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrder implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 采购单号
   */
  private String poNumber;
  /**
   * 销方编号
   */
  private String sellerNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 执行分公司
   */
  private String buyerName;
  /**
   * 业务类型
   */
  private String businessType;
  /**
   * 预付金额
   */
  private BigDecimal prepayAmount;
  /**
   * 订单类型
   */
  private String orderType;
  /**
   * 执行分公司Id
   */
  private String buyerID;
  /**
   * 订单状态
   */
  private String orderStatus;
  /**
   * 失败原因
   */
  private String failureReason;
  /**
   * 采购组
   */
  private String purchasingTeam;
  /**
   * 采购组织
   */
  private String purchasingOrg;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 已预付待核销金额
   */
  private BigDecimal prepaidAmount;
  /**
   * 发票分公司Id
   */
  private String buyerInvoiceID;
  /**
   * 发票分公司
   */
  private String buyerInvoiceTitle;
  /**
   * 协同关系
   */
  private Boolean isCoord;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 销方银行账号
   */
  private String sellerBankNo;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方联系电话
   */
  private String sellerTelephone;
  /**
   * 购方银行账号
   */
  private String purchaseBankNo;
  /**
   * 购方银行名称
   */
  private String purchaseBankName;
  /**
   * 购方地址
   */
  private String purchaseAddress;
  /**
   * 购方联系电话
   */
  private String purchaseTelephone;
  /**
   * 虚拟采购单类型
   */
  private String virtualPoType;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 已收货金额
   */
  private BigDecimal deliveriedAmount;
  /**
   * 待开票金额
   */
  private BigDecimal waitForInvoiceAmount;
  /**
   * 未付金额
   */
  private BigDecimal unpayedAmount;
  /**
   * 缺失描述
   */
  private String absentMsg;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 已开票金额
   */
  private BigDecimal invoicedAmount;
  /**
   * 逆向付款单号
   */
  private String negativePaymentNo;
  /**
   * 换票类型
   */
  private String alterInvoiceIndicator;
  /**
   * 原采购单号
   */
  private String previousPONo;
  /**
   * 新采购单号
   */
  private String nextPONo;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 已生成开票通知单金额
   */
  private BigDecimal invoiceNoticeBillAmount;
  /**
   * 已支付金额
   */
  private BigDecimal payedAmount;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("businessType", businessType);
      map.put("prepayAmount", prepayAmount);
      map.put("orderType", orderType);
      map.put("buyerID", buyerID);
      map.put("orderStatus", orderStatus);
      map.put("failureReason", failureReason);
      map.put("purchasingTeam", purchasingTeam);
      map.put("purchasingOrg", purchasingOrg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("prepaidAmount", prepaidAmount);
      map.put("buyerInvoiceID", buyerInvoiceID);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("isCoord", isCoord);
      map.put("invoiceType", invoiceType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserNo", purchaserNo);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTelephone", sellerTelephone);
      map.put("purchaseBankNo", purchaseBankNo);
      map.put("purchaseBankName", purchaseBankName);
      map.put("purchaseAddress", purchaseAddress);
      map.put("purchaseTelephone", purchaseTelephone);
      map.put("virtualPoType", virtualPoType);
      map.put("projectName", projectName);
      map.put("deliveriedAmount", deliveriedAmount);
      map.put("waitForInvoiceAmount", waitForInvoiceAmount);
      map.put("unpayedAmount", unpayedAmount);
      map.put("absentMsg", absentMsg);
      map.put("amountWithTax", amountWithTax);
      map.put("invoicedAmount", invoicedAmount);
      map.put("negativePaymentNo", negativePaymentNo);
      map.put("alterInvoiceIndicator", alterInvoiceIndicator);
      map.put("previousPONo", previousPONo);
      map.put("nextPONo", nextPONo);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("invoiceNoticeBillAmount", invoiceNoticeBillAmount);
      map.put("payedAmount", payedAmount);

      return map;
  }

  public static PurchaseOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrder entity = new PurchaseOrder();

    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrepayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFailureReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrepaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isCoord")) {
      Object obj = map.get("isCoord");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsCoord((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsCoord(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtualPoType")) {
      Object obj = map.get("virtualPoType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVirtualPoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeliveriedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeliveriedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeliveriedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeliveriedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeliveriedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitForInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setWaitForInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnpayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnpayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnpayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnpayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnpayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("negativePaymentNo")) {
      Object obj = map.get("negativePaymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNegativePaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAlterInvoiceIndicator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousPONo")) {
      Object obj = map.get("previousPONo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreviousPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nextPONo")) {
      Object obj = map.get("nextPONo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNextPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillAmount")) {
      Object obj = map.get("invoiceNoticeBillAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceNoticeBillAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceNoticeBillAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceNoticeBillAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrepayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrepayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrepayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPrepayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrepayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String){
            this.setFailureReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchasingTeam((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchasingOrg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrepaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrepaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrepaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPrepaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrepaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("isCoord")) {
      Object obj = map.get("isCoord");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsCoord((Boolean)obj);
        } else if(obj instanceof String) {
            this.setIsCoord(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTelephone((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseBankNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseTelephone((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("virtualPoType")) {
      Object obj = map.get("virtualPoType");
      if(obj != null) {
        if(obj instanceof String){
            this.setVirtualPoType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDeliveriedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDeliveriedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDeliveriedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setDeliveriedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDeliveriedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setWaitForInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setWaitForInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setWaitForInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setWaitForInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setWaitForInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnpayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnpayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnpayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUnpayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnpayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
            this.setAbsentMsg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("negativePaymentNo")) {
      Object obj = map.get("negativePaymentNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setNegativePaymentNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String){
            this.setAlterInvoiceIndicator((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("previousPONo")) {
      Object obj = map.get("previousPONo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreviousPONo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("nextPONo")) {
      Object obj = map.get("nextPONo");
      if(obj != null) {
        if(obj instanceof String){
            this.setNextPONo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeBillAmount")) {
      Object obj = map.get("invoiceNoticeBillAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceNoticeBillAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInvoiceNoticeBillAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceNoticeBillAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }

  }

}
