package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-06-30
 */
public enum InvoiceSource {

    PHOENIX_DISCERN_DATA("phoenix.discern.data", "影像采集"),
    PUSH_MATCH_STATUS("pushMatchStatus", "供应商协同"),
    PURCHASER_INVOICE_MNGT_PUSHV4("purchaserInvoiceMngtPushv4", "4.0进项发票下发");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceSource fromCode(String code){
        switch(code) {
            case "phoenix.discern.data":
                return PHOENIX_DISCERN_DATA;
            case "pushMatchStatus":
                return PUSH_MATCH_STATUS;
            case "purchaserInvoiceMngtPushv4":
                return PURCHASER_INVOICE_MNGT_PUSHV4;
            default:
                return null;
        }
    }
}
