package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_order_item
 * </p>
 *
 * @author ultraman
 * @since 2022-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderItem implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 订单号
   */
  private String poNumber;
  /**
   * 行号
   */
  private Long item;
  /**
   * 物料/服务
   */
  private String materialServices;
  /**
   * 数量
   */
  private String quantity;
  /**
   * 单位
   */
  private String uom;
  /**
   * 要求送货日期
   */
  private String reqDelDate;
  /**
   * 不含税单价
   */
  private String netPriceExVAT;
  /**
   * 价格单位
   */
  private String perUoM;
  /**
   * 增值税率
   */
  private String vatRate;
  /**
   * 含税小计
   */
  private String totalAmountCNY;
  /**
   * WBS
   */
  private String wbs;
  /**
   * 物料/服务名称
   */
  private String materialServicesName;
  /**
   * 币种
   */
  private String currency;
  /**
   * 梯号
   */
  private String ladderNo;
  /**
   * 合同号
   */
  private String contractID;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 梯台状态ID
   */
  private String ladderStatusID;
  /**
   * 梯台状态
   */
  private String ladderStatus;
  /**
   * 税码
   */
  private String vatCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 扩展字段1
   */
  private String ext1;
  /**
   * 扩展字段2
   */
  private String ext2;
  /**
   * 扩展字段3
   */
  private String ext3;
  /**
   * 扩展字段4
   */
  private String ext4;
  /**
   * 扩展字段5
   */
  private String ext5;
  /**
   * 扩展字段6
   */
  private String ext6;
  /**
   * 扩展字段7
   */
  private String ext7;
  /**
   * 扩展字段8
   */
  private String ext8;
  /**
   * 扩展字段9
   */
  private String ext9;
  /**
   * 扩展字段10
   */
  private String ext10;
  /**
   * 物料组
   */
  private String materialServicesTeam;
  /**
   * 成本中心
   */
  private String costCenter;
  /**
   * 利润中心
   */
  private String profitsCenter;
  /**
   * 总账科目
   */
  private String generalLedgerAccount;
  /**
   * View业务系统
   */
  private String viewId;
  /**
   * 已收货数量
   */
  private String receivedCount;
  /**
   * 审批状态
   */
  private String releaseStatus;
  /**
   * 业务类型
   */
  private String businessType;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * PM节点
   */
  private String pmNode;

  /**
   * 对一关联关系 关联对象 purchaseOrder
   */
  private Long purchaseOrderItemRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("materialServices", materialServices);
      map.put("quantity", quantity);
      map.put("uom", uom);
      map.put("reqDelDate", reqDelDate);
      map.put("netPriceExVAT", netPriceExVAT);
      map.put("perUoM", perUoM);
      map.put("vatRate", vatRate);
      map.put("totalAmountCNY", totalAmountCNY);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("currency", currency);
      map.put("ladderNo", ladderNo);
      map.put("contractID", contractID);
      map.put("projectName", projectName);
      map.put("ladderStatusID", ladderStatusID);
      map.put("ladderStatus", ladderStatus);
      map.put("vatCode", vatCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("materialServicesTeam", materialServicesTeam);
      map.put("costCenter", costCenter);
      map.put("profitsCenter", profitsCenter);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("viewId", viewId);
      map.put("receivedCount", receivedCount);
      map.put("releaseStatus", releaseStatus);
      map.put("businessType", businessType);
      map.put("invoiceType", invoiceType);
      map.put("pmNode", pmNode);

      map.put("purchaseOrderItemRelation.id", purchaseOrderItemRelationId);
      return map;
  }

  public static PurchaseOrderItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderItem entity = new PurchaseOrderItem();

    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uom")) {
      Object obj = map.get("uom");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reqDelDate")) {
      Object obj = map.get("reqDelDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReqDelDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netPriceExVAT")) {
      Object obj = map.get("netPriceExVAT");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetPriceExVAT((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("perUoM")) {
      Object obj = map.get("perUoM");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPerUoM((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatRate")) {
      Object obj = map.get("vatRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountCNY")) {
      Object obj = map.get("totalAmountCNY");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountCNY((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatusID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivedCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReleaseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPmNode((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("purchaseOrderItemRelation.id")) {
       Object obj = map.get("purchaseOrderItemRelation.id");
       if(obj instanceof Long) {
         entity.setPurchaseOrderItemRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setItem((Long)obj);
        } else if(obj instanceof String) {
            this.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServices((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("uom")) {
      Object obj = map.get("uom");
      if(obj != null) {
        if(obj instanceof String){
            this.setUom((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reqDelDate")) {
      Object obj = map.get("reqDelDate");
      if(obj != null) {
        if(obj instanceof String){
            this.setReqDelDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("netPriceExVAT")) {
      Object obj = map.get("netPriceExVAT");
      if(obj != null) {
        if(obj instanceof String){
            this.setNetPriceExVAT((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("perUoM")) {
      Object obj = map.get("perUoM");
      if(obj != null) {
        if(obj instanceof String){
            this.setPerUoM((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("vatRate")) {
      Object obj = map.get("vatRate");
      if(obj != null) {
        if(obj instanceof String){
            this.setVatRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalAmountCNY")) {
      Object obj = map.get("totalAmountCNY");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalAmountCNY((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
            this.setWbs((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServicesName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrency((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderStatusID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setVatCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt4((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt5((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt6((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt7((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt8((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt9((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt10((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
            this.setCostCenter((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String){
            this.setProfitsCenter((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
            this.setViewId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceivedCount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setReleaseStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String){
            this.setPmNode((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("purchaseOrderItemRelation.id")) {
    Object obj = map.get("purchaseOrderItemRelation.id");
    if(obj instanceof Long) {
        this.setPurchaseOrderItemRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
