package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票操作类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-19
 */
public enum InvoiceOperation {

    BACK("back", "退回"),
    SEND("send", "寄送"),
    SIGN("sign", "签收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOperation fromCode(String code){
        switch(code) {
            case "back":
                return BACK;
            case "send":
                return SEND;
            case "sign":
                return SIGN;
            default:
                return null;
        }
    }
}
