package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数字转英文
 * </p>
 *
 * @author ultraman
 * @since 2022-08-31
 */
public enum NoToEn {

    _0("0", " "),
    _1("1", "A"),
    _2("2", "B"),
    _3("3", "C"),
    _4("4", "D"),
    _5("5", "E"),
    _6("6", "F"),
    _7("7", "G"),
    _8("8", "H"),
    _9("9", "I"),
    _10("10", "J"),
    _11("11", "K"),
    _12("12", "L"),
    _13("13", "M"),
    _14("14", "N"),
    _15("15", "O"),
    _16("16", "P"),
    _17("17", "Q"),
    _18("18", "R"),
    _19("19", "S"),
    _20("20", "T"),
    _21("21", "U"),
    _22("22", "V"),
    _23("23", "W"),
    _24("24", "X"),
    _25("25", "Y"),
    _26("26", "Z");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoToEn(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoToEn fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "23":
                return _23;
            case "24":
                return _24;
            case "25":
                return _25;
            case "26":
                return _26;
            default:
                return null;
        }
    }
}
