package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 成功或失败
 * </p>
 *
 * @author ultraman
 * @since 2022-12-09
 */
public enum SucceedOrError {

    __1("-1", "失败"),
    _1("1", "成功"),
    _0("0", "默认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SucceedOrError(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SucceedOrError fromCode(String code){
        switch(code) {
            case "-1":
                return __1;
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
