package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * RPA任务类型
 * </p>
 *
 * @author ultraman
 * @since 2022-12-09
 */
public enum TaskType {

    _1("1", "紧急PO拉取"),
    _2("2", "F-47-预付款请求生成"),
    _3("3", "MIRO-应付款凭证生成"),
    _4("4", "F-44-核销处理"),
    _5("5", "F-51-虚拟PO凭证生成+逆向冲销"),
    _6("6", "FBRA-逆向预付款不换PO处理"),
    _7("7", "FBL1N-付款凭证及日期获取"),
    _8("8", "FB08-预付凭证撤回"),
    _9("9", "MR8M-应付凭证撤回"),
    _10("10", "QUERYAR-AR数据获取");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
