package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款单状态
 * </p>
 *
 * @author ultraman
 * @since 2023-02-09
 */
public enum CurrentStatus {

    _0("0", "草稿"),
    _1("1", "待分公司确认"),
    _2("2", "待分公司安装部确认"),
    _3("3", "待分公司分总确认"),
    _4("4", "待区域财务确认"),
    _5("5", "待总部财务确认"),
    _6("6", "已提交待支付"),
    _7("7", "已支付"),
    _8("8", "已锁定"),
    _9("9", "已冲销"),
    _10("10", "应付凭证已取消"),
    _11("11", "已驳回"),
    _12("12", "等待配单发票"),
    _13("13", "已核销"),
    _14("14", "待系统提交"),
    _15("15", "预付凭证已取消"),
    _16("16", "已关闭"),
    _17("17", "待配单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CurrentStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CurrentStatus fromCode(String code) {
        return Stream.of(CurrentStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
