package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 邮件处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-02-09
 */
public enum EamilProcessStatus {

    __1("-1", "不处理"),
    _0("0", "待处理"),
    _1("1", "已处理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EamilProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EamilProcessStatus fromCode(String code) {
        return Stream.of(EamilProcessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
