package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真状态
 * </p>
 *
 * @author ultraman
 * @since 2023-02-09
 */
public enum TrueStatus {

    _0("0", "未购买验真"),
    _2("2", "验真中"),
    _3("3", "国税暂无此票"),
    _4("4", "验真成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TrueStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TrueStatus fromCode(String code) {
        return Stream.of(TrueStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
