package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_order_item
 * </p>
 *
 * @author ultraman
 * @since 2023-02-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderItem implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 采购单号
   */
  private String poNumber;
  /**
   * 采购单行号
   */
  private Long item;
  /**
   * 物料号
   */
  private String materialServices;
  /**
   * WBS
   */
  private String wbs;
  /**
   * 物料名称
   */
  private String materialServicesName;
  /**
   * 币种
   */
  private String currency;
  /**
   * 合同号
   */
  private String contractID;
  /**
   * 税码
   */
  private String vatCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 物料组
   */
  private String materialServicesTeam;
  /**
   * 成本中心
   */
  private String costCenter;
  /**
   * 利润中心
   */
  private String profitsCenter;
  /**
   * 总账科目
   */
  private String generalLedgerAccount;
  /**
   * 审批状态
   */
  private String releaseStatus;
  /**
   * 单位
   */
  private String quantityUnit;
  /**
   * 数量
   */
  private BigDecimal quantity;
  /**
   * 缺失信息描述
   */
  private String absentMsg;
  /**
   * 删除标记
   */
  private Boolean isDelete;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 订单状态
   */
  private String orderStatus;
  /**
   * 发布状态
   */
  private String postStatus;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 已收货数量
   */
  private BigDecimal receivedCount;
  /**
   * 已收货含税金额
   */
  private BigDecimal receivedAmount;
  /**
   * 已生成开票通知单数量
   */
  private BigDecimal invoiceNoticeBillQuantity;
  /**
   * 已生成开票通知单含税金额
   */
  private BigDecimal invoiceNoticeBillAmount;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * wbs切割值
   */
  private String wbsSub;
  /**
   * 订单净值
   */
  private BigDecimal orderNetValue;
  /**
   * 单价
   */
  private BigDecimal unitPrice;
  /**
   * 已生成开票通知单不含税金额
   */
  private BigDecimal invoiceNoticeBillAmountWithoutTax;
  /**
   * 工厂
   */
  private String factory;
  /**
   * 执行分公司
   */
  private String buyerName;
  /**
   * 执行分公司Id
   */
  private String buyerID;
  /**
   * 发票分公司Id
   */
  private String buyerInvoiceID;
  /**
   * 发票分公司
   */
  private String buyerInvoiceTitle;
  /**
   * 项目定义
   */
  private String projectDefinition;
  /**
   * 已收货不含税金额
   */
  private BigDecimal receivedAmountWithoutTax;
  /**
   * 已申请支付不含税金额
   */
  private BigDecimal totalPayAmount;
  /**
   * 已申请支付数量
   */
  private BigDecimal totalPayQty;
  /**
   * 梯台状态码
   */
  private String ladderStatusCode;
  /**
   * 梯台状态描述
   */
  private String ladderStatusDesc;
  /**
   * 梯号
   */
  private String ladderNo;
  /**
   * PM节点
   */
  private String pmNode;

  /**
   * 对一关联关系 关联对象 purchaseOrder
   */
  private Long purchaseOrderItemRelationId;
  /**
   * 对一关联关系 关联对象 wbs
   */
  private Long purchaseOrderItemAndWbsRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("materialServices", materialServices);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("currency", currency);
      map.put("contractID", contractID);
      map.put("vatCode", vatCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("materialServicesTeam", materialServicesTeam);
      map.put("costCenter", costCenter);
      map.put("profitsCenter", profitsCenter);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("releaseStatus", releaseStatus);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("absentMsg", absentMsg);
      map.put("isDelete", isDelete);
      map.put("amountWithTax", amountWithTax);
      map.put("orderStatus", orderStatus);
      map.put("postStatus", postStatus);
      map.put("taxRate", taxRate);
      map.put("receivedCount", receivedCount);
      map.put("receivedAmount", receivedAmount);
      map.put("invoiceNoticeBillQuantity", invoiceNoticeBillQuantity);
      map.put("invoiceNoticeBillAmount", invoiceNoticeBillAmount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("wbsSub", wbsSub);
      map.put("orderNetValue", orderNetValue);
      map.put("unitPrice", unitPrice);
      map.put("invoiceNoticeBillAmountWithoutTax", invoiceNoticeBillAmountWithoutTax);
      map.put("factory", factory);
      map.put("buyerName", buyerName);
      map.put("buyerID", buyerID);
      map.put("buyerInvoiceID", buyerInvoiceID);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("projectDefinition", projectDefinition);
      map.put("receivedAmountWithoutTax", receivedAmountWithoutTax);
      map.put("totalPayAmount", totalPayAmount);
      map.put("totalPayQty", totalPayQty);
      map.put("ladderStatusCode", ladderStatusCode);
      map.put("ladderStatusDesc", ladderStatusDesc);
      map.put("ladderNo", ladderNo);
      map.put("pmNode", pmNode);

      map.put("purchaseOrderItemRelation.id", purchaseOrderItemRelationId);
      map.put("purchaseOrderItemAndWbsRelation.id", purchaseOrderItemAndWbsRelationId);
      return map;
  }

  public static PurchaseOrderItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderItem entity = new PurchaseOrderItem();

    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReleaseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivedCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivedCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivedCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivedCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivedCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivedAmount")) {
      Object obj = map.get("receivedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillQuantity")) {
      Object obj = map.get("invoiceNoticeBillQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceNoticeBillQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceNoticeBillQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceNoticeBillQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceNoticeBillQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceNoticeBillQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillAmount")) {
      Object obj = map.get("invoiceNoticeBillAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceNoticeBillAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceNoticeBillAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceNoticeBillAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("wbsSub")) {
      Object obj = map.get("wbsSub");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWbsSub((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNetValue")) {
      Object obj = map.get("orderNetValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderNetValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderNetValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderNetValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderNetValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderNetValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillAmountWithoutTax")) {
      Object obj = map.get("invoiceNoticeBillAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceNoticeBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceNoticeBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceNoticeBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceNoticeBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceNoticeBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectDefinition")) {
      Object obj = map.get("projectDefinition");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectDefinition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivedAmountWithoutTax")) {
      Object obj = map.get("receivedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalPayAmount")) {
      Object obj = map.get("totalPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalPayQty")) {
      Object obj = map.get("totalPayQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPayQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPayQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPayQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPayQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPayQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusCode")) {
      Object obj = map.get("ladderStatusCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLadderStatusCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusDesc")) {
      Object obj = map.get("ladderStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLadderStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPmNode((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("purchaseOrderItemRelation.id")) {
       Object obj = map.get("purchaseOrderItemRelation.id");
       if(obj instanceof Long) {
         entity.setPurchaseOrderItemRelationId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("purchaseOrderItemAndWbsRelation.id")) {
       Object obj = map.get("purchaseOrderItemAndWbsRelation.id");
       if(obj instanceof Long) {
         entity.setPurchaseOrderItemAndWbsRelationId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setPurchaseOrderItemAndWbsRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setItem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReleaseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivedCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivedCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivedCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivedCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivedCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivedAmount")) {
      Object obj = map.get("receivedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillQuantity")) {
      Object obj = map.get("invoiceNoticeBillQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceNoticeBillQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceNoticeBillQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceNoticeBillQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceNoticeBillQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceNoticeBillQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillAmount")) {
      Object obj = map.get("invoiceNoticeBillAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceNoticeBillAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceNoticeBillAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceNoticeBillAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceNoticeBillAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("wbsSub")) {
      Object obj = map.get("wbsSub");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWbsSub((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNetValue")) {
      Object obj = map.get("orderNetValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderNetValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderNetValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderNetValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderNetValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderNetValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillAmountWithoutTax")) {
      Object obj = map.get("invoiceNoticeBillAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceNoticeBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceNoticeBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceNoticeBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceNoticeBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceNoticeBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFactory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectDefinition")) {
      Object obj = map.get("projectDefinition");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectDefinition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivedAmountWithoutTax")) {
      Object obj = map.get("receivedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalPayAmount")) {
      Object obj = map.get("totalPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalPayQty")) {
      Object obj = map.get("totalPayQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalPayQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalPayQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalPayQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalPayQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalPayQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusCode")) {
      Object obj = map.get("ladderStatusCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLadderStatusCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusDesc")) {
      Object obj = map.get("ladderStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLadderStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPmNode((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("purchaseOrderItemRelation.id")) {
    Object obj = map.get("purchaseOrderItemRelation.id");
    if(obj instanceof Long) {
        this.setPurchaseOrderItemRelationId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("purchaseOrderItemAndWbsRelation.id")) {
    Object obj = map.get("purchaseOrderItemAndWbsRelation.id");
    if(obj instanceof Long) {
        this.setPurchaseOrderItemAndWbsRelationId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setPurchaseOrderItemAndWbsRelationId(Long.parseLong((String)obj));
    }
  }
  }
}
