package com.xforceplus.ultraman.app.jctke.metadata.validator;

import com.xforceplus.ultraman.app.jctke.metadata.dict.*;
import com.xforceplus.ultraman.app.jctke.metadata.validator.annotation.*;

import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.GenericConstraintDef;
import org.hibernate.validator.cfg.defs.*;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * UltramanMetadataValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-02-09
 */
public class EntityMetaValidator implements Validator {

    private Validator validator;

    public EntityMetaValidator() {
        HibernateValidatorConfiguration configuration = Validation
                .byProvider(HibernateValidator.class)
                .configure();

        ConstraintMapping constraintMapping = configuration.createConstraintMapping();

        buildConstraintMapping(constraintMapping);

        this.validator = configuration.addMapping(constraintMapping)
                .buildValidatorFactory()
                .getValidator();
    }

    public <T> Set<ConstraintViolation<T>> validateProperties(T object, String ...propertyNames) {
        return Arrays.asList(propertyNames).stream()
                .map(propertyName -> validator.validateProperty(object, propertyName))
                .flatMap(Collection::stream)
                .collect(Collectors.toSet());
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?>... groups) {
        return validator.validate(object, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?>... groups) {
        return validator.validateProperty(object, propertyName, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?>... groups) {
        return validator.validateValue(beanType, propertyName, value, groups);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return validator.getConstraintsForClass(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return validator.unwrap(type);
    }

    @Override
    public ExecutableValidator forExecutables() {
        return validator.forExecutables();
    }

    private void buildConstraintMapping(ConstraintMapping constraintMapping) {

        // oqsengine_sdk_om_audit_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.OqsengineSdkOmAuditLog.class)
            .field("operatorId")
            .field("operatorCode")
            .field("operatorName")
            .field("operateType")
            .field("operateTime")
            .field("appId")
            .field("appCode")
            .field("boId")
            .field("boCode")
            .field("boName")
            .field("entityId")
            .field("requestData")
            .field("responseData")
            .field("remark")
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            ;
        // purchase_order
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PurchaseOrder.class)
            .field("poNumber")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(50))
            .field("sellerNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("buyerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("businessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("orderType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PurchaseOrderType.class))
            .field("buyerID")
            .constraint(new LengthDef().min(0).max(20))
            .field("orderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PoStatus.class))
            .field("failureReason")
            .constraint(new LengthDef().min(0).max(50))
            .field("purchasingTeam")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchasingOrg")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("buyerInvoiceID")
            .constraint(new LengthDef().min(0).max(20))
            .field("buyerInvoiceTitle")
            .constraint(new LengthDef().min(0).max(100))
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceType.class))
            .field("purchaserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaserTaxNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerTaxNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaserNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerBankNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerBankName")
            .constraint(new LengthDef().min(0).max(50))
            .field("sellerAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseBankNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseBankName")
            .constraint(new LengthDef().min(0).max(50))
            .field("purchaseAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("virtualPoType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", VirtualPoType.class))
            .field("projectName")
            .constraint(new LengthDef().min(0).max(50))
            .field("deliveriedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("waitForInvoiceAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("unpayedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(1000))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("invoicedAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("negativePaymentNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("alterInvoiceIndicator")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ChangeTicketType.class))
            .field("previousPONo")
            .constraint(new LengthDef().min(0).max(50))
            .field("nextPONo")
            .constraint(new LengthDef().min(0).max(50))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("invoiceNoticeBillAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("payedAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("prepayAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("allPaidAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("writeOffAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("prepaidAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("preOrderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PoStatus.class))
            .field("testAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("invoicedAmountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("waitForInvoiceAmountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("isSynergy")
            .field("eamilProcessStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("eamilProcessStatusRaw")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", EamilProcessStatus.class))
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(20000))
            .field("ladderNo")
            .constraint(new LengthDef().min(0).max(20000))
            .field("pmNode")
            .constraint(new LengthDef().min(0).max(20000))
            ;
        // purchase_order_item
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PurchaseOrderItem.class)
            .field("poNumber")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(50))
            .field("item")
            .constraint(new NotNullDef())
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("materialServices")
            .constraint(new LengthDef().min(0).max(20))
            .field("wbs")
            .constraint(new LengthDef().min(0).max(100))
            .field("materialServicesName")
            .constraint(new LengthDef().min(0).max(50))
            .field("currency")
            .constraint(new LengthDef().min(0).max(20))
            .field("contractID")
            .constraint(new LengthDef().min(0).max(50))
            .field("vatCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("materialServicesTeam")
            .constraint(new LengthDef().min(0).max(50))
            .field("costCenter")
            .constraint(new LengthDef().min(0).max(20))
            .field("profitsCenter")
            .constraint(new LengthDef().min(0).max(20))
            .field("generalLedgerAccount")
            .constraint(new LengthDef().min(0).max(20))
            .field("releaseStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("quantityUnit")
            .constraint(new LengthDef().min(0).max(20))
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("isDelete")
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("orderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PoStatus.class))
            .field("postStatus")
            .constraint(new LengthDef().min(0).max(2))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PostStatus.class))
            .field("taxRate")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("receivedCount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("receivedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("invoiceNoticeBillQuantity")
            .constraint(new DigitsDef().integer(11).fraction(9))
            .field("invoiceNoticeBillAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("wbsSub")
            .constraint(new LengthDef().min(0).max(200))
            .field("orderNetValue")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("unitPrice")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("invoiceNoticeBillAmountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("factory")
            .constraint(new LengthDef().min(0).max(20))
            .field("buyerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("buyerID")
            .constraint(new LengthDef().min(0).max(20))
            .field("buyerInvoiceID")
            .constraint(new LengthDef().min(0).max(20))
            .field("buyerInvoiceTitle")
            .constraint(new LengthDef().min(0).max(100))
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(20))
            .field("receivedAmountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("totalPayAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("totalPayQty")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("ladderStatusCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("ladderStatusDesc")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("pmNode")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // goods_receipt_item
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.GoodsReceiptItem.class)
            .field("poNO")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(50))
            .field("poLineItemNO")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("materialServices")
            .constraint(new LengthDef().min(0).max(50))
            .field("materialServicesName")
            .constraint(new LengthDef().min(0).max(50))
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("amount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("isRequiredAbsent")
            .field("amountAggregation")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("grNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("quantityAggregation")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("grItemNo")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // invoice_notice_bill
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.InvoiceNoticeBill.class)
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceType.class))
            .field("businessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("buyerID")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("buyerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("preNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("installmentNum")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("invoiceRemark")
            .constraint(new LengthDef().min(0).max(500))
            .field("priceMethod")
            .constraint(new LengthDef().min(0).max(20))
            .field("wbs")
            .constraint(new LengthDef().min(0).max(50))
            .field("currency")
            .constraint(new LengthDef().min(0).max(20))
            .field("node")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceNoticeNO")
            .constraint(new LengthDef().min(0).max(50))
            .field("sellerTaxNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceNoticeStatus.class))
            .field("sellerNo")
            .constraint(new LengthDef().min(0).max(30))
            .field("purchasingTeam")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchasingOrg")
            .constraint(new LengthDef().min(0).max(30))
            .field("buyerInvoiceTitle")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaserTaxNo")
            .constraint(new LengthDef().min(0).max(30))
            .field("purchaserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaserNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("type")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceNoticeType.class))
            .field("allocationOrderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessStatus.class))
            .field("remark")
            .constraint(new LengthDef().min(0).max(200))
            .field("originInvoiceNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("originInvoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerBankNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerBankName")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("receiveEmail")
            .constraint(new LengthDef().min(0).max(30))
            .field("receiveTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseBankNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseBankName")
            .constraint(new LengthDef().min(0).max(100))
            .field("cashierName")
            .constraint(new LengthDef().min(0).max(20))
            .field("checkerName")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoicerName")
            .constraint(new LengthDef().min(0).max(20))
            .field("redNotificationNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("profitCenter")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("projectName")
            .constraint(new LengthDef().min(0).max(100))
            .field("poTotalAmountWithTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("recommendationInvoiceId")
            .constraint(new LengthDef().min(0).max(20))
            .field("recommendationInvoiceNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("orderType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PurchaseOrderType.class))
            .field("negativePaymentNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("changeTicketType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ChangeTicketType.class))
            .field("distributeOrderInvoiceAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("paidAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("businessAmount")
            .constraint(new DigitsDef().integer(19).fraction(2))
            .field("totalAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("totalAmountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("hippedQuantity")
            .constraint(new DigitsDef().integer(11).fraction(9))
            .field("matchedAmountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(20000))
            .field("validSellementCount")
            .constraint(new DigitsDef().integer(2000).fraction(0))
            .field("pmNode")
            .constraint(new LengthDef().min(0).max(20000))
            .field("ladderNo")
            .constraint(new LengthDef().min(0).max(20000))
            .field("dataSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", DataSource.class))
            ;
        // invoice_notice_bill_item
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.InvoiceNoticeBillItem.class)
            .field("itemNO")
            .constraint(new LengthDef().min(0).max(50))
            .field("itemName")
            .constraint(new LengthDef().min(0).max(100))
            .field("itemSpec")
            .constraint(new LengthDef().min(0).max(20))
            .field("quantityUnit")
            .constraint(new LengthDef().min(0).max(20))
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("goodsTaxNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ENumReceiptType.class))
            .field("invoiceNoticeNO")
            .constraint(new LengthDef().min(0).max(50))
            .field("billNO")
            .constraint(new LengthDef().min(0).max(50))
            .field("costCenter")
            .constraint(new LengthDef().min(0).max(30))
            .field("profitCenter")
            .constraint(new LengthDef().min(0).max(20))
            .field("wbs")
            .constraint(new LengthDef().min(0).max(100))
            .field("contractNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("viewId")
            .constraint(new LengthDef().min(0).max(20))
            .field("ladderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("preNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("preItemNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("materialServices")
            .constraint(new LengthDef().min(0).max(20))
            .field("materialServicesName")
            .constraint(new LengthDef().min(0).max(100))
            .field("taxRate")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("totalPayQty")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("totalPayAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("businessStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("businessStatusExpr")
            .constraint(new LengthDef().min(0).max(20))
            .field("amountWithTaxRaw")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("unitPrice")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("editStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", YesOrNo.class))
            .field("amountWithoutTaxRaw")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("allPayQty")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("allPayAmountWithTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("allPayAmountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("contractID")
            .constraint(new LengthDef().min(0).max(50))
            .field("ladderNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("pmNode")
            .constraint(new LengthDef().min(0).max(20))
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // invoice
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.Invoice.class)
            .field("preNO")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceType.class))
            .field("invoiceStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceStatus.class))
            .field("invoiceUrl")
            .constraint(new LengthDef().min(0).max(500))
            .field("paperDrawDate")
            .field("sendDate")
            .field("receiptDate")
            .field("submitDate")
            .field("postingDate")
            .field("paymentDate")
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("buyerName")
            .constraint(new LengthDef().min(0).max(400))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("expressNumber")
            .constraint(new LengthDef().min(0).max(50))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("sellerNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("buyerID")
            .constraint(new LengthDef().min(0).max(50))
            .field("applyPayAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("voucherNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("voucherText")
            .constraint(new LengthDef().min(0).max(100))
            .field("payBaseDay")
            .field("actualPayDay")
            .field("authDate")
            .field("paymentNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("accountStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AccountStatus.class))
            .field("payStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PayStatus.class))
            .field("paidAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("invoicePayAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("sellerTaxNo")
            .constraint(new LengthDef().min(0).max(30))
            .field("sellerAddrTel")
            .constraint(new LengthDef().min(0).max(220))
            .field("sellerAddress")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerTel")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerBankNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerBankName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaserTaxNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("purchaserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaserAddrTel")
            .constraint(new LengthDef().min(0).max(220))
            .field("purchaserAddress")
            .constraint(new LengthDef().min(0).max(200))
            .field("purchaserTel")
            .constraint(new LengthDef().min(0).max(200))
            .field("purchaserBankName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaserBankNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("remark")
            .constraint(new LengthDef().min(0).max(500))
            .field("checkerName")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoicerName")
            .constraint(new LengthDef().min(0).max(20))
            .field("originInvoiceNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("originInvoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("redNotificationNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("taxDeclarationPeriod")
            .field("scanTime")
            .field("scanDeductionImageUrl")
            .constraint(new LengthDef().min(0).max(500))
            .field("scanInvoiceImageUrl")
            .constraint(new LengthDef().min(0).max(500))
            .field("purchaserNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceRegisterStatus.class))
            .field("authStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AuthStatus.class))
            .field("taxFlag")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", TrueStatus.class))
            .field("scanStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ScanStatus.class))
            .field("source")
            .constraint(new LengthDef().min(0).max(30))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceSource.class))
            .field("invoiceNoticeNos")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceId")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchasingTeam")
            .constraint(new LengthDef().min(0).max(800))
            .field("sendCount")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("backCount")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("recommendationFlag")
            .field("matchedAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("accountDate")
            .field("relationCount")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("lastSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceSource.class))
            .field("originFile")
            .constraint(new LengthDef().min(0).max(20))
            .field("originFileUrl")
            .constraint(new LengthDef().min(0).max(200))
            .field("returnReason")
            .constraint(new LengthDef().min(0).max(200))
            .field("availableAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("serialNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("isReplace")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", YesOrNo.class))
            .field("replaceSellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("replaceSellerTaxNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("originSellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("originSellerTaxNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("availableAmountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("imageId")
            .constraint(new LengthDef().min(0).max(20))
            .field("coordinationType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceNoticeType.class))
            .field("matchedAmountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("taxRate")
            .constraint(new LengthDef().min(0).max(1000))
            .field("poNumbers")
            .constraint(new LengthDef().min(0).max(4000))
            .field("dataSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", DataSource.class))
            ;
        // tax_code
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.TaxCode.class)
            .field("taxRate")
            .constraint(new NotNullDef())
            .constraint(new DigitsDef().integer(16).fraction(4))
            .field("invoiceType")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceType.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("taxCode")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            ;
        // subei_amount_approval
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.SubeiAmountApproval.class)
            .field("expenseType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ExpenseType.class))
            .field("roleType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RoleType.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("roleSerialNumber")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("roleEnglishDescription")
            .constraint(new LengthDef().min(0).max(100))
            .field("pettyCashType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PettyCashType.class))
            .field("leftSpareAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("rightSpareAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("amountLeftBorderSymbol")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AmountLeftBorderSymbol.class))
            .field("amountRightBorderSymbol")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AmountRightBorderSymbol.class))
            ;
        // toubao_amount_approval
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ToubaoAmountApproval.class)
            .field("expireDays")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("roleType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RoleType.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("roleSerialNumber")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("roleEnglishDescription")
            .constraint(new LengthDef().min(0).max(100))
            ;
        // wei_amount_approval
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.WeiAmountApproval.class)
            .field("expenseType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ExpenseType.class))
            .field("proportion")
            .constraint(new DigitsDef().integer(16).fraction(4))
            .field("marginAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("expireDays")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("roleType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RoleType.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("roleSerialNumber")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("roleEnglishDescription")
            .constraint(new LengthDef().min(0).max(100))
            ;
        // rpa_task
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.RpaTask.class)
            .field("taskType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", TaskType.class))
            .field("businessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("warehousingTime")
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("taskNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("billNO")
            .constraint(new LengthDef().min(0).max(250))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ResqustStatus.class))
            .field("resqustBody")
            .constraint(new LengthDef().min(0).max(50000))
            .field("remark")
            .constraint(new LengthDef().min(0).max(100))
            .field("responseCount")
            .constraint(new DigitsDef().integer(20).fraction(0))
            ;
        // profit_center_company
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ProfitCenterCompany.class)
            .field("profitCenter")
            .constraint(new LengthDef().min(0).max(30))
            .field("taxBranch")
            .constraint(new LengthDef().min(0).max(30))
            .field("performanceBranch")
            .constraint(new LengthDef().min(0).max(30))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("companyName")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // advance_charge_interface
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AdvanceChargeInterface.class)
            .field("paymentNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentType.class))
            .field("paymentTime")
            .field("paymentMonth")
            .field("profitCenter")
            .constraint(new LengthDef().min(0).max(30))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("supplierId")
            .constraint(new LengthDef().min(0).max(50))
            .field("ledgerType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", LedgerType.class))
            .field("exchangeRate")
            .constraint(new LengthDef().min(0).max(20))
            .field("companyCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("text")
            .constraint(new LengthDef().min(0).max(5000))
            .field("advanceChargeAmount")
            .constraint(new LengthDef().min(0).max(20))
            .field("paymentDueDate")
            .field("warehousingTime")
            .field("rpaTaskId")
            .constraint(new LengthDef().min(0).max(50))
            .field("prePaymentNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("prepaymentPaymentVoucher")
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("paymentObjectId")
            .constraint(new LengthDef().min(0).max(20))
            .field("payMentId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("taxCode")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // accounts_payable_interface
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AccountsPayableInterface.class)
            .field("paymentNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentType.class))
            .field("prePaymentIdentification")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PrePaymentIdentification.class))
            .field("prePaymentVoucherNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("prePaymentAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("paperDrewDate")
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(30))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("poList")
            .constraint(new LengthDef().min(0).max(200))
            .field("isFrozen")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", IsFrozen.class))
            .field("paymentVoucherNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("reverseOrderVoucherNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("prePayment")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentVoucherNoTwo")
            .constraint(new LengthDef().min(0).max(50))
            .field("settleAccountsVoucherNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("rpaTaskId")
            .constraint(new LengthDef().min(0).max(50))
            .field("warehousingTime")
            .field("payMentId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            ;
        // approval_history
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ApprovalHistory.class)
            .field("approvalId")
            .constraint(new LengthDef().min(0).max(50))
            .field("applyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("approvalUserName")
            .constraint(new LengthDef().min(0).max(50))
            .field("approvalStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ApprovalStatus.class))
            .field("approvalBody")
            .constraint(new LengthDef().min(0).max(200))
            .field("applyNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("approvalTime")
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("payMentId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("originStatus")
            .constraint(new LengthDef().min(0).max(30))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", CurrentStatus.class))
            .field("currentStatus")
            .constraint(new LengthDef().min(0).max(30))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", CurrentStatus.class))
            .field("poNumbers")
            .constraint(new LengthDef().min(0).max(5000))
            ;
        // enclosure
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.Enclosure.class)
            .field("applyNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("fileId")
            .constraint(new LengthDef().min(0).max(50))
            .field("fileName")
            .constraint(new LengthDef().min(0).max(1000))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("entityType")
            .constraint(new LengthDef().min(0).max(20))
            .field("entityId")
            .constraint(new DigitsDef().integer(50).fraction(0))
            .field("fileUrl")
            .constraint(new LengthDef().min(0).max(300))
            .constraint(new URLDef())
            ;
        // payment_manage
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PaymentManage.class)
            .field("applyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("applyUserName")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentType.class))
            .field("businessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("prepaymentType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PrepaymentType.class))
            .field("bondType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BondType.class))
            .field("paymentObjectId")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentObject")
            .constraint(new LengthDef().min(0).max(100))
            .field("applyPaymentAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("applyPaidAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("orderAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("invoiceAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("collectionAccumulation")
            .constraint(new DigitsDef().integer(12).fraction(8))
            .field("paymentAccumulation")
            .constraint(new DigitsDef().integer(12).fraction(8))
            .field("prepaymentRequestNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("prepaymentWriteVoucher")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentVoucher")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentPaymentVoucher")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentClearingVoucher")
            .constraint(new LengthDef().min(0).max(50))
            .field("currentStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", CurrentStatus.class))
            .field("errorInfo")
            .constraint(new LengthDef().min(0).max(200))
            .field("profitCenter")
            .constraint(new LengthDef().min(0).max(30))
            .field("costCenter")
            .constraint(new LengthDef().min(0).max(30))
            .field("paymentUserType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentUserType.class))
            .field("paymentDueDate")
            .field("paymentBankType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentBankType.class))
            .field("collectionBank")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(50))
            .field("collectionName")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("contractName")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("contractType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ContractType.class))
            .field("startDate")
            .field("endDate")
            .field("text")
            .constraint(new LengthDef().min(0).max(5000))
            .field("paymentRemark")
            .constraint(new LengthDef().min(0).max(200))
            .field("approvalHistory")
            .constraint(new LengthDef().min(0).max(200))
            .field("downloadUserName")
            .constraint(new LengthDef().min(0).max(20))
            .field("downloadStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", DownloadStatus.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("contractSignDate")
            .field("invoiceNoticeNOs")
            .constraint(new LengthDef().min(0).max(5000))
            .field("approvalRole")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RoleType.class))
            .field("companyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("companyName")
            .constraint(new LengthDef().min(0).max(50))
            .field("purchaserId")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaserName")
            .constraint(new LengthDef().min(0).max(20))
            .field("approvalBody")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentPaymentTerm")
            .constraint(new LengthDef().min(0).max(2000))
            .field("pettyCashType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PettyCashType.class))
            .field("purchasingOrg")
            .constraint(new LengthDef().min(0).max(20))
            .field("procurementGroup")
            .constraint(new LengthDef().min(0).max(500))
            .field("freezePayment")
            .field("commercialPaymentVoucher")
            .constraint(new LengthDef().min(0).max(20))
            .field("alterInvoiceIndicator")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ChangeTicketType.class))
            .field("previousApplyId")
            .constraint(new LengthDef().min(0).max(300))
            .field("nextApplyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("prepaymentPaymentVoucher")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentDate")
            .field("prepaymentAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("payedAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("marginAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("projectName")
            .constraint(new LengthDef().min(0).max(200))
            .field("initiateRole")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RoleType.class))
            .field("poNos")
            .constraint(new LengthDef().min(0).max(5000))
            .field("prepaidAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("sellerTaxNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("submitDate")
            .field("accountingDate")
            .field("poNumbers")
            .constraint(new LengthDef().min(0).max(5000))
            .field("collectionBankCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("orderType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PurchaseOrderType.class))
            .field("dataSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", DataSource.class))
            ;
        // imprest
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.Imprest.class)
            .field("applyId")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("paymentOrderType")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentType.class))
            .field("preBusinessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("payId")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .field("payer")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .field("payBankType")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentBankType.class))
            .field("payRemark")
            .constraint(new LengthDef().min(0).max(20))
            .field("entrySapText")
            .constraint(new LengthDef().min(0).max(20))
            .field("attachmentUrl")
            .constraint(new LengthDef().min(0).max(200))
            .constraint(new URLDef())
            .field("status")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", CurrentStatus.class))
            .field("imprestVoucherNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("downloadUserId")
            .constraint(new LengthDef().min(0).max(20))
            .field("downloadUserName")
            .constraint(new LengthDef().min(0).max(20))
            .field("downloadStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", DownloadStatus.class))
            .field("payLastDate")
            .field("currentApprover")
            .constraint(new LengthDef().min(0).max(20))
            .field("approvalRecord")
            .constraint(new LengthDef().min(0).max(20))
            .field("otherRemark")
            .constraint(new LengthDef().min(0).max(200))
            .field("billNo")
            .constraint(new LengthDef().min(0).max(2000))
            .field("errorMsg")
            .constraint(new LengthDef().min(0).max(2000))
            .field("imprestType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PrepaymentType.class))
            .field("payeeBankAccount")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // no_po_imprest
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.NoPoImprest.class)
            .field("imprestSubType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BondType.class))
            .field("contractId")
            .constraint(new LengthDef().min(0).max(20))
            .field("contractType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ContractType.class))
            .field("contractName")
            .constraint(new LengthDef().min(0).max(20))
            .field("contractSignDate")
            .field("contractStartDate")
            .field("contractEndDate")
            .field("supplierName")
            .constraint(new LengthDef().min(0).max(20))
            .field("supplierBank")
            .constraint(new LengthDef().min(0).max(20))
            .field("payAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // po_imprest
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PoImprest.class)
            .field("totalAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("paidAmount")
            .constraint(new NotNullDef())
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("applyPayAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // approval_rules
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ApprovalRules.class)
            .field("paymentType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PaymentType.class))
            .field("businessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("nextRole")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RoleType.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("currentStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", CurrentStatus.class))
            .field("nextStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", CurrentStatus.class))
            .field("ext1")
            .constraint(new LengthDef().min(0).max(20))
            .field("role")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RoleType.class))
            .field("initiateRole")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnums.class).param("value", RoleType.class))
            .field("approvalStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ApprovalStatus.class))
            ;
        // purchase_order_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PurchaseOrderInit.class)
            .field("poNumber")
            .constraint(new LengthDef().min(0).max(200))
            .field("currency")
            .constraint(new LengthDef().min(0).max(200))
            .field("postStatusRaw")
            .constraint(new LengthDef().min(0).max(20))
            .field("generalLedgerAccount")
            .constraint(new LengthDef().min(0).max(200))
            .field("costCenter")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("buyerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("businessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("payedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("invoicedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("waitForInvoiceAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("deliveriedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("prepayAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("unpayedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("buyerID")
            .constraint(new LengthDef().min(0).max(20))
            .field("failureReason")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchasingTeam")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchasingOrg")
            .constraint(new LengthDef().min(0).max(20))
            .field("prepaidAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("buyerInvoiceID")
            .constraint(new LengthDef().min(0).max(20))
            .field("buyerInvoiceTitle")
            .constraint(new LengthDef().min(0).max(20))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("isCoord")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceType.class))
            .field("purchaserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaserTaxNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerTaxNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaserNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("materialServices")
            .constraint(new LengthDef().min(0).max(20))
            .field("quantityUnit")
            .constraint(new LengthDef().min(0).max(20))
            .field("amountWithTaxRaw")
            .constraint(new LengthDef().min(0).max(20))
            .field("wbs")
            .constraint(new LengthDef().min(0).max(200))
            .field("materialServicesName")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractID")
            .constraint(new LengthDef().min(0).max(20))
            .field("projectName")
            .constraint(new LengthDef().min(0).max(100))
            .field("vatCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("materialServicesTeam")
            .constraint(new LengthDef().min(0).max(20))
            .field("profitsCenter")
            .constraint(new LengthDef().min(0).max(20))
            .field("viewId")
            .constraint(new LengthDef().min(0).max(20))
            .field("orderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PoStatus.class))
            .field("orderType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PurchaseOrderType.class))
            .field("item")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("isDelete")
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("postStatus")
            .constraint(new LengthDef().min(0).max(2))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PostStatus.class))
            .field("unitPrice")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("seller")
            .constraint(new LengthDef().min(0).max(200))
            .field("isDeleteRaw")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseOrderItemAndWbsRelationId")
            .constraint(new DigitsDef().integer(50).fraction(0))
            .field("purchaseBankNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseBankName")
            .constraint(new LengthDef().min(0).max(200))
            .field("purchaseAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerBankNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerBankName")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("wbsSub")
            .constraint(new LengthDef().min(0).max(200))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("asyncStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AsyncStatus.class))
            .field("poAndItem")
            .constraint(new LengthDef().min(0).max(20))
            .field("factory")
            .constraint(new LengthDef().min(0).max(20))
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(20))
            .field("asyncCount")
            .constraint(new DigitsDef().integer(20).fraction(0))
            ;
        // goods_receipt_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.GoodsReceiptInit.class)
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("amount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("purchaserOrderAndGoodsReceiptItems")
            .constraint(new DigitsDef().integer(18).fraction(0))
            .field("purchaseOrderItemAndGoodsReceiptItems")
            .constraint(new DigitsDef().integer(18).fraction(0))
            .field("poNO")
            .constraint(new LengthDef().min(0).max(200))
            .field("poLineItemNO")
            .constraint(new LengthDef().min(0).max(20))
            .field("materialServices")
            .constraint(new LengthDef().min(0).max(200))
            .field("materialServicesName")
            .constraint(new LengthDef().min(0).max(200))
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("grNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("grItemNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("asyncStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AsyncStatus.class))
            .field("grAndItem")
            .constraint(new LengthDef().min(0).max(200))
            .field("asyncCount")
            .constraint(new DigitsDef().integer(20).fraction(0))
            ;
        // wbs_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.WbsInit.class)
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(200))
            .field("fieldWBSNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("region")
            .constraint(new LengthDef().min(0).max(200))
            .field("installationExecutionBranch")
            .constraint(new LengthDef().min(0).max(200))
            .field("viewId")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameByEnglish")
            .constraint(new LengthDef().min(0).max(200))
            .field("mfgWbsNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("soldToParty")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractType")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectScale")
            .constraint(new LengthDef().min(0).max(200))
            .field("equipmentContractNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("installationContractNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("systemState")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderStatusCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderStatusDesc")
            .constraint(new LengthDef().min(0).max(200))
            .field("managerName")
            .constraint(new LengthDef().min(0).max(200))
            .field("managerId")
            .constraint(new LengthDef().min(0).max(200))
            .field("equipmentAmountWIthTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("installationAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("factoryFrom")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderSpecies")
            .constraint(new LengthDef().min(0).max(200))
            .field("productModel")
            .constraint(new LengthDef().min(0).max(200))
            .field("ratedLoadOfKg")
            .constraint(new LengthDef().min(0).max(200))
            .field("ratedSpeed")
            .constraint(new LengthDef().min(0).max(200))
            .field("strokeHeight")
            .constraint(new LengthDef().min(0).max(200))
            .field("floor")
            .constraint(new LengthDef().min(0).max(200))
            .field("numberOfStops")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalShaftHeight")
            .constraint(new LengthDef().min(0).max(200))
            .field("liftingHeight")
            .constraint(new LengthDef().min(0).max(200))
            .field("stepWidth")
            .constraint(new LengthDef().min(0).max(200))
            .field("angle")
            .constraint(new LengthDef().min(0).max(200))
            .field("length")
            .constraint(new LengthDef().min(0).max(200))
            .field("orderDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("validOrderDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm01RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm05PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm05RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm10PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm10RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm15PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm15RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm20PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm20RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm25PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm25RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm30PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm30RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm35PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm35RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm40PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi03PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi03RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi05PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi05RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi10PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi10RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi15PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi15RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi25PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi25RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi30PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi30RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm40RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("asyncStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AsyncStatus.class))
            ;
        // seller_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.SellerInit.class)
            .field("seller")
            .constraint(new LengthDef().min(0).max(200))
            .field("address")
            .constraint(new LengthDef().min(0).max(200))
            .field("tel1")
            .constraint(new LengthDef().min(0).max(190))
            .field("tel2")
            .constraint(new LengthDef().min(0).max(200))
            .field("taxNo1")
            .constraint(new LengthDef().min(0).max(200))
            .field("taxNo2")
            .constraint(new LengthDef().min(0).max(200))
            .field("bankName")
            .constraint(new LengthDef().min(0).max(200))
            .field("bankAccount")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .field("isPrimaryKeyAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("isRequiredAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("asyncStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AsyncStatus.class))
            ;
        // po_form
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PoForm.class)
            .field("installment")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("makeInvoiceAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            ;
        // apply_id
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ApplyId.class)
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("serialNo")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // invoice_detail_relation
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.InvoiceDetailRelation.class)
            .field("invoiceId")
            .constraint(new LengthDef().min(0).max(20))
            .field("preInvoiceId")
            .constraint(new LengthDef().min(0).max(20))
            .field("salesbillNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("salesbillItemNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("preInvoiceItemId")
            .constraint(new LengthDef().min(0).max(20))
            .field("salesbillItemId")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("cargoCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("cargoName")
            .constraint(new LengthDef().min(0).max(200))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("itemName")
            .constraint(new LengthDef().min(0).max(200))
            .field("itemSpec")
            .constraint(new LengthDef().min(0).max(50))
            .field("quantityUnit")
            .constraint(new LengthDef().min(0).max(20))
            .field("goodsNoVer")
            .constraint(new LengthDef().min(0).max(20))
            .field("goodsTaxNo")
            .constraint(new LengthDef().min(0).max(30))
            .field("taxPre")
            .constraint(new LengthDef().min(0).max(20))
            .field("taxPreCon")
            .constraint(new LengthDef().min(0).max(50))
            .field("zeroTax")
            .constraint(new LengthDef().min(0).max(20))
            .field("discountFlag")
            .constraint(new LengthDef().min(0).max(20))
            .field("priceMethod")
            .constraint(new LengthDef().min(0).max(20))
            .field("printContentFlag")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceItemId")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceNoticeNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceNoticeItemId")
            .constraint(new LengthDef().min(0).max(30))
            .field("invoiceNoticeItemNo")
            .constraint(new LengthDef().min(0).max(30))
            .field("purchaseOrderNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("purchaseOrderItemId")
            .constraint(new LengthDef().min(0).max(50))
            .field("purchaseOrderItemNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("taxRate")
            .constraint(new DigitsDef().integer(16).fraction(4))
            .field("quantity")
            .constraint(new DigitsDef().integer(15).fraction(15))
            .field("unitPrice")
            .constraint(new DigitsDef().integer(15).fraction(15))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(24).fraction(6))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(24).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(24).fraction(6))
            .field("deduction")
            .constraint(new DigitsDef().integer(24).fraction(6))
            ;
        // rpa_response
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.RpaResponse.class)
            .field("taskNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("taskType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", TaskType.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("response")
            .constraint(new LengthDef().min(0).max(200000))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", RpaStatus.class))
            ;
        // cost_center
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.CostCenter.class)
            .field("profitCenter")
            .constraint(new LengthDef().min(0).max(20))
            .field("performanceBranch")
            .constraint(new LengthDef().min(0).max(20))
            .field("taxBranch")
            .constraint(new LengthDef().min(0).max(20))
            .field("region")
            .constraint(new LengthDef().min(0).max(20))
            .field("city")
            .constraint(new LengthDef().min(0).max(20))
            .field("costCenter")
            .constraint(new LengthDef().min(0).max(20))
            .field("ctrShortText")
            .constraint(new LengthDef().min(0).max(100))
            .field("ctrLongText")
            .constraint(new LengthDef().min(0).max(200))
            .field("chineseShortText")
            .constraint(new LengthDef().min(0).max(100))
            .field("chineseLongText")
            .constraint(new LengthDef().min(0).max(200))
            .field("ext1")
            .constraint(new LengthDef().min(0).max(20))
            .field("ext2")
            .constraint(new LengthDef().min(0).max(20))
            .field("ext3")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("lineId")
            .constraint(new DigitsDef().integer(18).fraction(0))
            ;
        // pay_invo_no_bill_relation
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PayInvoNoBillRelation.class)
            .field("applyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceNoticeNO")
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("payMentId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("invoiceNoticeBillId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("paidAmount")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("invoiceNoticeBillTeamId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("paidQuantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("preNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("itemNO")
            .constraint(new LengthDef().min(0).max(50))
            .field("paymentStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("paymentStatusExp")
            .constraint(new LengthDef().min(0).max(20))
            .field("taxRate")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("paidAmountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("editStatus")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // invoice_notice_bill_relation
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.InvoiceNoticeBillRelation.class)
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("distributeOrderAmount")
            .constraint(new NotNullDef())
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("invoiceNoticeNo")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("invoiceId")
            .constraint(new NotNullDef())
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("invoiceNoticeBillId")
            .constraint(new NotNullDef())
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("invoiceRegisterStatus")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceRegisterStatus.class))
            .field("purchaseOrderNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("originInvoiceNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("originInvoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("matchedAmountWithoutTax")
            .constraint(new DigitsDef().integer(14).fraction(6))
            ;
        // wbs
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.Wbs.class)
            .field("projectName")
            .constraint(new LengthDef().min(0).max(200))
            .field("fieldWBSNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("viewId")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(20))
            .field("ladderNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("ladderStatusCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("ladderStatusDesc")
            .constraint(new LengthDef().min(0).max(200))
            .field("pmNode")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            ;
        // add_p_o
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AddPO.class)
            .field("billNO")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // receipt_init_failed_history
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ReceiptInitFailedHistory.class)
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("poNO")
            .constraint(new LengthDef().min(0).max(20))
            .field("poLineItemNO")
            .constraint(new LengthDef().min(0).max(20))
            .field("materialServices")
            .constraint(new LengthDef().min(0).max(200))
            .field("materialServicesName")
            .constraint(new LengthDef().min(0).max(200))
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("amount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("grNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("grItemNo")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // wbs_init_faieled_history
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.WbsInitFaieledHistory.class)
            .field("projectDefinition")
            .constraint(new LengthDef().min(0).max(200))
            .field("fieldWBSNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("region")
            .constraint(new LengthDef().min(0).max(200))
            .field("installationExecutionBranch")
            .constraint(new LengthDef().min(0).max(200))
            .field("viewId")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameByEnglish")
            .constraint(new LengthDef().min(0).max(200))
            .field("mfgWbsNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("soldToParty")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractType")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectScale")
            .constraint(new LengthDef().min(0).max(200))
            .field("equipmentContractNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("installationContractNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("systemState")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderStatusCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderStatusDesc")
            .constraint(new LengthDef().min(0).max(200))
            .field("managerName")
            .constraint(new LengthDef().min(0).max(200))
            .field("managerId")
            .constraint(new LengthDef().min(0).max(200))
            .field("equipmentAmountWIthTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("installationAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("factoryFrom")
            .constraint(new LengthDef().min(0).max(200))
            .field("ladderSpecies")
            .constraint(new LengthDef().min(0).max(200))
            .field("productModel")
            .constraint(new LengthDef().min(0).max(200))
            .field("ratedLoadOfKg")
            .constraint(new LengthDef().min(0).max(200))
            .field("ratedSpeed")
            .constraint(new LengthDef().min(0).max(200))
            .field("strokeHeight")
            .constraint(new LengthDef().min(0).max(200))
            .field("floor")
            .constraint(new LengthDef().min(0).max(200))
            .field("numberOfStops")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalShaftHeight")
            .constraint(new LengthDef().min(0).max(200))
            .field("liftingHeight")
            .constraint(new LengthDef().min(0).max(200))
            .field("stepWidth")
            .constraint(new LengthDef().min(0).max(200))
            .field("angle")
            .constraint(new LengthDef().min(0).max(200))
            .field("length")
            .constraint(new LengthDef().min(0).max(200))
            .field("orderDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("validOrderDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm01RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm05PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm05RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm10PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm10RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm15PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm15RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm20PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm20RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm25PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm25RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm30PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm30RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm35PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm35RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm40PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("pm405RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi03PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi03RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi05PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi05RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi10PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi10RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi15PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi15RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi25PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi25RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi30PlanDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("bi30RealityDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("isPrimaryKeyAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("isRequiredAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // seller_init_failed_history
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.SellerInitFailedHistory.class)
            .field("seller")
            .constraint(new LengthDef().min(0).max(200))
            .field("address")
            .constraint(new LengthDef().min(0).max(200))
            .field("tel1")
            .constraint(new LengthDef().min(0).max(190))
            .field("tel2")
            .constraint(new LengthDef().min(0).max(200))
            .field("taxNo1")
            .constraint(new LengthDef().min(0).max(200))
            .field("taxNo2")
            .constraint(new LengthDef().min(0).max(200))
            .field("bankName")
            .constraint(new LengthDef().min(0).max(200))
            .field("bankAccount")
            .constraint(new LengthDef().min(0).max(200))
            .field("isPrimaryKeyAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("isRequiredAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // a_r_power_bi_failed_his_tory
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ARPowerBiFailedHisTory.class)
            .field("collectionPercent")
            .constraint(new DigitsDef().integer(16).fraction(4))
            .field("paymentPercent")
            .constraint(new DigitsDef().integer(16).fraction(4))
            .field("arehousingTime")
            .field("poNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("isPrimaryKeyAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("isRequiredAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // a_r_power_bi_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.ARPowerBiInit.class)
            .field("collectionPercent")
            .constraint(new DigitsDef().integer(16).fraction(4))
            .field("paymentPercent")
            .constraint(new DigitsDef().integer(16).fraction(4))
            .field("arehousingTime")
            .field("poNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("isPrimaryKeyAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("isRequiredAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("asyncStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AsyncStatus.class))
            ;
        // seller_info
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.SellerInfo.class)
            .field("seller")
            .constraint(new LengthDef().min(0).max(200))
            .field("address")
            .constraint(new LengthDef().min(0).max(200))
            .field("tel1")
            .constraint(new LengthDef().min(0).max(190))
            .field("tel2")
            .constraint(new LengthDef().min(0).max(200))
            .field("taxNo1")
            .constraint(new LengthDef().min(0).max(200))
            .field("taxNo2")
            .constraint(new LengthDef().min(0).max(200))
            .field("bankName")
            .constraint(new LengthDef().min(0).max(200))
            .field("bankAccount")
            .constraint(new LengthDef().min(0).max(200))
            .field("isPrimaryKeyAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("isRequiredAbsent")
            .constraint(new LengthDef().min(0).max(20))
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // agent_fee_report
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AgentFeeReport.class)
            .field("loB")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesRegion")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionRegion")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameZh")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesChannel")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesBranchEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionBranchEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("ifCrossBranchProject")
            .constraint(new LengthDef().min(0).max(200))
            .field("firstOIDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesBranchVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionBranchVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("daprohProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("daprohVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentSupplierName")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentSupplierGMDSNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectEquipmentContractValue")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalProjectCollectedMoney")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionPercent")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractAmountVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionAmountVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionPercentVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeePoNumber")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAgentFeePoAmount")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAccumulativePayableAgentFee")
            .constraint(new LengthDef().min(0).max(200))
            .field("poStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAgentFeeGRAmount")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalVerifiedAgentFeeInvoiceAmountIR")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeLastInvoiceDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeInvoiceGrCheck")
            .constraint(new LengthDef().min(0).max(200))
            .field("invoiceStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("light")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeePoAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeTotalGRAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAccumulativePayableAgentFeeWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalVerifiedInvoiceAmountIrWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // agent_payment_term
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AgentPaymentTerm.class)
            .field("projectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentId")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractPaymentTermKey")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractPaymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTermDesLocal")
            .constraint(new LengthDef().min(0).max(500))
            .field("paymentTermDesEn")
            .constraint(new LengthDef().min(0).max(500))
            .field("value")
            .constraint(new LengthDef().min(0).max(200))
            .field("status")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("instanceId")
            .constraint(new LengthDef().min(0).max(200))
            ;
        // agent_fee_report_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AgentFeeReportInit.class)
            .field("loB")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesRegion")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionRegion")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameZh")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesChannel")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesBranchEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionBranchEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("ifCrossBranchProject")
            .constraint(new LengthDef().min(0).max(200))
            .field("firstOIDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesBranchVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionBranchVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("daprohProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("daprohVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentSupplierName")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentSupplierGMDSNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectEquipmentContractValue")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalProjectCollectedMoney")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionPercent")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractAmountVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionAmountVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionPercentVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeePoNumber")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAgentFeePoAmount")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAccumulativePayableAgentFee")
            .constraint(new LengthDef().min(0).max(200))
            .field("poStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAgentFeeGRAmount")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalVerifiedAgentFeeInvoiceAmountIR")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeLastInvoiceDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeInvoiceGrCheck")
            .constraint(new LengthDef().min(0).max(200))
            .field("invoiceStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("light")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeePoAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeTotalGRAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAccumulativePayableAgentFeeWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalVerifiedInvoiceAmountIrWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("asyncStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AsyncStatus.class))
            ;
        // agent_payment_term_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AgentPaymentTermInit.class)
            .field("projectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentId")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractPaymentTermKey")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractPaymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTermDesLocal")
            .constraint(new LengthDef().min(0).max(500))
            .field("paymentTermDesEn")
            .constraint(new LengthDef().min(0).max(500))
            .field("value")
            .constraint(new LengthDef().min(0).max(200))
            .field("status")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("asyncStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AsyncStatus.class))
            .field("checkField")
            .constraint(new LengthDef().min(0).max(200))
            ;
        // purchase_init_failed_history
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PurchaseInitFailedHistory.class)
            .field("poNumber")
            .constraint(new LengthDef().min(0).max(200))
            .field("currency")
            .constraint(new LengthDef().min(0).max(200))
            .field("postStatusRaw")
            .constraint(new LengthDef().min(0).max(20))
            .field("generalLedgerAccount")
            .constraint(new LengthDef().min(0).max(200))
            .field("costCenter")
            .constraint(new LengthDef().min(0).max(200))
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("buyerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("businessType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessType.class))
            .field("payedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("invoicedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("waitForInvoiceAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("deliveriedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("prepayAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("unpayedAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("buyerID")
            .constraint(new LengthDef().min(0).max(20))
            .field("failureReason")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchasingTeam")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchasingOrg")
            .constraint(new LengthDef().min(0).max(20))
            .field("prepaidAmount")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("buyerInvoiceID")
            .constraint(new LengthDef().min(0).max(20))
            .field("buyerInvoiceTitle")
            .constraint(new LengthDef().min(0).max(20))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("isCoord")
            .constraint(new LengthDef().min(0).max(20))
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceType.class))
            .field("purchaserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaserTaxNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerTaxNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaserNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("materialServices")
            .constraint(new LengthDef().min(0).max(20))
            .field("quantityUnit")
            .constraint(new LengthDef().min(0).max(20))
            .field("amountWithTaxRaw")
            .constraint(new LengthDef().min(0).max(20))
            .field("wbs")
            .constraint(new LengthDef().min(0).max(200))
            .field("materialServicesName")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractID")
            .constraint(new LengthDef().min(0).max(20))
            .field("projectName")
            .constraint(new LengthDef().min(0).max(100))
            .field("vatCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("materialServicesTeam")
            .constraint(new LengthDef().min(0).max(20))
            .field("profitsCenter")
            .constraint(new LengthDef().min(0).max(20))
            .field("viewId")
            .constraint(new LengthDef().min(0).max(20))
            .field("orderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PoStatus.class))
            .field("orderType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PurchaseOrderType.class))
            .field("item")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("isDelete")
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("postStatus")
            .constraint(new LengthDef().min(0).max(2))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", PostStatus.class))
            .field("unitPrice")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("seller")
            .constraint(new LengthDef().min(0).max(200))
            .field("isDeleteRaw")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("sellerBankNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("sellerBankName")
            .constraint(new LengthDef().min(0).max(200))
            .field("sellerAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseBankNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("purchaseBankName")
            .constraint(new LengthDef().min(0).max(200))
            .field("purchaseAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseTelephone")
            .constraint(new LengthDef().min(0).max(20))
            .field("wbsSub")
            .constraint(new LengthDef().min(0).max(200))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("factory")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // agent_fee_report_init_failed_history
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AgentFeeReportInitFailedHistory.class)
            .field("loB")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesRegion")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionRegion")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameZh")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectNameEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesChannel")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesBranchEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionBranchEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("ifCrossBranchProject")
            .constraint(new LengthDef().min(0).max(200))
            .field("firstOIDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("salesBranchVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("executionBranchVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("daprohProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("daprohVIEWProjectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentSupplierName")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentSupplierGMDSNo")
            .constraint(new LengthDef().min(0).max(200))
            .field("projectEquipmentContractValue")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalProjectCollectedMoney")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionPercent")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractAmountVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionAmountVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("collectionPercentVo")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeePoNumber")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAgentFeePoAmount")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAccumulativePayableAgentFee")
            .constraint(new LengthDef().min(0).max(200))
            .field("poStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAgentFeeGRAmount")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalVerifiedAgentFeeInvoiceAmountIR")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeLastInvoiceDate")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeInvoiceGrCheck")
            .constraint(new LengthDef().min(0).max(200))
            .field("invoiceStatus")
            .constraint(new LengthDef().min(0).max(200))
            .field("light")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeePoAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentFeeTotalGRAmountWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalAccumulativePayableAgentFeeWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("totalVerifiedInvoiceAmountIrWithTax")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            ;
        // agent_payment_term_init_failed_history
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AgentPaymentTermInitFailedHistory.class)
            .field("projectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentId")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractPaymentTermKey")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractPaymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTermDesLocal")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTermDesEn")
            .constraint(new LengthDef().min(0).max(200))
            .field("value")
            .constraint(new LengthDef().min(0).max(200))
            .field("status")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("isPrimaryKeyAbsent")
            .field("isRequiredAbsent")
            .field("absentMsg")
            .constraint(new LengthDef().min(0).max(200))
            ;
        // invoice_operation_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.InvoiceOperationLog.class)
            .field("operation")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceOperation.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("explain")
            .constraint(new LengthDef().min(0).max(200))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // prepayment_write_relation
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PrepaymentWriteRelation.class)
            .field("applyId")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(50))
            .field("impApplyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("prepaymentWriteAmount")
            .constraint(new NotNullDef())
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("prepaymentWriteVoucher")
            .constraint(new LengthDef().min(0).max(50))
            .field("prepaymentPaymentVoucher")
            .constraint(new NotNullDef())
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("paymentType")
            .constraint(new LengthDef().min(0).max(20))
            .field("paymentStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("xxx")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // settlement_order
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.SettlementOrder.class)
            .field("orderNO")
            .constraint(new LengthDef().min(0).max(30))
            .field("invoiceNoticeNO")
            .constraint(new LengthDef().min(0).max(30))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("orderStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SettlementOrderStatus.class))
            ;
        // event_record
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.EventRecord.class)
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("eventType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", EventType.class))
            .field("eventObject")
            .constraint(new LengthDef().min(0).max(100))
            .field("eventObjectId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SucceedOrError.class))
            .field("errorInfo")
            .constraint(new LengthDef().min(0).max(200))
            .field("isRetry")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", YesOrNo.class))
            .field("traceId")
            .constraint(new LengthDef().min(0).max(100))
            .field("eventObjectFieldValue")
            .constraint(new LengthDef().min(0).max(50))
            .field("eventObjectFieldKey")
            .constraint(new LengthDef().min(0).max(50))
            ;
        // settlement
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.Settlement.class)
            .field("settlementNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            .field("settlementStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SettlementOrderStatus.class))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(18).fraction(2))
            ;
        // code_generator
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.CodeGenerator.class)
            .field("type")
            .constraint(new LengthDef().min(0).max(10))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", CodeType.class))
            .field("prefix")
            .constraint(new LengthDef().min(0).max(10))
            .field("value")
            .constraint(new LengthDef().min(0).max(40))
            .field("suffix")
            .constraint(new LengthDef().min(0).max(10))
            .field("version")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // flow_instance_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.FlowInstanceLog.class)
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("instanceId")
            .constraint(new LengthDef().min(0).max(36))
            .field("flowCode")
            .constraint(new LengthDef().min(0).max(64))
            .field("errorMsg")
            .constraint(new LengthDef().min(0).max(512))
            .field("exceptionTrace")
            .constraint(new LengthDef().min(0).max(4096))
            .field("errorNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("rollback")
            .field("snapshot")
            .constraint(new LengthDef().min(0).max(4096))
            .field("snapshotFormat")
            .constraint(new LengthDef().min(0).max(128))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SnaphostFormat.class))
            .field("rollbackNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("flowName")
            .constraint(new LengthDef().min(0).max(50))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", FlowStatus.class))
            .field("startSnapshot")
            .constraint(new LengthDef().min(0).max(4096))
            .field("startSnapshotFormat")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SnaphostFormat.class))
            ;
        // flow_replay_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.FlowReplayLog.class)
            .field("flowInstanceId")
            .constraint(new LengthDef().min(0).max(36))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("flowCode")
            .constraint(new LengthDef().min(0).max(64))
            .field("errorMsg")
            .constraint(new LengthDef().min(0).max(512))
            .field("exceptionTrace")
            .constraint(new LengthDef().min(0).max(4096))
            .field("errorNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("rollback")
            .field("rollbackNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", FlowStatus.class))
            ;
        // email_record
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.EmailRecord.class)
            .field("subject")
            .constraint(new LengthDef().min(0).max(2000))
            .field("receiverEmail")
            .constraint(new LengthDef().min(0).max(1000))
            .field("succeedOrError")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SucceedOrError.class))
            .field("errorInfo")
            .constraint(new LengthDef().min(0).max(2000))
            .field("count")
            .constraint(new DigitsDef().integer(10).fraction(0))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("emailSendScene")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", EmailSendScene.class))
            .field("content")
            .constraint(new LengthDef().min(0).max(5000))
            .field("number")
            .constraint(new LengthDef().min(0).max(200))
            .field("receiverUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            ;
        // order_handle_record
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.OrderHandleRecord.class)
            .field("orderTypeCode")
            .constraint(new LengthDef().min(0).max(50))
            .field("orderId")
            .constraint(new LengthDef().min(0).max(40))
            .field("orderCode")
            .constraint(new LengthDef().min(0).max(40))
            .field("originValue")
            .constraint(new LengthDef().min(0).max(200))
            .field("currentValue")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // buyer_mapping
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.BuyerMapping.class)
            .field("buyerID")
            .constraint(new LengthDef().min(0).max(20))
            .field("factory")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("name")
            .constraint(new LengthDef().min(0).max(50))
            ;
        // payment_power_bi_init
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.PaymentPowerBiInit.class)
            .field("projectId")
            .constraint(new LengthDef().min(0).max(200))
            .field("agentId")
            .constraint(new LengthDef().min(0).max(200))
            .field("contractPaymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTerm")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentTermDesLocal")
            .constraint(new LengthDef().min(0).max(200))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("status")
            .constraint(new LengthDef().min(0).max(200))
            .field("paymentId")
            .constraint(new DigitsDef().integer(50).fraction(0))
            .field("applyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("agentPaymentTermId")
            .constraint(new DigitsDef().integer(50).fraction(0))
            ;
        // producer
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.Producer.class)
            .field("produceObj")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceObj.class))
            .field("produceStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceStatus.class))
            .field("produceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceType.class))
            .field("produceSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceSource.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("produceMessage")
            .constraint(new LengthDef().min(0).max(10000))
            .field("serialNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("businessKey")
            .constraint(new LengthDef().min(0).max(50))
            ;
        // customer
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.Customer.class)
            .field("customerMessage")
            .constraint(new LengthDef().min(0).max(10000))
            .field("serialNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("produceObj")
            .constraint(new LengthDef().min(0).max(20))
            .field("produceType")
            .constraint(new LengthDef().min(0).max(20))
            .field("produceSource")
            .constraint(new LengthDef().min(0).max(20))
            .field("customerObj")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceObj.class))
            .field("customerStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceStatus.class))
            .field("customerType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceType.class))
            .field("customerSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceSource.class))
            .field("businessKey")
            .constraint(new LengthDef().min(0).max(50))
            ;
        // dispatcher_rule_config
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.DispatcherRuleConfig.class)
            .field("produceObj")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceObj.class))
            .field("produceType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceType.class))
            .field("produceSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceSource.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("isOpen")
            .field("consumerObj")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceObj.class))
            .field("consumerType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceType.class))
            .field("consumerSource")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceSource.class))
            ;
        // notice_bill_handle_record
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.NoticeBillHandleRecord.class)
            .field("invoiceNoticeNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("handlePerson")
            .constraint(new LengthDef().min(0).max(50))
            .field("handleType")
            .constraint(new LengthDef().min(0).max(50))
            .field("handleRemark")
            .constraint(new LengthDef().min(0).max(200))
            .field("originStatus")
            .constraint(new LengthDef().min(0).max(30))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessStatus.class))
            .field("currentStatus")
            .constraint(new LengthDef().min(0).max(30))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BusinessStatus.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // auto_goods_recode
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AutoGoodsRecode.class)
            .field("taskId")
            .constraint(new LengthDef().min(0).max(50))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("autoGoodsType")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", AutoGoodsType.class))
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("applyId")
            .constraint(new LengthDef().min(0).max(50))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", ProduceStatus.class))
            .field("errorInfo")
            .constraint(new LengthDef().min(0).max(200))
            .field("response")
            .constraint(new LengthDef().min(0).max(200))
            .field("approvalBody")
            .constraint(new LengthDef().min(0).max(200))
            ;
        // auto_goods_recode_item
        constraintMapping
            .type(com.xforceplus.ultraman.app.jctke.metadata.entity.AutoGoodsRecodeItem.class)
            .field("grNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("grItemNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(20))
            .field("poItemNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceNoticeNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("invoiceNoticeItemNo")
            .constraint(new LengthDef().min(0).max(50))
            .field("quantity")
            .constraint(new DigitsDef().integer(14).fraction(6))
            .field("messageType")
            .constraint(new LengthDef().min(0).max(20))
            .field("messageText")
            .constraint(new LengthDef().min(0).max(200))
            ;
    }
}
