package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 记账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum AccountStatus {

    _0("0", "未记账"),
    _1("1", "已记账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AccountStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountStatus fromCode(String code) {
        return Stream.of(AccountStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
