package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 备用金金额右边界符号
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum AmountRightBorderSymbol {

    _1("1", " "),
    _2("2", "<"),
    _3("3", "<=");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AmountRightBorderSymbol(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AmountRightBorderSymbol fromCode(String code) {
        return Stream.of(AmountRightBorderSymbol.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
