package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 邮件发送场景
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum EmailSendScene {

    REJECT("reject", "应付单预付单驳回通知"),
    F47_ERROR("F47Error", "F-47执行报错通知"),
    M_I_R_O_ERROR("MIROError", "MIRO执行报错通知"),
    BACK("back", "发票登记表总部财务退回通知"),
    ISSUE_AN_INVOICE_INFORM("issueAnInvoiceInform", "发票开具通知"),
    INVOICE_NOTICE_BILL("invoiceNoticeBill", "开票通知单通知"),
    PAYMENT_SUBMIT_NOTIFY("paymentSubmitNotify", "应付单提交通知");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EmailSendScene(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EmailSendScene fromCode(String code) {
        return Stream.of(EmailSendScene.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
