package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款人类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum PaymentUserType {

    _0("0", "默认"),
    _1("1", "客户"),
    _2("2", "第三方");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PaymentUserType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentUserType fromCode(String code) {
        return Stream.of(PaymentUserType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
