package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * RPA任务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum TaskType {

    _1("1", "紧急PO拉取"),
    _2("2", "F-47-预付款请求生成"),
    _3("3", "MIRO-应付款凭证生成"),
    _4("4", "F-44-核销处理"),
    _5("5", "F-51-虚拟PO凭证生成+逆向冲销"),
    _6("6", "FBRA-逆向预付款不换PO处理"),
    _7("7", "FBL1N-付款凭证及日期获取"),
    _8("8", "FB08-预付凭证撤回"),
    _9("9", "MR8M-应付凭证撤回"),
    _10("10", "QUERYAR-AR数据获取");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code) {
        return Stream.of(TaskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
