package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_init_failed_history
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseInitFailedHistory implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 采购单号
   */
  private String poNumber;
  /**
   * 货币
   */
  private String currency;
  /**
   * 发布状态Raw
   */
  private String postStatusRaw;
  /**
   * 总帐科目
   */
  private String generalLedgerAccount;
  /**
   * 成本中心
   */
  private String costCenter;
  /**
   * 主键缺失
   */
  private Boolean isPrimaryKeyAbsent;
  /**
   * 必填项缺失
   */
  private Boolean isRequiredAbsent;
  /**
   * 缺失信息描述
   */
  private String absentMsg;
  /**
   * 销方编号
   */
  private String sellerNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 执行分公司
   */
  private String buyerName;
  /**
   * 业务类型
   */
  private String businessType;
  /**
   * 已付款金额
   */
  private BigDecimal payedAmount;
  /**
   * 已开票金额
   */
  private BigDecimal invoicedAmount;
  /**
   * 待开票金额
   */
  private BigDecimal waitForInvoiceAmount;
  /**
   * 已收货金额
   */
  private BigDecimal deliveriedAmount;
  /**
   * 预付金额
   */
  private BigDecimal prepayAmount;
  /**
   * 未付金额
   */
  private BigDecimal unpayedAmount;
  /**
   * 执行分公司Id
   */
  private String buyerID;
  /**
   * 失败原因
   */
  private String failureReason;
  /**
   * 采购组
   */
  private String purchasingTeam;
  /**
   * 采购组织
   */
  private String purchasingOrg;
  /**
   * 已预付待核销金额
   */
  private BigDecimal prepaidAmount;
  /**
   * 发票分公司Id
   */
  private String buyerInvoiceID;
  /**
   * 发票分公司
   */
  private String buyerInvoiceTitle;
  /**
   * 订单总价值
   */
  private BigDecimal amountWithTax;
  /**
   * 协同关系
   */
  private String isCoord;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 物料编号
   */
  private String materialServices;
  /**
   * 订单单位
   */
  private String quantityUnit;
  /**
   * 含税金额Raw
   */
  private String amountWithTaxRaw;
  /**
   * WBS
   */
  private String wbs;
  /**
   * 物料名称
   */
  private String materialServicesName;
  /**
   * 合同号
   */
  private String contractID;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 税码
   */
  private String vatCode;
  /**
   * 物料组
   */
  private String materialServicesTeam;
  /**
   * 利润中心
   */
  private String profitsCenter;
  /**
   * View Id
   */
  private String viewId;
  /**
   * 订单状态
   */
  private String orderStatus;
  /**
   * 订单类型
   */
  private String orderType;
  /**
   * 行号
   */
  private Long item;
  /**
   * 删除标记
   */
  private Boolean isDelete;
  /**
   * 数量
   */
  private BigDecimal quantity;
  /**
   * 发布状态
   */
  private String postStatus;
  /**
   * 净价
   */
  private BigDecimal unitPrice;
  /**
   * 供应商/供应工厂
   */
  private String seller;
  /**
   * 删除标记Raw
   */
  private String isDeleteRaw;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 销方银行账号
   */
  private String sellerBankNo;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方联系电话
   */
  private String sellerTelephone;
  /**
   * 购方银行账号
   */
  private String purchaseBankNo;
  /**
   * 购方银行名称
   */
  private String purchaseBankName;
  /**
   * 购方地址
   */
  private String purchaseAddress;
  /**
   * 购方联系电话
   */
  private String purchaseTelephone;
  /**
   * wbs切割值
   */
  private String wbsSub;
  /**
   * 订单净值
   */
  private BigDecimal amountWithoutTax;
  /**
   * 工厂
   */
  private String factory;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("currency", currency);
      map.put("postStatusRaw", postStatusRaw);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("costCenter", costCenter);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("businessType", businessType);
      map.put("payedAmount", payedAmount);
      map.put("invoicedAmount", invoicedAmount);
      map.put("waitForInvoiceAmount", waitForInvoiceAmount);
      map.put("deliveriedAmount", deliveriedAmount);
      map.put("prepayAmount", prepayAmount);
      map.put("unpayedAmount", unpayedAmount);
      map.put("buyerID", buyerID);
      map.put("failureReason", failureReason);
      map.put("purchasingTeam", purchasingTeam);
      map.put("purchasingOrg", purchasingOrg);
      map.put("prepaidAmount", prepaidAmount);
      map.put("buyerInvoiceID", buyerInvoiceID);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("amountWithTax", amountWithTax);
      map.put("isCoord", isCoord);
      map.put("invoiceType", invoiceType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserNo", purchaserNo);
      map.put("materialServices", materialServices);
      map.put("quantityUnit", quantityUnit);
      map.put("amountWithTaxRaw", amountWithTaxRaw);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("contractID", contractID);
      map.put("projectName", projectName);
      map.put("vatCode", vatCode);
      map.put("materialServicesTeam", materialServicesTeam);
      map.put("profitsCenter", profitsCenter);
      map.put("viewId", viewId);
      map.put("orderStatus", orderStatus);
      map.put("orderType", orderType);
      map.put("item", item);
      map.put("isDelete", isDelete);
      map.put("quantity", quantity);
      map.put("postStatus", postStatus);
      map.put("unitPrice", unitPrice);
      map.put("seller", seller);
      map.put("isDeleteRaw", isDeleteRaw);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTelephone", sellerTelephone);
      map.put("purchaseBankNo", purchaseBankNo);
      map.put("purchaseBankName", purchaseBankName);
      map.put("purchaseAddress", purchaseAddress);
      map.put("purchaseTelephone", purchaseTelephone);
      map.put("wbsSub", wbsSub);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("factory", factory);

      return map;
  }

  public static PurchaseInitFailedHistory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseInitFailedHistory entity = new PurchaseInitFailedHistory();

    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatusRaw")) {
      Object obj = map.get("postStatusRaw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostStatusRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitForInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWaitForInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeliveriedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeliveriedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeliveriedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveriedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeliveriedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrepayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnpayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnpayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnpayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnpayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnpayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFailureReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrepaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isCoord")) {
      Object obj = map.get("isCoord");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCoord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxRaw")) {
      Object obj = map.get("amountWithTaxRaw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTaxRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDeleteRaw")) {
      Object obj = map.get("isDeleteRaw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsDeleteRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbsSub")) {
      Object obj = map.get("wbsSub");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWbsSub((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactory((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatusRaw")) {
      Object obj = map.get("postStatusRaw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPostStatusRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setWaitForInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setWaitForInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setWaitForInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setWaitForInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setWaitForInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDeliveriedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDeliveriedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDeliveriedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeliveriedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDeliveriedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrepayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrepayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrepayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrepayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrepayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnpayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnpayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnpayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnpayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnpayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFailureReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrepaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrepaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrepaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrepaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrepaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isCoord")) {
      Object obj = map.get("isCoord");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsCoord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxRaw")) {
      Object obj = map.get("amountWithTaxRaw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmountWithTaxRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setItem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDeleteRaw")) {
      Object obj = map.get("isDeleteRaw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsDeleteRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbsSub")) {
      Object obj = map.get("wbsSub");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWbsSub((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFactory((String)obj);
        }
      } else{
      }
    }
  }
}
