package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款单操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-09
 */
public enum ApprovalStatus {

    _0("0", "驳回"),
    _1("1", "通过"),
    _2("2", "提交"),
    _3("3", "撤回"),
    _4("4", "FBL1N"),
    _5("5", "FB08"),
    _6("6", "MR8M"),
    _7("7", "F44"),
    _8("8", "F47"),
    _9("9", "F51"),
    _10("10", "FBRA"),
    _11("11", "MIRO"),
    _12("12", "配单"),
    _13("13", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApprovalStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApprovalStatus fromCode(String code) {
        return Stream.of(ApprovalStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
