package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 票据类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2023-03-09
 */
public enum ENumReceiptType {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    CE("ce", "增值税电子普通发票"),
    SE("se", "增值税电子专用发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ENumReceiptType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ENumReceiptType fromCode(String code) {
        return Stream.of(ENumReceiptType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
