package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办来源
 * </p>
 *
 * @author ultraman
 * @since 2023-03-09
 */
public enum ProduceSource {

    _1("1", "采购单预处理"),
    _2("2", "收货单预处理"),
    _3("3", "采购单更新处理"),
    _4("4", "开票通知单自动创建处理"),
    _5("5", "发票更新处理"),
    _6("6", "收货单更新处理"),
    _7("7", "收货单新增处理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProduceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceSource fromCode(String code) {
        return Stream.of(ProduceSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
