package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * RPA任务SAP状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-09
 */
public enum RpaResponseStatus {

    _1("1", "审核通过"),
    _2("2", "审核驳回"),
    _3("3", "支付成功"),
    _4("4", "支付失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RpaResponseStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RpaResponseStatus fromCode(String code) {
        return Stream.of(RpaResponseStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
