package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * RPA任务状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-09
 */
public enum RpaStatus {

    _0("0", "待处理"),
    _1("1", "已完成"),
    _2("2", "已取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RpaStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RpaStatus fromCode(String code) {
        return Stream.of(RpaStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
