package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是与否
 * </p>
 *
 * @author ultraman
 * @since 2023-03-09
 */
public enum YesOrNo {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    YesOrNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YesOrNo fromCode(String code) {
        return Stream.of(YesOrNo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
