package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 总账标识
 * </p>
 *
 * @author ultraman
 * @since 2023-04-23
 */
public enum LedgerType {

    D("D", "无PO预付，其他押金"),
    B("B", "投标保证金（销售/安装/维保）"),
    A("A", "其它，含PO预付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LedgerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LedgerType fromCode(String code) {
        return Stream.of(LedgerType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
