package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发布状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-23
 */
public enum PostStatus {

    _0("0", "待审批"),
    _1("1", "已审批");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PostStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PostStatus fromCode(String code) {
        return Stream.of(PostStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
