package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 采购订单类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-23
 */
public enum PurchaseOrderType {

    _0("0", "常规订单"),
    _1("1", "框架采购单"),
    _2("2", "虚拟采购单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PurchaseOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaseOrderType fromCode(String code) {
        return Stream.of(PurchaseOrderType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
