package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 流程状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-13
 */
public enum FlowStatus {

    _0("0", "失败"),
    _1("1", "成功"),
    SUCCESS("success", "成功"),
    FAILED("failed", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FlowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FlowStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "success":
                return SUCCESS;
            case "failed":
                return FAILED;
            default:
                return null;
        }
    }
}
