package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 采购单状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-13
 */
public enum PoStatus {

    _0("0", "数据异常"),
    _1("1", "正常"),
    _2("2", "已关闭"),
    _3("3", "已锁定"),
    _4("4", "待处理"),
    _5("5", "待提交"),
    _99("99", "在途");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PoStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PoStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
