package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 支付状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-15
 */
public enum PayStatus {

    _0("0", "未付款"),
    _1("1", "付款中"),
    _2("2", "已付款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PayStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayStatus fromCode(String code) {
        return Stream.of(PayStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
