package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 备用金类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-15
 */
public enum PettyCashType {

    _1("1", "差旅费及小额交际"),
    _2("2", "行政费用"),
    _3("3", "营业税及其它税金附加费"),
    _4("4", "验收费"),
    _5("5", "诉讼费");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PettyCashType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PettyCashType fromCode(String code) {
        return Stream.of(PettyCashType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
