package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预付款类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-15
 */
public enum PrepaymentType {

    _0("0", "无类型"),
    _1("1", "诉讼费"),
    _2("2", "备用金"),
    _3("3", "保证金（销售）"),
    _4("4", "保证金（维保）"),
    _5("5", "其他"),
    _6("6", "押金");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PrepaymentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PrepaymentType fromCode(String code) {
        return Stream.of(PrepaymentType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
