package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 结算单状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-15
 */
public enum SettlementOrderStatus {

    _1("1", "正常"),
    _2("2", "作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SettlementOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementOrderStatus fromCode(String code) {
        return Stream.of(SettlementOrderStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
