package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-23
 */
public enum AuthStatus {

    _0("0", "默认"),
    _1("1", "不可认证"),
    _2("2", "未认证"),
    _3("3", "认证中"),
    _4("4", "认证成功"),
    _5("5", "认证失败"),
    _6("6", "认证异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStatus fromCode(String code) {
        return Stream.of(AuthStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
