package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * payment_bank_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-23
 */
public enum PaymentBankType {

    _1("1", "总部DB"),
    _2("2", "分公司DB"),
    _3("3", "分公司基本户"),
    _4("4", "总部ICBC"),
    _5("5", "总部CMB南西支行"),
    _6("6", "总部CMB曹家渡支行");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PaymentBankType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentBankType fromCode(String code) {
        return Stream.of(PaymentBankType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
