package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * removed
 * </p>
 *
 * @author ultraman
 * @since 2024-01-23
 */
public enum Removed {

    NOT_REMOVED("NOT_REMOVED", "已导入"),
    REMOVED("REMOVED", "已清除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Removed(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Removed fromCode(String code) {
        return Stream.of(Removed.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
