package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * change_ticket_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-24
 */
public enum ChangeTicketType {

    _0("0", "默认"),
    _1("1", "换票"),
    _2("2", "不换票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChangeTicketType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChangeTicketType fromCode(String code) {
        return Stream.of(ChangeTicketType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
