package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * code_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-24
 */
public enum CodeType {

    L_1("L_1", "虚拟采购单号"),
    I_1("I_1", "归档序列号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CodeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CodeType fromCode(String code) {
        return Stream.of(CodeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
