package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * entity_code
 * </p>
 *
 * @author ultraman
 * @since 2024-01-24
 */
public enum EntityCode {

    PURCHASE_ORDER("purchaseOrder", "采购单"),
    INVOICE_NOTICE_BILL("invoiceNoticeBill", "开票通知单"),
    PAYMENT_MANAGE("paymentManage", "付款申请单"),
    INVOICE("invoice", "发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EntityCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EntityCode fromCode(String code) {
        return Stream.of(EntityCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
