package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_register_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-24
 */
public enum InvoiceRegisterStatus {

    _0("0", "作废"),
    _1("1", "正常"),
    _3("3", "红冲"),
    _8("8", "失控"),
    _4("4", "部分红冲"),
    _7("7", "异常"),
    _9("9", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceRegisterStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceRegisterStatus fromCode(String code) {
        return Stream.of(InvoiceRegisterStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
