package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice
 * </p>
 *
 * @author ultraman
 * @since 2024-01-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Invoice implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 结算单号
   */
  private String preNO;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 业务状态
   */
  private String invoiceStatus;
  /**
   * 发票影像
   */
  private String invoiceUrl;
  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrawDate;
  /**
   * 寄送日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendDate;
  /**
   * 收票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptDate;
  /**
   * 提交应付单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime submitDate;
  /**
   * 应付过账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;
  /**
   * 支付日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 执行分公司
   */
  private String buyerName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 快递单号
   */
  private String expressNumber;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 销方编号
   */
  private String sellerNo;
  /**
   * 执行分公司ID
   */
  private String buyerID;
  /**
   * 申请支付金额
   */
  private BigDecimal applyPayAmount;
  /**
   * 凭证号 
   */
  private String voucherNo;
  /**
   * 凭证文本
   */
  private String voucherText;
  /**
   * 付款基准日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payBaseDay;
  /**
   * 实际付款日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualPayDay;
  /**
   * 认证日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authDate;
  /**
   * 付款单号
   */
  private String paymentNo;
  /**
   * PO号
   */
  private String poNo;
  /**
   * 记账状态
   */
  private String accountStatus;
  /**
   * 付款状态
   */
  private String payStatus;
  /**
   * 已支付金额
   */
  private BigDecimal paidAmount;
  /**
   * 付款金额
   */
  private BigDecimal invoicePayAmount;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 销方地址电话
   */
  private String sellerAddrTel;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方银行账号
   */
  private String sellerBankNo;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;
  /**
   * 购方地址
   */
  private String purchaserAddress;
  /**
   * 购方电话
   */
  private String purchaserTel;
  /**
   * 购方银行名称
   */
  private String purchaserBankName;
  /**
   * 购方银行账号
   */
  private String purchaserBankNo;
  /**
   * 备注
   */
  private String remark;
  /**
   * 复核人姓名
   */
  private String checkerName;
  /**
   * 开票人姓名
   */
  private String invoicerName;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 红字信息表编号
   */
  private String redNotificationNo;
  /**
   * 认证所属期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxDeclarationPeriod;
  /**
   * 扫描时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanTime;
  /**
   * 抵扣联影像ID
   */
  private String scanDeductionImageUrl;
  /**
   * 发票联影像ID
   */
  private String scanInvoiceImageUrl;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 发票状态
   */
  private String status;
  /**
   * 认证状态
   */
  private String authStatus;
  /**
   * 验真标志
   */
  private String taxFlag;
  /**
   * 扫描状态
   */
  private String scanStatus;
  /**
   * 初始来源(废弃)
   */
  private String source;
  /**
   * 开票通知单号
   */
  private String invoiceNoticeNos;
  /**
   * 发票ID
   */
  private String invoiceId;
  /**
   * 采购组
   */
  private String purchasingTeam;
  /**
   * 寄送次数
   */
  private Long sendCount;
  /**
   * 退回次数	
   */
  private Long backCount;
  /**
   * 是否推荐
   */
  private Boolean recommendationFlag;
  /**
   * 已配单含税金额
   */
  private BigDecimal matchedAmount;
  /**
   * 记账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountDate;
  /**
   * 关联次数
   */
  private Long relationCount;
  /**
   * 最近来源
   */
  private String lastSource;
  /**
   * 源文件类型(0-无源文件 1-PDF 2-OFD)
   */
  private String originFile;
  /**
   * 源文件地址
   */
  private String originFileUrl;
  /**
   * 退回原因
   */
  private String returnReason;
  /**
   * 初始可配单含税金额
   */
  private BigDecimal availableAmount;
  /**
   * 序列号#已废弃
   */
  private String serialNo;
  /**
   * 是否代开
   */
  private String isReplace;
  /**
   * 代开销方名称
   */
  private String replaceSellerName;
  /**
   * 代开销方税号
   */
  private String replaceSellerTaxNo;
  /**
   * 原销方名称
   */
  private String originSellerName;
  /**
   * 原销方税号
   */
  private String originSellerTaxNo;
  /**
   * 初始可配单不含税金额
   */
  private BigDecimal availableAmountWithoutTax;
  /**
   * 影像ID
   */
  private String imageId;
  /**
   * 协同类型
   */
  private String coordinationType;
  /**
   * 已配单不含税金额
   */
  private BigDecimal matchedAmountWithoutTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 采购单号
   */
  private String poNumbers;
  /**
   * 数据来源
   */
  private String dataSource;
  /**
   * 供应商租户ID
   */
  private String sellerGroupId;
  /**
   * 是否锁定
   */
  private Boolean lockFlag;
  /**
   * 归档序列号
   */
  private String archiveNo;
  /**
   * 退回方式
   */
  private String withdrawType;
  /**
   * IRID
   */
  private String irid;
  /**
   * 删除状态
   */
  private String isRemoved;
  /**
   * 配单更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime matchUpdateTime;

  /**
   * 对一关联关系 关联对象 settlement
   */
  private Long settlementIdId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("preNO", preNO);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceType", invoiceType);
      map.put("invoiceStatus", invoiceStatus);
      map.put("invoiceUrl", invoiceUrl);
      map.put("paperDrawDate", BocpGenUtils.toTimestamp(paperDrawDate));
      map.put("sendDate", BocpGenUtils.toTimestamp(sendDate));
      map.put("receiptDate", BocpGenUtils.toTimestamp(receiptDate));
      map.put("submitDate", BocpGenUtils.toTimestamp(submitDate));
      map.put("postingDate", BocpGenUtils.toTimestamp(postingDate));
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("expressNumber", expressNumber);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("sellerNo", sellerNo);
      map.put("buyerID", buyerID);
      map.put("applyPayAmount", applyPayAmount);
      map.put("voucherNo", voucherNo);
      map.put("voucherText", voucherText);
      map.put("payBaseDay", BocpGenUtils.toTimestamp(payBaseDay));
      map.put("actualPayDay", BocpGenUtils.toTimestamp(actualPayDay));
      map.put("authDate", BocpGenUtils.toTimestamp(authDate));
      map.put("paymentNo", paymentNo);
      map.put("poNo", poNo);
      map.put("accountStatus", accountStatus);
      map.put("payStatus", payStatus);
      map.put("paidAmount", paidAmount);
      map.put("invoicePayAmount", invoicePayAmount);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankNo", purchaserBankNo);
      map.put("remark", remark);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redNotificationNo", redNotificationNo);
      map.put("taxDeclarationPeriod", BocpGenUtils.toTimestamp(taxDeclarationPeriod));
      map.put("scanTime", BocpGenUtils.toTimestamp(scanTime));
      map.put("scanDeductionImageUrl", scanDeductionImageUrl);
      map.put("scanInvoiceImageUrl", scanInvoiceImageUrl);
      map.put("purchaserNo", purchaserNo);
      map.put("status", status);
      map.put("authStatus", authStatus);
      map.put("taxFlag", taxFlag);
      map.put("scanStatus", scanStatus);
      map.put("source", source);
      map.put("invoiceNoticeNos", invoiceNoticeNos);
      map.put("invoiceId", invoiceId);
      map.put("purchasingTeam", purchasingTeam);
      map.put("sendCount", sendCount);
      map.put("backCount", backCount);
      map.put("recommendationFlag", recommendationFlag);
      map.put("matchedAmount", matchedAmount);
      map.put("account_date", BocpGenUtils.toTimestamp(accountDate));
      map.put("relationCount", relationCount);
      map.put("lastSource", lastSource);
      map.put("originFile", originFile);
      map.put("originFileUrl", originFileUrl);
      map.put("returnReason", returnReason);
      map.put("availableAmount", availableAmount);
      map.put("serialNo", serialNo);
      map.put("isReplace", isReplace);
      map.put("replaceSellerName", replaceSellerName);
      map.put("replaceSellerTaxNo", replaceSellerTaxNo);
      map.put("originSellerName", originSellerName);
      map.put("originSellerTaxNo", originSellerTaxNo);
      map.put("availableAmountWithoutTax", availableAmountWithoutTax);
      map.put("imageId", imageId);
      map.put("coordinationType", coordinationType);
      map.put("matchedAmountWithoutTax", matchedAmountWithoutTax);
      map.put("taxRate", taxRate);
      map.put("poNumbers", poNumbers);
      map.put("dataSource", dataSource);
      map.put("sellerGroupId", sellerGroupId);
      map.put("lockFlag", lockFlag);
      map.put("archiveNo", archiveNo);
      map.put("withdrawType", withdrawType);
      map.put("irid", irid);
      map.put("isRemoved", isRemoved);
      map.put("matchUpdateTime", BocpGenUtils.toTimestamp(matchUpdateTime));

      map.put("settlementId.id", settlementIdId);
      return map;
  }

  public static Invoice fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Invoice entity = new Invoice();

    if(map.containsKey("preNO")) {
      Object obj = map.get("preNO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendDate(null);
      }
    }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptDate(null);
      }
    }
    if(map.containsKey("submitDate")) {
      Object obj = map.get("submitDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSubmitDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSubmitDate(null);
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPayAmount")) {
      Object obj = map.get("applyPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherText")) {
      Object obj = map.get("voucherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payBaseDay")) {
      Object obj = map.get("payBaseDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayBaseDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPayBaseDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayBaseDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayBaseDay(null);
      }
    }
    if(map.containsKey("actualPayDay")) {
      Object obj = map.get("actualPayDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualPayDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setActualPayDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualPayDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActualPayDay(null);
      }
    }
    if(map.containsKey("authDate")) {
      Object obj = map.get("authDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthDate(null);
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountStatus")) {
      Object obj = map.get("accountStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payStatus")) {
      Object obj = map.get("payStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePayAmount")) {
      Object obj = map.get("invoicePayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNo")) {
      Object obj = map.get("purchaserBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDeclarationPeriod")) {
      Object obj = map.get("taxDeclarationPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxDeclarationPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxDeclarationPeriod(null);
      }
    }
    if(map.containsKey("scanTime")) {
      Object obj = map.get("scanTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScanTime(null);
      }
    }
    if(map.containsKey("scanDeductionImageUrl")) {
      Object obj = map.get("scanDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScanDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanInvoiceImageUrl")) {
      Object obj = map.get("scanInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScanInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxFlag")) {
      Object obj = map.get("taxFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanStatus")) {
      Object obj = map.get("scanStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScanStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNos")) {
      Object obj = map.get("invoiceNoticeNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNoticeNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendCount")) {
      Object obj = map.get("sendCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSendCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSendCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("backCount")) {
      Object obj = map.get("backCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBackCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBackCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBackCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recommendationFlag")) {
      Object obj = map.get("recommendationFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRecommendationFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecommendationFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("matchedAmount")) {
      Object obj = map.get("matchedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("account_date")) {
      Object obj = map.get("account_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountDate(null);
      }
    }
    if(map.containsKey("relationCount")) {
      Object obj = map.get("relationCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRelationCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRelationCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRelationCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lastSource")) {
      Object obj = map.get("lastSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originFile")) {
      Object obj = map.get("originFile");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originFileUrl")) {
      Object obj = map.get("originFileUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnReason")) {
      Object obj = map.get("returnReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableAmount")) {
      Object obj = map.get("availableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isReplace")) {
      Object obj = map.get("isReplace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsReplace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replaceSellerName")) {
      Object obj = map.get("replaceSellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplaceSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replaceSellerTaxNo")) {
      Object obj = map.get("replaceSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplaceSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originSellerName")) {
      Object obj = map.get("originSellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originSellerTaxNo")) {
      Object obj = map.get("originSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableAmountWithoutTax")) {
      Object obj = map.get("availableAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAvailableAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAvailableAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAvailableAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAvailableAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAvailableAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coordinationType")) {
      Object obj = map.get("coordinationType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCoordinationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchedAmountWithoutTax")) {
      Object obj = map.get("matchedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNumbers")) {
      Object obj = map.get("poNumbers");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNumbers((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerGroupId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLockFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLockFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("archiveNo")) {
      Object obj = map.get("archiveNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArchiveNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("withdrawType")) {
      Object obj = map.get("withdrawType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWithdrawType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("irid")) {
      Object obj = map.get("irid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIrid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRemoved")) {
      Object obj = map.get("isRemoved");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsRemoved((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchUpdateTime")) {
      Object obj = map.get("matchUpdateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setMatchUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMatchUpdateTime(null);
      }
    }

    if(map.containsKey("settlementId.id")) {
       Object obj = map.get("settlementId.id");
       if(obj instanceof Long) {
         entity.setSettlementIdId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setSettlementIdId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("preNO")) {
      Object obj = map.get("preNO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPreNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSendDate(null);
      }
    }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReceiptDate(null);
      }
    }
    if(map.containsKey("submitDate")) {
      Object obj = map.get("submitDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSubmitDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSubmitDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSubmitDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSubmitDate(null);
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPostingDate(null);
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPayAmount")) {
      Object obj = map.get("applyPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setApplyPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setApplyPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setApplyPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApplyPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setApplyPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherText")) {
      Object obj = map.get("voucherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVoucherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payBaseDay")) {
      Object obj = map.get("payBaseDay");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPayBaseDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPayBaseDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPayBaseDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPayBaseDay(null);
      }
    }
    if(map.containsKey("actualPayDay")) {
      Object obj = map.get("actualPayDay");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setActualPayDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setActualPayDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setActualPayDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setActualPayDay(null);
      }
    }
    if(map.containsKey("authDate")) {
      Object obj = map.get("authDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthDate(null);
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountStatus")) {
      Object obj = map.get("accountStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payStatus")) {
      Object obj = map.get("payStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePayAmount")) {
      Object obj = map.get("invoicePayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoicePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoicePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoicePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoicePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoicePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNo")) {
      Object obj = map.get("purchaserBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDeclarationPeriod")) {
      Object obj = map.get("taxDeclarationPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTaxDeclarationPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTaxDeclarationPeriod(null);
      }
    }
    if(map.containsKey("scanTime")) {
      Object obj = map.get("scanTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setScanTime(null);
      }
    }
    if(map.containsKey("scanDeductionImageUrl")) {
      Object obj = map.get("scanDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setScanDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanInvoiceImageUrl")) {
      Object obj = map.get("scanInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setScanInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxFlag")) {
      Object obj = map.get("taxFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanStatus")) {
      Object obj = map.get("scanStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setScanStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNos")) {
      Object obj = map.get("invoiceNoticeNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNoticeNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendCount")) {
      Object obj = map.get("sendCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSendCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSendCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSendCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("backCount")) {
      Object obj = map.get("backCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBackCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBackCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBackCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recommendationFlag")) {
      Object obj = map.get("recommendationFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setRecommendationFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRecommendationFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("matchedAmount")) {
      Object obj = map.get("matchedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMatchedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMatchedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMatchedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMatchedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMatchedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("account_date")) {
      Object obj = map.get("account_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAccountDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountDate(null);
      }
    }
    if(map.containsKey("relationCount")) {
      Object obj = map.get("relationCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRelationCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRelationCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRelationCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lastSource")) {
      Object obj = map.get("lastSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originFile")) {
      Object obj = map.get("originFile");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originFileUrl")) {
      Object obj = map.get("originFileUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnReason")) {
      Object obj = map.get("returnReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReturnReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableAmount")) {
      Object obj = map.get("availableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isReplace")) {
      Object obj = map.get("isReplace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsReplace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replaceSellerName")) {
      Object obj = map.get("replaceSellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReplaceSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replaceSellerTaxNo")) {
      Object obj = map.get("replaceSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReplaceSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originSellerName")) {
      Object obj = map.get("originSellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originSellerTaxNo")) {
      Object obj = map.get("originSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableAmountWithoutTax")) {
      Object obj = map.get("availableAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAvailableAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAvailableAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAvailableAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAvailableAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAvailableAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setImageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coordinationType")) {
      Object obj = map.get("coordinationType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCoordinationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchedAmountWithoutTax")) {
      Object obj = map.get("matchedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMatchedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMatchedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMatchedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMatchedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMatchedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNumbers")) {
      Object obj = map.get("poNumbers");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNumbers((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerGroupId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLockFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLockFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("archiveNo")) {
      Object obj = map.get("archiveNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setArchiveNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("withdrawType")) {
      Object obj = map.get("withdrawType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWithdrawType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("irid")) {
      Object obj = map.get("irid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIrid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRemoved")) {
      Object obj = map.get("isRemoved");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsRemoved((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchUpdateTime")) {
      Object obj = map.get("matchUpdateTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMatchUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setMatchUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMatchUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setMatchUpdateTime(null);
      }
    }
  if(map.containsKey("settlementId.id")) {
    Object obj = map.get("settlementId.id");
    if(obj instanceof Long) {
        this.setSettlementIdId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setSettlementIdId(Long.parseLong((String)obj));
    }
  }
  }
}
