package com.xforceplus.ultraman.app.jctke.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2024-01-24
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1494229217612763138L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface PurchaseOrder {
        static Long id() {
            return 1494505043025924097L;
        }
        static String code() {
            return "purchaseOrder";
        }
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "failureReason");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "buyerInvoiceID");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "sellerTelephone");
        TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseBankNo");
        TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseBankName");
        TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseAddress");
        TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseTelephone");
        TypedField<String> VIRTUAL_PO_TYPE = new TypedField<>(String.class, "virtualPoType");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> DELIVERIED_AMOUNT = new TypedField<>(BigDecimal.class, "deliveriedAmount");
        TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "waitForInvoiceAmount");
        TypedField<BigDecimal> UNPAYED_AMOUNT = new TypedField<>(BigDecimal.class, "unpayedAmount");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "invoicedAmount");
        TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "negativePaymentNo");
        TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "alterInvoiceIndicator");
        TypedField<String> PREVIOUS_P_O_NO = new TypedField<>(String.class, "previousPONo");
        TypedField<String> NEXT_P_O_NO = new TypedField<>(String.class, "nextPONo");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAmount");
        TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "payedAmount");
        TypedField<BigDecimal> PREPAY_AMOUNT = new TypedField<>(BigDecimal.class, "prepayAmount");
        TypedField<BigDecimal> ALL_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "allPaidAmount");
        TypedField<BigDecimal> WRITE_OFF_AMOUNT = new TypedField<>(BigDecimal.class, "writeOffAmount");
        TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "prepaidAmount");
        TypedField<String> PRE_ORDER_STATUS = new TypedField<>(String.class, "preOrderStatus");
        TypedField<BigDecimal> TEST_AMOUNT = new TypedField<>(BigDecimal.class, "testAmount");
        TypedField<BigDecimal> INVOICED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoicedAmountWithoutTax");
        TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "waitForInvoiceAmountWithoutTax");
        TypedField<Boolean> IS_SYNERGY = new TypedField<>(Boolean.class, "isSynergy");
        TypedField<String> EAMIL_PROCESS_STATUS = new TypedField<>(String.class, "eamilProcessStatus");
        TypedField<String> EAMIL_PROCESS_STATUS_RAW = new TypedField<>(String.class, "eamilProcessStatusRaw");
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
        /**
         * 租户定制对象
         */
        interface Tenant {
            interface S001 {
            }
        }
    }
    public interface PurchaseOrderItem {
        static Long id() {
            return 1494505580509204481L;
        }
        static String code() {
            return "purchaseOrderItem";
        }
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        TypedField<Long> ITEM = new TypedField<>(Long.class, "item");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "contractID");
        TypedField<String> VAT_CODE = new TypedField<>(String.class, "vatCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> MATERIAL_SERVICES_TEAM = new TypedField<>(String.class, "materialServicesTeam");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PROFITS_CENTER = new TypedField<>(String.class, "profitsCenter");
        TypedField<String> GENERAL_LEDGER_ACCOUNT = new TypedField<>(String.class, "generalLedgerAccount");
        TypedField<String> RELEASE_STATUS = new TypedField<>(String.class, "releaseStatus");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "isDelete");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> POST_STATUS = new TypedField<>(String.class, "postStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> RECEIVED_COUNT = new TypedField<>(BigDecimal.class, "receivedCount");
        TypedField<BigDecimal> RECEIVED_AMOUNT = new TypedField<>(BigDecimal.class, "receivedAmount");
        TypedField<BigDecimal> INVOICE_NOTICE_BILL_QUANTITY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillQuantity");
        TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAmount");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> WBS_SUB = new TypedField<>(String.class, "wbsSub");
        TypedField<BigDecimal> ORDER_NET_VALUE = new TypedField<>(BigDecimal.class, "orderNetValue");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAmountWithoutTax");
        TypedField<String> FACTORY = new TypedField<>(String.class, "factory");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "buyerInvoiceID");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        TypedField<BigDecimal> RECEIVED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "receivedAmountWithoutTax");
        TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "totalPayAmount");
        TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "totalPayQty");
        TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "ladderStatusCode");
        TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "ladderStatusDesc");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        TypedField<String> SAP_CREATE_DATE = new TypedField<>(String.class, "sapCreateDate");
        TypedField<String> SAP_UPDATE_DATE = new TypedField<>(String.class, "sapUpdateDate");
        TypedField<String> SAP_RELEASE_DATE = new TypedField<>(String.class, "sapReleaseDate");
        /**
         * 对一关联关系 关联对象 purchaseOrder
         */
        TypedField<Long> PURCHASE_ORDER_ITEM_RELATION_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.id");
        /**
         * 对一关联关系 关联对象 wbs
         */
        TypedField<Long> PURCHASE_ORDER_ITEM_AND_WBS_RELATION_ID = new TypedField<>(Long.class, "purchaseOrderItemAndWbsRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PURCHASE_ORDER_ITEM_RELATION {
                static String code () {
                    return "purchaseOrderItemRelation" ;
                }
                TypedField<String> PO_NUMBER = new TypedField<>(String.class, "purchaseOrderItemRelation.poNumber");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerName");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "purchaseOrderItemRelation.businessType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "purchaseOrderItemRelation.orderType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerID");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderItemRelation.orderStatus");
                TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "purchaseOrderItemRelation.failureReason");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchaseOrderItemRelation.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchaseOrderItemRelation.purchasingOrg");
                TypedField<Long> ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "purchaseOrderItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "purchaseOrderItemRelation.delete_flag");
                TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerInvoiceID");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerInvoiceTitle");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "purchaseOrderItemRelation.invoiceType");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.purchaserName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.purchaserTaxNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerTaxNo");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.purchaserNo");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.purchaseBankName");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseOrderItemRelation.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseOrderItemRelation.purchaseTelephone");
                TypedField<String> VIRTUAL_PO_TYPE = new TypedField<>(String.class, "purchaseOrderItemRelation.virtualPoType");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.projectName");
                TypedField<BigDecimal> DELIVERIED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.deliveriedAmount");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.waitForInvoiceAmount");
                TypedField<BigDecimal> UNPAYED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.unpayedAmount");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "purchaseOrderItemRelation.absentMsg");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.amountWithTax");
                TypedField<BigDecimal> INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.invoicedAmount");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.negativePaymentNo");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "purchaseOrderItemRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_P_O_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.previousPONo");
                TypedField<String> NEXT_P_O_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.nextPONo");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.amountWithoutTax");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.invoiceNoticeBillAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.payedAmount");
                TypedField<BigDecimal> PREPAY_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.prepayAmount");
                TypedField<BigDecimal> ALL_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.allPaidAmount");
                TypedField<BigDecimal> WRITE_OFF_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.writeOffAmount");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.prepaidAmount");
                TypedField<String> PRE_ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderItemRelation.preOrderStatus");
                TypedField<BigDecimal> TEST_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.testAmount");
                TypedField<BigDecimal> INVOICED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.invoicedAmountWithoutTax");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemRelation.waitForInvoiceAmountWithoutTax");
                TypedField<Boolean> IS_SYNERGY = new TypedField<>(Boolean.class, "purchaseOrderItemRelation.isSynergy");
                TypedField<String> EAMIL_PROCESS_STATUS = new TypedField<>(String.class, "purchaseOrderItemRelation.eamilProcessStatus");
                TypedField<String> EAMIL_PROCESS_STATUS_RAW = new TypedField<>(String.class, "purchaseOrderItemRelation.eamilProcessStatusRaw");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "purchaseOrderItemRelation.projectDefinition");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "purchaseOrderItemRelation.pmNode");
            }
            interface PURCHASE_ORDER_ITEM_AND_WBS_RELATION {
                static String code () {
                    return "purchaseOrderItemAndWbsRelation" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.projectName");
                TypedField<String> FIELD_W_B_S_NO = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.fieldWBSNo");
                TypedField<String> VIEW_ID = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.viewId");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.projectDefinition");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.ladderNo");
                TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.ladderStatusCode");
                TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.ladderStatusDesc");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.pmNode");
                TypedField<Long> ID = new TypedField<>(Long.class, "purchaseOrderItemAndWbsRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "purchaseOrderItemAndWbsRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemAndWbsRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemAndWbsRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemAndWbsRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemAndWbsRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.delete_flag");
                TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "purchaseOrderItemAndWbsRelation.isRequiredAbsent");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "purchaseOrderItemAndWbsRelation.absentMsg");
            }
        }
    }
    public interface GoodsReceiptItem {
        static Long id() {
            return 1494506416052310018L;
        }
        static String code() {
            return "goodsReceiptItem";
        }
        TypedField<String> PO_N_O = new TypedField<>(String.class, "poNO");
        TypedField<String> PO_LINE_ITEM_N_O = new TypedField<>(String.class, "poLineItemNO");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<BigDecimal> AMOUNT_AGGREGATION = new TypedField<>(BigDecimal.class, "amountAggregation");
        TypedField<String> GR_NO = new TypedField<>(String.class, "grNo");
        TypedField<BigDecimal> QUANTITY_AGGREGATION = new TypedField<>(BigDecimal.class, "quantityAggregation");
        TypedField<String> GR_ITEM_NO = new TypedField<>(String.class, "grItemNo");
        /**
         * 对一关联关系 关联对象 purchaseOrderItem
         */
        TypedField<Long> PURCHASE_ORDER_ITEM_AND_GOODS_RECEIPT_ITEMS_ID = new TypedField<>(Long.class, "purchaseOrderItemAndGoodsReceiptItems.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PURCHASE_ORDER_ITEM_AND_GOODS_RECEIPT_ITEMS {
                static String code () {
                    return "purchaseOrderItemAndGoodsReceiptItems" ;
                }
                TypedField<String> PO_NUMBER = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.poNumber");
                TypedField<Long> ITEM = new TypedField<>(Long.class, "purchaseOrderItemAndGoodsReceiptItems.item");
                TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.materialServices");
                TypedField<String> WBS = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.wbs");
                TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.materialServicesName");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.currency");
                TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.contractID");
                TypedField<String> VAT_CODE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.vatCode");
                TypedField<Long> ID = new TypedField<>(Long.class, "purchaseOrderItemAndGoodsReceiptItems.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "purchaseOrderItemAndGoodsReceiptItems.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemAndGoodsReceiptItems.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemAndGoodsReceiptItems.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemAndGoodsReceiptItems.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemAndGoodsReceiptItems.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.delete_flag");
                TypedField<String> MATERIAL_SERVICES_TEAM = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.materialServicesTeam");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.costCenter");
                TypedField<String> PROFITS_CENTER = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.profitsCenter");
                TypedField<String> GENERAL_LEDGER_ACCOUNT = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.generalLedgerAccount");
                TypedField<String> RELEASE_STATUS = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.releaseStatus");
                TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.quantityUnit");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.quantity");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.absentMsg");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "purchaseOrderItemAndGoodsReceiptItems.isDelete");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.amountWithTax");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.orderStatus");
                TypedField<String> POST_STATUS = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.postStatus");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.taxRate");
                TypedField<BigDecimal> RECEIVED_COUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.receivedCount");
                TypedField<BigDecimal> RECEIVED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.receivedAmount");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_QUANTITY = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.invoiceNoticeBillQuantity");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.invoiceNoticeBillAmount");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.taxAmount");
                TypedField<String> WBS_SUB = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.wbsSub");
                TypedField<BigDecimal> ORDER_NET_VALUE = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.orderNetValue");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.unitPrice");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.invoiceNoticeBillAmountWithoutTax");
                TypedField<String> FACTORY = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.factory");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.buyerName");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.buyerID");
                TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.buyerInvoiceID");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.buyerInvoiceTitle");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.projectDefinition");
                TypedField<BigDecimal> RECEIVED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.receivedAmountWithoutTax");
                TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.totalPayAmount");
                TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "purchaseOrderItemAndGoodsReceiptItems.totalPayQty");
                TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.ladderStatusCode");
                TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.ladderStatusDesc");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.pmNode");
                TypedField<String> SAP_CREATE_DATE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.sapCreateDate");
                TypedField<String> SAP_UPDATE_DATE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.sapUpdateDate");
                TypedField<String> SAP_RELEASE_DATE = new TypedField<>(String.class, "purchaseOrderItemAndGoodsReceiptItems.sapReleaseDate");
            }
        }
    }
    public interface InvoiceNoticeBill {
        static Long id() {
            return 1494506942278078465L;
        }
        static String code() {
            return "invoiceNoticeBill";
        }
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRE_NO = new TypedField<>(String.class, "preNo");
        TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "installmentNum");
        TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceRemark");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> NODE = new TypedField<>(String.class, "node");
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "allocationOrderStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "sellerTelephone");
        TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "receiveEmail");
        TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "receiveTelephone");
        TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseAddress");
        TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseTelephone");
        TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseBankNo");
        TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseBankName");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "poTotalAmountWithTax");
        TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "recommendationInvoiceId");
        TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "recommendationInvoiceNo");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "negativePaymentNo");
        TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "changeTicketType");
        TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "distributeOrderInvoiceAmount");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paidAmount");
        TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "businessAmount");
        TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "totalAmount");
        TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "totalAmountWithTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "hippedQuantity");
        TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "matchedAmountWithoutTax");
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        TypedField<Long> VALID_SELLEMENT_COUNT = new TypedField<>(Long.class, "validSellementCount");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "dataSource");
        TypedField<String> GENERATE_SETTLE_STATUS = new TypedField<>(String.class, "generateSettleStatus");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> IRID = new TypedField<>(String.class, "irid");
        /**
         * 对一关联关系 关联对象 purchaseOrder
         */
        TypedField<Long> PURCHASE_ORDER_ANDINVOICE_NOTIC_RELATIONE_BILL_ID = new TypedField<>(Long.class, "purchaseOrderAndinvoiceNoticRelationeBill.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PURCHASE_ORDER_ANDINVOICE_NOTIC_RELATIONE_BILL {
                static String code () {
                    return "purchaseOrderAndinvoiceNoticRelationeBill" ;
                }
                TypedField<String> PO_NUMBER = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.poNumber");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.buyerName");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.businessType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.orderType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.buyerID");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.orderStatus");
                TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.failureReason");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchasingOrg");
                TypedField<Long> ID = new TypedField<>(Long.class, "purchaseOrderAndinvoiceNoticRelationeBill.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "purchaseOrderAndinvoiceNoticRelationeBill.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderAndinvoiceNoticRelationeBill.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderAndinvoiceNoticRelationeBill.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderAndinvoiceNoticRelationeBill.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderAndinvoiceNoticRelationeBill.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.delete_flag");
                TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.buyerInvoiceID");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.buyerInvoiceTitle");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.invoiceType");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchaserName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchaserTaxNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.sellerTaxNo");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchaserNo");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.sellerTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchaseBankName");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.purchaseTelephone");
                TypedField<String> VIRTUAL_PO_TYPE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.virtualPoType");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.projectName");
                TypedField<BigDecimal> DELIVERIED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.deliveriedAmount");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.waitForInvoiceAmount");
                TypedField<BigDecimal> UNPAYED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.unpayedAmount");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.absentMsg");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.amountWithTax");
                TypedField<BigDecimal> INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.invoicedAmount");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.negativePaymentNo");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_P_O_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.previousPONo");
                TypedField<String> NEXT_P_O_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.nextPONo");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.amountWithoutTax");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.invoiceNoticeBillAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.payedAmount");
                TypedField<BigDecimal> PREPAY_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.prepayAmount");
                TypedField<BigDecimal> ALL_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.allPaidAmount");
                TypedField<BigDecimal> WRITE_OFF_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.writeOffAmount");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.prepaidAmount");
                TypedField<String> PRE_ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.preOrderStatus");
                TypedField<BigDecimal> TEST_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.testAmount");
                TypedField<BigDecimal> INVOICED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.invoicedAmountWithoutTax");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderAndinvoiceNoticRelationeBill.waitForInvoiceAmountWithoutTax");
                TypedField<Boolean> IS_SYNERGY = new TypedField<>(Boolean.class, "purchaseOrderAndinvoiceNoticRelationeBill.isSynergy");
                TypedField<String> EAMIL_PROCESS_STATUS = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.eamilProcessStatus");
                TypedField<String> EAMIL_PROCESS_STATUS_RAW = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.eamilProcessStatusRaw");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.projectDefinition");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "purchaseOrderAndinvoiceNoticRelationeBill.pmNode");
            }
        }
    }
    public interface InvoiceNoticeBillItem {
        static Long id() {
            return 1504005379973025794L;
        }
        static String code() {
            return "invoiceNoticeBillItem";
        }
        TypedField<String> ITEM_N_O = new TypedField<>(String.class, "itemNO");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<String> BILL_N_O = new TypedField<>(String.class, "billNO");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> LADDER_STATUS = new TypedField<>(String.class, "ladderStatus");
        TypedField<String> PRE_NO = new TypedField<>(String.class, "preNo");
        TypedField<String> PRE_ITEM_NO = new TypedField<>(String.class, "preItemNo");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "totalPayQty");
        TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "totalPayAmount");
        TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "businessStatus");
        TypedField<String> BUSINESS_STATUS_EXPR = new TypedField<>(String.class, "businessStatusExpr");
        TypedField<BigDecimal> AMOUNT_WITH_TAX_RAW = new TypedField<>(BigDecimal.class, "amountWithTaxRaw");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> EDIT_STATUS = new TypedField<>(String.class, "editStatus");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX_RAW = new TypedField<>(BigDecimal.class, "amountWithoutTaxRaw");
        TypedField<BigDecimal> ALL_PAY_QTY = new TypedField<>(BigDecimal.class, "allPayQty");
        TypedField<BigDecimal> ALL_PAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "allPayAmountWithTax");
        TypedField<BigDecimal> ALL_PAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "allPayAmountWithoutTax");
        TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "contractID");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        /**
         * 对一关联关系 关联对象 invoiceNoticeBill
         */
        TypedField<Long> INVOICE_NOTICE_BILL_AND_ITEM_RELATION_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.id");
        /**
         * 对一关联关系 关联对象 purchaseOrderItem
         */
        TypedField<Long> PO_ITEM_AND_INVOICE_BILL_ITEM_RELATIONSHIP_ID = new TypedField<>(Long.class, "poItemAndInvoiceBillItemRelationship.id");
        /**
         * 对一关联关系 关联对象 wbs
         */
        TypedField<Long> INVOICE_NOTICE_ITEM_AND_WBS_RELATION_ID = new TypedField<>(Long.class, "invoiceNoticeItemAndWbsRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_NOTICE_BILL_AND_ITEM_RELATION {
                static String code () {
                    return "invoiceNoticeBillAndItemRelation" ;
                }
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillAndItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillAndItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.delete_flag");
                TypedField<String> PRE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.preNo");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.priceMethod");
                TypedField<String> WBS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.wbs");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.node");
                TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceNoticeNO");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceCode");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.hippedQuantity");
                TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.matchedAmountWithoutTax");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.projectDefinition");
                TypedField<Long> VALID_SELLEMENT_COUNT = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.validSellementCount");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.pmNode");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.ladderNo");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.dataSource");
                TypedField<String> GENERATE_SETTLE_STATUS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.generateSettleStatus");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.projectName");
                TypedField<String> IRID = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.irid");
            }
            interface PO_ITEM_AND_INVOICE_BILL_ITEM_RELATIONSHIP {
                static String code () {
                    return "poItemAndInvoiceBillItemRelationship" ;
                }
                TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.poNumber");
                TypedField<Long> ITEM = new TypedField<>(Long.class, "poItemAndInvoiceBillItemRelationship.item");
                TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.materialServices");
                TypedField<String> WBS = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.wbs");
                TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.materialServicesName");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.currency");
                TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.contractID");
                TypedField<String> VAT_CODE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.vatCode");
                TypedField<Long> ID = new TypedField<>(Long.class, "poItemAndInvoiceBillItemRelationship.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "poItemAndInvoiceBillItemRelationship.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "poItemAndInvoiceBillItemRelationship.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "poItemAndInvoiceBillItemRelationship.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "poItemAndInvoiceBillItemRelationship.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "poItemAndInvoiceBillItemRelationship.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.delete_flag");
                TypedField<String> MATERIAL_SERVICES_TEAM = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.materialServicesTeam");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.costCenter");
                TypedField<String> PROFITS_CENTER = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.profitsCenter");
                TypedField<String> GENERAL_LEDGER_ACCOUNT = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.generalLedgerAccount");
                TypedField<String> RELEASE_STATUS = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.releaseStatus");
                TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.quantityUnit");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.quantity");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.absentMsg");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "poItemAndInvoiceBillItemRelationship.isDelete");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.amountWithTax");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.orderStatus");
                TypedField<String> POST_STATUS = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.postStatus");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.taxRate");
                TypedField<BigDecimal> RECEIVED_COUNT = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.receivedCount");
                TypedField<BigDecimal> RECEIVED_AMOUNT = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.receivedAmount");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_QUANTITY = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.invoiceNoticeBillQuantity");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.invoiceNoticeBillAmount");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.taxAmount");
                TypedField<String> WBS_SUB = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.wbsSub");
                TypedField<BigDecimal> ORDER_NET_VALUE = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.orderNetValue");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.unitPrice");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.invoiceNoticeBillAmountWithoutTax");
                TypedField<String> FACTORY = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.factory");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.buyerName");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.buyerID");
                TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.buyerInvoiceID");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.buyerInvoiceTitle");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.projectDefinition");
                TypedField<BigDecimal> RECEIVED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.receivedAmountWithoutTax");
                TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.totalPayAmount");
                TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "poItemAndInvoiceBillItemRelationship.totalPayQty");
                TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.ladderStatusCode");
                TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.ladderStatusDesc");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.pmNode");
                TypedField<String> SAP_CREATE_DATE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.sapCreateDate");
                TypedField<String> SAP_UPDATE_DATE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.sapUpdateDate");
                TypedField<String> SAP_RELEASE_DATE = new TypedField<>(String.class, "poItemAndInvoiceBillItemRelationship.sapReleaseDate");
            }
            interface INVOICE_NOTICE_ITEM_AND_WBS_RELATION {
                static String code () {
                    return "invoiceNoticeItemAndWbsRelation" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.projectName");
                TypedField<String> FIELD_W_B_S_NO = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.fieldWBSNo");
                TypedField<String> VIEW_ID = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.viewId");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.projectDefinition");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.ladderNo");
                TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.ladderStatusCode");
                TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.ladderStatusDesc");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.pmNode");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceNoticeItemAndWbsRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceNoticeItemAndWbsRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeItemAndWbsRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeItemAndWbsRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeItemAndWbsRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeItemAndWbsRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.delete_flag");
                TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "invoiceNoticeItemAndWbsRelation.isRequiredAbsent");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "invoiceNoticeItemAndWbsRelation.absentMsg");
            }
        }
    }
    public interface Invoice {
        static Long id() {
            return 1504276669632286721L;
        }
        static String code() {
            return "invoice";
        }
        TypedField<String> PRE_N_O = new TypedField<>(String.class, "preNO");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceUrl");
        TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "paperDrawDate");
        TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "sendDate");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "submitDate");
        TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "postingDate");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "expressNumber");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "applyPayAmount");
        TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "voucherNo");
        TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "voucherText");
        TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "payBaseDay");
        TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "actualPayDay");
        TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "authDate");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "accountStatus");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "payStatus");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paidAmount");
        TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoicePayAmount");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "sellerAddrTel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaserAddrTel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "purchaserBankNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "taxDeclarationPeriod");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scanTime");
        TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "scanDeductionImageUrl");
        TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "scanInvoiceImageUrl");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "authStatus");
        TypedField<String> TAX_FLAG = new TypedField<>(String.class, "taxFlag");
        TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "scanStatus");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "invoiceNoticeNos");
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "sendCount");
        TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "backCount");
        TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "recommendationFlag");
        TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "matchedAmount");
        TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "account_date");
        TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "relationCount");
        TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "lastSource");
        TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "originFile");
        TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "originFileUrl");
        TypedField<String> RETURN_REASON = new TypedField<>(String.class, "returnReason");
        TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "availableAmount");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "isReplace");
        TypedField<String> REPLACE_SELLER_NAME = new TypedField<>(String.class, "replaceSellerName");
        TypedField<String> REPLACE_SELLER_TAX_NO = new TypedField<>(String.class, "replaceSellerTaxNo");
        TypedField<String> ORIGIN_SELLER_NAME = new TypedField<>(String.class, "originSellerName");
        TypedField<String> ORIGIN_SELLER_TAX_NO = new TypedField<>(String.class, "originSellerTaxNo");
        TypedField<BigDecimal> AVAILABLE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "availableAmountWithoutTax");
        TypedField<String> IMAGE_ID = new TypedField<>(String.class, "imageId");
        TypedField<String> COORDINATION_TYPE = new TypedField<>(String.class, "coordinationType");
        TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "matchedAmountWithoutTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "poNumbers");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "dataSource");
        TypedField<String> SELLER_GROUP_ID = new TypedField<>(String.class, "sellerGroupId");
        TypedField<Boolean> LOCK_FLAG = new TypedField<>(Boolean.class, "lockFlag");
        TypedField<String> ARCHIVE_NO = new TypedField<>(String.class, "archiveNo");
        TypedField<String> WITHDRAW_TYPE = new TypedField<>(String.class, "withdrawType");
        TypedField<String> IRID = new TypedField<>(String.class, "irid");
        TypedField<String> IS_REMOVED = new TypedField<>(String.class, "isRemoved");
        TypedField<LocalDateTime> MATCH_UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchUpdateTime");
        /**
         * 对一关联关系 关联对象 settlement
         */
        TypedField<Long> SETTLEMENT_ID_ID = new TypedField<>(Long.class, "settlementId.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SETTLEMENT_ID {
                static String code () {
                    return "settlementId" ;
                }
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlementId.settlementNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementId.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementId.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementId.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementId.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementId.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementId.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementId.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementId.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementId.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementId.delete_flag");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementId.amountWithTax");
                TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlementId.settlementStatus");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "settlementId.amountWithoutTax");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "settlementId.sellerTaxNo");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "settlementId.dataSource");
                TypedField<String> IRID = new TypedField<>(String.class, "settlementId.irid");
            }
        }
    }
    public interface TaxCode {
        static Long id() {
            return 1505797273594068993L;
        }
        static String code() {
            return "taxCode";
        }
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_CODE = new TypedField<>(String.class, "taxCode");
    }
    public interface SubeiAmountApproval {
        static Long id() {
            return 1505804192207568898L;
        }
        static String code() {
            return "subeiAmountApproval";
        }
        TypedField<String> EXPENSE_TYPE = new TypedField<>(String.class, "expenseType");
        TypedField<String> ROLE_TYPE = new TypedField<>(String.class, "roleType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ROLE_SERIAL_NUMBER = new TypedField<>(Long.class, "roleSerialNumber");
        TypedField<String> ROLE_ENGLISH_DESCRIPTION = new TypedField<>(String.class, "roleEnglishDescription");
        TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "pettyCashType");
        TypedField<BigDecimal> LEFT_SPARE_AMOUNT = new TypedField<>(BigDecimal.class, "leftSpareAmount");
        TypedField<BigDecimal> RIGHT_SPARE_AMOUNT = new TypedField<>(BigDecimal.class, "rightSpareAmount");
        TypedField<String> AMOUNT_LEFT_BORDER_SYMBOL = new TypedField<>(String.class, "amountLeftBorderSymbol");
        TypedField<String> AMOUNT_RIGHT_BORDER_SYMBOL = new TypedField<>(String.class, "amountRightBorderSymbol");
    }
    public interface ToubaoAmountApproval {
        static Long id() {
            return 1505819069571629058L;
        }
        static String code() {
            return "toubaoAmountApproval";
        }
        TypedField<Long> EXPIRE_DAYS = new TypedField<>(Long.class, "expireDays");
        TypedField<String> ROLE_TYPE = new TypedField<>(String.class, "roleType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ROLE_SERIAL_NUMBER = new TypedField<>(Long.class, "roleSerialNumber");
        TypedField<String> ROLE_ENGLISH_DESCRIPTION = new TypedField<>(String.class, "roleEnglishDescription");
    }
    public interface WeiAmountApproval {
        static Long id() {
            return 1505820212225867777L;
        }
        static String code() {
            return "weiAmountApproval";
        }
        TypedField<String> EXPENSE_TYPE = new TypedField<>(String.class, "expenseType");
        TypedField<BigDecimal> PROPORTION = new TypedField<>(BigDecimal.class, "proportion");
        TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "marginAmount");
        TypedField<Long> EXPIRE_DAYS = new TypedField<>(Long.class, "expireDays");
        TypedField<String> ROLE_TYPE = new TypedField<>(String.class, "roleType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ROLE_SERIAL_NUMBER = new TypedField<>(Long.class, "roleSerialNumber");
        TypedField<String> ROLE_ENGLISH_DESCRIPTION = new TypedField<>(String.class, "roleEnglishDescription");
    }
    public interface RpaTask {
        static Long id() {
            return 1505822804926496770L;
        }
        static String code() {
            return "rpaTask";
        }
        TypedField<String> TASK_TYPE = new TypedField<>(String.class, "taskType");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<LocalDateTime> WAREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "warehousingTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TASK_NO = new TypedField<>(String.class, "taskNo");
        TypedField<String> BILL_N_O = new TypedField<>(String.class, "billNO");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> RESQUST_BODY = new TypedField<>(String.class, "resqustBody");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> RESPONSE_COUNT = new TypedField<>(Long.class, "responseCount");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> RPA_TASK_AND_PAYMENT_RELATION_ID = new TypedField<>(Long.class, "rpaTaskAndPaymentRelation.id");
        /**
         * 对一关联关系 关联对象 prepaymentWriteRelation
         */
        TypedField<Long> RPA_AND_PREPARE_PAY_WRITE_RELATION_ID = new TypedField<>(Long.class, "rpaAndPreparePayWriteRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface RPA_TASK_AND_PAYMENT_RELATION {
                static String code () {
                    return "rpaTaskAndPaymentRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "rpaTaskAndPaymentRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "rpaTaskAndPaymentRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "rpaTaskAndPaymentRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "rpaTaskAndPaymentRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "rpaTaskAndPaymentRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "rpaTaskAndPaymentRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "rpaTaskAndPaymentRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "rpaTaskAndPaymentRelation.salesPersonId");
            }
            interface RPA_AND_PREPARE_PAY_WRITE_RELATION {
                static String code () {
                    return "rpaAndPreparePayWriteRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.applyId");
                TypedField<String> IMP_APPLY_ID = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.impApplyId");
                TypedField<BigDecimal> PREPAYMENT_WRITE_AMOUNT = new TypedField<>(BigDecimal.class, "rpaAndPreparePayWriteRelation.prepaymentWriteAmount");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.prepaymentWriteVoucher");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.prepaymentPaymentVoucher");
                TypedField<Long> ID = new TypedField<>(Long.class, "rpaAndPreparePayWriteRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "rpaAndPreparePayWriteRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "rpaAndPreparePayWriteRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "rpaAndPreparePayWriteRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "rpaAndPreparePayWriteRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "rpaAndPreparePayWriteRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.delete_flag");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.paymentType");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.paymentStatus");
                TypedField<String> XXX = new TypedField<>(String.class, "rpaAndPreparePayWriteRelation.xxx");
            }
        }
    }
    public interface ProfitCenterCompany {
        static Long id() {
            return 1505830140470591490L;
        }
        static String code() {
            return "profitCenterCompany";
        }
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> TAX_BRANCH = new TypedField<>(String.class, "taxBranch");
        TypedField<String> PERFORMANCE_BRANCH = new TypedField<>(String.class, "performanceBranch");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
    }
    public interface AdvanceChargeInterface {
        static Long id() {
            return 1505838263969218561L;
        }
        static String code() {
            return "advanceChargeInterface";
        }
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<LocalDateTime> PAYMENT_TIME = new TypedField<>(LocalDateTime.class, "paymentTime");
        TypedField<LocalDateTime> PAYMENT_MONTH = new TypedField<>(LocalDateTime.class, "paymentMonth");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> SUPPLIER_ID = new TypedField<>(String.class, "supplierId");
        TypedField<String> LEDGER_TYPE = new TypedField<>(String.class, "ledgerType");
        TypedField<String> EXCHANGE_RATE = new TypedField<>(String.class, "exchangeRate");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> TEXT = new TypedField<>(String.class, "text");
        TypedField<String> ADVANCE_CHARGE_AMOUNT = new TypedField<>(String.class, "advanceChargeAmount");
        TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "paymentDueDate");
        TypedField<LocalDateTime> WAREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "warehousingTime");
        TypedField<String> RPA_TASK_ID = new TypedField<>(String.class, "rpaTaskId");
        TypedField<String> PRE_PAYMENT_NO = new TypedField<>(String.class, "prePaymentNo");
        TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentPaymentVoucher");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "paymentObjectId");
        TypedField<Long> PAY_MENT_ID = new TypedField<>(Long.class, "payMentId");
        TypedField<String> TAX_CODE = new TypedField<>(String.class, "taxCode");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> ADVANCE_CHARGE_INTERFACE_RELATION_ID = new TypedField<>(Long.class, "advanceChargeInterfaceRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ADVANCE_CHARGE_INTERFACE_RELATION {
                static String code () {
                    return "advanceChargeInterfaceRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "advanceChargeInterfaceRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "advanceChargeInterfaceRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "advanceChargeInterfaceRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "advanceChargeInterfaceRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "advanceChargeInterfaceRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "advanceChargeInterfaceRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "advanceChargeInterfaceRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "advanceChargeInterfaceRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "advanceChargeInterfaceRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "advanceChargeInterfaceRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "advanceChargeInterfaceRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "advanceChargeInterfaceRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "advanceChargeInterfaceRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "advanceChargeInterfaceRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "advanceChargeInterfaceRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "advanceChargeInterfaceRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "advanceChargeInterfaceRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "advanceChargeInterfaceRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "advanceChargeInterfaceRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "advanceChargeInterfaceRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "advanceChargeInterfaceRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "advanceChargeInterfaceRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "advanceChargeInterfaceRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "advanceChargeInterfaceRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "advanceChargeInterfaceRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "advanceChargeInterfaceRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "advanceChargeInterfaceRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "advanceChargeInterfaceRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "advanceChargeInterfaceRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "advanceChargeInterfaceRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "advanceChargeInterfaceRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "advanceChargeInterfaceRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "advanceChargeInterfaceRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "advanceChargeInterfaceRelation.salesPersonId");
            }
        }
    }
    public interface AccountsPayableInterface {
        static Long id() {
            return 1505845707520835585L;
        }
        static String code() {
            return "accountsPayableInterface";
        }
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PRE_PAYMENT_IDENTIFICATION = new TypedField<>(String.class, "prePaymentIdentification");
        TypedField<String> PRE_PAYMENT_VOUCHER_NO = new TypedField<>(String.class, "prePaymentVoucherNo");
        TypedField<BigDecimal> PRE_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "prePaymentAmount");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paperDrewDate");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> PO_LIST = new TypedField<>(String.class, "poList");
        TypedField<String> IS_FROZEN = new TypedField<>(String.class, "isFrozen");
        TypedField<String> PAYMENT_VOUCHER_NO = new TypedField<>(String.class, "paymentVoucherNo");
        TypedField<String> REVERSE_ORDER_VOUCHER_NO = new TypedField<>(String.class, "reverseOrderVoucherNo");
        TypedField<String> PRE_PAYMENT = new TypedField<>(String.class, "prePayment");
        TypedField<String> PAYMENT_VOUCHER_NO_TWO = new TypedField<>(String.class, "paymentVoucherNoTwo");
        TypedField<String> SETTLE_ACCOUNTS_VOUCHER_NO = new TypedField<>(String.class, "settleAccountsVoucherNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RPA_TASK_ID = new TypedField<>(String.class, "rpaTaskId");
        TypedField<LocalDateTime> WAREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "warehousingTime");
        TypedField<Long> PAY_MENT_ID = new TypedField<>(Long.class, "payMentId");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> ACCOUNTS_PAYABLE_INTERFACE_RELATION_ID = new TypedField<>(Long.class, "accountsPayableInterfaceRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ACCOUNTS_PAYABLE_INTERFACE_RELATION {
                static String code () {
                    return "accountsPayableInterfaceRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "accountsPayableInterfaceRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "accountsPayableInterfaceRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "accountsPayableInterfaceRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "accountsPayableInterfaceRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "accountsPayableInterfaceRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "accountsPayableInterfaceRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "accountsPayableInterfaceRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "accountsPayableInterfaceRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "accountsPayableInterfaceRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "accountsPayableInterfaceRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "accountsPayableInterfaceRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "accountsPayableInterfaceRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "accountsPayableInterfaceRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "accountsPayableInterfaceRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "accountsPayableInterfaceRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "accountsPayableInterfaceRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "accountsPayableInterfaceRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "accountsPayableInterfaceRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "accountsPayableInterfaceRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "accountsPayableInterfaceRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "accountsPayableInterfaceRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "accountsPayableInterfaceRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "accountsPayableInterfaceRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "accountsPayableInterfaceRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "accountsPayableInterfaceRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "accountsPayableInterfaceRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "accountsPayableInterfaceRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "accountsPayableInterfaceRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "accountsPayableInterfaceRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "accountsPayableInterfaceRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "accountsPayableInterfaceRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "accountsPayableInterfaceRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "accountsPayableInterfaceRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "accountsPayableInterfaceRelation.salesPersonId");
            }
        }
    }
    public interface ApprovalHistory {
        static Long id() {
            return 1505847510303997953L;
        }
        static String code() {
            return "approvalHistory";
        }
        TypedField<String> APPROVAL_ID = new TypedField<>(String.class, "approvalId");
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> APPROVAL_USER_NAME = new TypedField<>(String.class, "approvalUserName");
        TypedField<String> APPROVAL_STATUS = new TypedField<>(String.class, "approvalStatus");
        TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "approvalBody");
        TypedField<String> APPLY_NO = new TypedField<>(String.class, "applyNo");
        TypedField<LocalDateTime> APPROVAL_TIME = new TypedField<>(LocalDateTime.class, "approvalTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> PAY_MENT_ID = new TypedField<>(Long.class, "payMentId");
        TypedField<String> ORIGIN_STATUS = new TypedField<>(String.class, "originStatus");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "poNumbers");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> APPROVAL_HISTORY_RELATION_ID = new TypedField<>(Long.class, "approvalHistoryRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface APPROVAL_HISTORY_RELATION {
                static String code () {
                    return "approvalHistoryRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "approvalHistoryRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "approvalHistoryRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "approvalHistoryRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "approvalHistoryRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "approvalHistoryRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "approvalHistoryRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "approvalHistoryRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "approvalHistoryRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "approvalHistoryRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "approvalHistoryRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "approvalHistoryRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "approvalHistoryRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "approvalHistoryRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "approvalHistoryRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "approvalHistoryRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "approvalHistoryRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "approvalHistoryRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "approvalHistoryRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "approvalHistoryRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "approvalHistoryRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "approvalHistoryRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "approvalHistoryRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "approvalHistoryRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "approvalHistoryRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "approvalHistoryRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "approvalHistoryRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "approvalHistoryRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "approvalHistoryRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "approvalHistoryRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "approvalHistoryRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "approvalHistoryRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "approvalHistoryRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "approvalHistoryRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "approvalHistoryRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "approvalHistoryRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "approvalHistoryRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "approvalHistoryRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "approvalHistoryRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "approvalHistoryRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "approvalHistoryRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "approvalHistoryRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "approvalHistoryRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "approvalHistoryRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "approvalHistoryRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "approvalHistoryRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "approvalHistoryRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "approvalHistoryRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "approvalHistoryRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "approvalHistoryRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "approvalHistoryRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "approvalHistoryRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "approvalHistoryRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "approvalHistoryRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "approvalHistoryRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "approvalHistoryRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "approvalHistoryRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "approvalHistoryRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "approvalHistoryRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "approvalHistoryRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "approvalHistoryRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "approvalHistoryRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "approvalHistoryRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "approvalHistoryRelation.salesPersonId");
            }
        }
    }
    public interface Enclosure {
        static Long id() {
            return 1505848133372051458L;
        }
        static String code() {
            return "enclosure";
        }
        TypedField<String> APPLY_NO = new TypedField<>(String.class, "applyNo");
        TypedField<String> FILE_ID = new TypedField<>(String.class, "fileId");
        TypedField<String> FILE_NAME = new TypedField<>(String.class, "fileName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ENTITY_TYPE = new TypedField<>(String.class, "entityType");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entityId");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "fileUrl");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> ENCLOSURE_AND_PAYMENT_RELATION_ID = new TypedField<>(Long.class, "enclosureAndPaymentRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ENCLOSURE_AND_PAYMENT_RELATION {
                static String code () {
                    return "enclosureAndPaymentRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "enclosureAndPaymentRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "enclosureAndPaymentRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "enclosureAndPaymentRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "enclosureAndPaymentRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "enclosureAndPaymentRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "enclosureAndPaymentRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "enclosureAndPaymentRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "enclosureAndPaymentRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "enclosureAndPaymentRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "enclosureAndPaymentRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "enclosureAndPaymentRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "enclosureAndPaymentRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "enclosureAndPaymentRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "enclosureAndPaymentRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "enclosureAndPaymentRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "enclosureAndPaymentRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "enclosureAndPaymentRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "enclosureAndPaymentRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "enclosureAndPaymentRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "enclosureAndPaymentRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "enclosureAndPaymentRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "enclosureAndPaymentRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "enclosureAndPaymentRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "enclosureAndPaymentRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "enclosureAndPaymentRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "enclosureAndPaymentRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "enclosureAndPaymentRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "enclosureAndPaymentRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "enclosureAndPaymentRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "enclosureAndPaymentRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "enclosureAndPaymentRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "enclosureAndPaymentRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "enclosureAndPaymentRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "enclosureAndPaymentRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "enclosureAndPaymentRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "enclosureAndPaymentRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "enclosureAndPaymentRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "enclosureAndPaymentRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "enclosureAndPaymentRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "enclosureAndPaymentRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "enclosureAndPaymentRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "enclosureAndPaymentRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "enclosureAndPaymentRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "enclosureAndPaymentRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "enclosureAndPaymentRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "enclosureAndPaymentRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "enclosureAndPaymentRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "enclosureAndPaymentRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "enclosureAndPaymentRelation.salesPersonId");
            }
        }
    }
    public interface PaymentManage {
        static Long id() {
            return 1506102729814511617L;
        }
        static String code() {
            return "paymentManage";
        }
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "applyUserName");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "prepaymentType");
        TypedField<String> BOND_TYPE = new TypedField<>(String.class, "bondType");
        TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "paymentObjectId");
        TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "paymentObject");
        TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "applyPaymentAmount");
        TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "applyPaidAmount");
        TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "orderAmount");
        TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceAmount");
        TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "collectionAccumulation");
        TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "paymentAccumulation");
        TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "prepaymentRequestNo");
        TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "prepaymentWriteVoucher");
        TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentVoucher");
        TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentPaymentVoucher");
        TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "paymentClearingVoucher");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "paymentUserType");
        TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "paymentDueDate");
        TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "paymentBankType");
        TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "collectionBank");
        TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "collectionAccount");
        TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "collectionName");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "contractName");
        TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "contractAmount");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> TEXT = new TypedField<>(String.class, "text");
        TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "paymentRemark");
        TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "approvalHistory");
        TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "downloadUserName");
        TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "downloadStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "contractSignDate");
        TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "invoiceNoticeNOs");
        TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "approvalRole");
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "companyId");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "purchaserId");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "approvalBody");
        TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "agentPaymentTerm");
        TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "pettyCashType");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "procurementGroup");
        TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "freezePayment");
        TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "commercialPaymentVoucher");
        TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "alterInvoiceIndicator");
        TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "previousApplyId");
        TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "nextApplyId");
        TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentPaymentVoucher");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentAmount");
        TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "payedAmount");
        TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "marginAmount");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "initiateRole");
        TypedField<String> PO_NOS = new TypedField<>(String.class, "poNos");
        TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "prepaidAmount");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "submitDate");
        TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "accountingDate");
        TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "poNumbers");
        TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "collectionBankCode");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "dataSource");
        TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "autoBatchNo");
        TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "autoGoodsType");
        TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "overPayType");
        TypedField<String> IRID = new TypedField<>(String.class, "irid");
        TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "originText");
        TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "salesPersonName");
        TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "salesPersonId");
        /**
         * 对一关联关系 关联对象 purchaseOrder
         */
        TypedField<Long> PO_AND_PREPAYMENT_RELATIONSHIP_ID = new TypedField<>(Long.class, "poAndPrepaymentRelationship.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PO_AND_PREPAYMENT_RELATIONSHIP {
                static String code () {
                    return "poAndPrepaymentRelationship" ;
                }
                TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poAndPrepaymentRelationship.poNumber");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.buyerName");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "poAndPrepaymentRelationship.businessType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "poAndPrepaymentRelationship.orderType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "poAndPrepaymentRelationship.buyerID");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "poAndPrepaymentRelationship.orderStatus");
                TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "poAndPrepaymentRelationship.failureReason");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchasingOrg");
                TypedField<Long> ID = new TypedField<>(Long.class, "poAndPrepaymentRelationship.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "poAndPrepaymentRelationship.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "poAndPrepaymentRelationship.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "poAndPrepaymentRelationship.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "poAndPrepaymentRelationship.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "poAndPrepaymentRelationship.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "poAndPrepaymentRelationship.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "poAndPrepaymentRelationship.delete_flag");
                TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "poAndPrepaymentRelationship.buyerInvoiceID");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "poAndPrepaymentRelationship.buyerInvoiceTitle");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "poAndPrepaymentRelationship.invoiceType");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchaserName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchaserTaxNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.sellerTaxNo");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchaserNo");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "poAndPrepaymentRelationship.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "poAndPrepaymentRelationship.sellerTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchaseBankName");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "poAndPrepaymentRelationship.purchaseTelephone");
                TypedField<String> VIRTUAL_PO_TYPE = new TypedField<>(String.class, "poAndPrepaymentRelationship.virtualPoType");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "poAndPrepaymentRelationship.projectName");
                TypedField<BigDecimal> DELIVERIED_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.deliveriedAmount");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.waitForInvoiceAmount");
                TypedField<BigDecimal> UNPAYED_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.unpayedAmount");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "poAndPrepaymentRelationship.absentMsg");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.amountWithTax");
                TypedField<BigDecimal> INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.invoicedAmount");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.negativePaymentNo");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "poAndPrepaymentRelationship.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_P_O_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.previousPONo");
                TypedField<String> NEXT_P_O_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.nextPONo");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.amountWithoutTax");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.invoiceNoticeBillAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.payedAmount");
                TypedField<BigDecimal> PREPAY_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.prepayAmount");
                TypedField<BigDecimal> ALL_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.allPaidAmount");
                TypedField<BigDecimal> WRITE_OFF_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.writeOffAmount");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.prepaidAmount");
                TypedField<String> PRE_ORDER_STATUS = new TypedField<>(String.class, "poAndPrepaymentRelationship.preOrderStatus");
                TypedField<BigDecimal> TEST_AMOUNT = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.testAmount");
                TypedField<BigDecimal> INVOICED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.invoicedAmountWithoutTax");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "poAndPrepaymentRelationship.waitForInvoiceAmountWithoutTax");
                TypedField<Boolean> IS_SYNERGY = new TypedField<>(Boolean.class, "poAndPrepaymentRelationship.isSynergy");
                TypedField<String> EAMIL_PROCESS_STATUS = new TypedField<>(String.class, "poAndPrepaymentRelationship.eamilProcessStatus");
                TypedField<String> EAMIL_PROCESS_STATUS_RAW = new TypedField<>(String.class, "poAndPrepaymentRelationship.eamilProcessStatusRaw");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "poAndPrepaymentRelationship.projectDefinition");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "poAndPrepaymentRelationship.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "poAndPrepaymentRelationship.pmNode");
            }
        }
    }
    public interface Imprest {
        static Long id() {
            return 1508335046502981634L;
        }
        static String code() {
            return "imprest";
        }
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "apply_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PAYMENT_ORDER_TYPE = new TypedField<>(String.class, "payment_order_type");
        TypedField<String> PRE_BUSINESS_TYPE = new TypedField<>(String.class, "pre_business_type");
        TypedField<String> PAY_ID = new TypedField<>(String.class, "pay_id");
        TypedField<String> PAYER = new TypedField<>(String.class, "payer");
        TypedField<String> PAY_BANK_TYPE = new TypedField<>(String.class, "pay_bank_type");
        TypedField<String> PAY_REMARK = new TypedField<>(String.class, "pay_remark");
        TypedField<String> ENTRY_SAP_TEXT = new TypedField<>(String.class, "entry_sap_text");
        TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "attachment_url");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> IMPREST_VOUCHER_NO = new TypedField<>(String.class, "imprest_voucher_no");
        TypedField<String> DOWNLOAD_USER_ID = new TypedField<>(String.class, "download_user_id");
        TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "download_user_name");
        TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "download_status");
        TypedField<LocalDateTime> PAY_LAST_DATE = new TypedField<>(LocalDateTime.class, "pay_last_date");
        TypedField<String> CURRENT_APPROVER = new TypedField<>(String.class, "current_approver");
        TypedField<String> APPROVAL_RECORD = new TypedField<>(String.class, "approval_record");
        TypedField<String> OTHER_REMARK = new TypedField<>(String.class, "other_remark");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "error_msg");
        TypedField<String> IMPREST_TYPE = new TypedField<>(String.class, "imprest_type");
        TypedField<String> PAYEE_BANK_ACCOUNT = new TypedField<>(String.class, "payee_bank_account");
    }
    public interface NoPoImprest {
        static Long id() {
            return 1508347546510368770L;
        }
        static String code() {
            return "noPoImprest";
        }
        TypedField<String> IMPREST_SUB_TYPE = new TypedField<>(String.class, "imprest_sub_type");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contract_id");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contract_type");
        TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "contract_name");
        TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "contract_sign_date");
        TypedField<LocalDateTime> CONTRACT_START_DATE = new TypedField<>(LocalDateTime.class, "contract_start_date");
        TypedField<LocalDateTime> CONTRACT_END_DATE = new TypedField<>(LocalDateTime.class, "contract_end_date");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplier_name");
        TypedField<String> SUPPLIER_BANK = new TypedField<>(String.class, "supplier_bank");
        TypedField<BigDecimal> PAY_AMOUNT = new TypedField<>(BigDecimal.class, "pay_amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "apply_id");
        TypedField<String> PAYMENT_ORDER_TYPE = new TypedField<>(String.class, "payment_order_type");
        TypedField<String> PRE_BUSINESS_TYPE = new TypedField<>(String.class, "pre_business_type");
        TypedField<String> PAY_ID = new TypedField<>(String.class, "pay_id");
        TypedField<String> PAYER = new TypedField<>(String.class, "payer");
        TypedField<String> PAY_BANK_TYPE = new TypedField<>(String.class, "pay_bank_type");
        TypedField<String> PAY_REMARK = new TypedField<>(String.class, "pay_remark");
        TypedField<String> ENTRY_SAP_TEXT = new TypedField<>(String.class, "entry_sap_text");
        TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "attachment_url");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> IMPREST_VOUCHER_NO = new TypedField<>(String.class, "imprest_voucher_no");
        TypedField<String> DOWNLOAD_USER_ID = new TypedField<>(String.class, "download_user_id");
        TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "download_user_name");
        TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "download_status");
        TypedField<LocalDateTime> PAY_LAST_DATE = new TypedField<>(LocalDateTime.class, "pay_last_date");
        TypedField<String> CURRENT_APPROVER = new TypedField<>(String.class, "current_approver");
        TypedField<String> APPROVAL_RECORD = new TypedField<>(String.class, "approval_record");
        TypedField<String> OTHER_REMARK = new TypedField<>(String.class, "other_remark");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "error_msg");
        TypedField<String> IMPREST_TYPE = new TypedField<>(String.class, "imprest_type");
        TypedField<String> PAYEE_BANK_ACCOUNT = new TypedField<>(String.class, "payee_bank_account");
    }
    public interface PoImprest {
        static Long id() {
            return 1508347965789773826L;
        }
        static String code() {
            return "poImprest";
        }
        TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "total_amount");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paid_amount");
        TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "apply_pay_amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "apply_id");
        TypedField<String> PAYMENT_ORDER_TYPE = new TypedField<>(String.class, "payment_order_type");
        TypedField<String> PRE_BUSINESS_TYPE = new TypedField<>(String.class, "pre_business_type");
        TypedField<String> PAY_ID = new TypedField<>(String.class, "pay_id");
        TypedField<String> PAYER = new TypedField<>(String.class, "payer");
        TypedField<String> PAY_BANK_TYPE = new TypedField<>(String.class, "pay_bank_type");
        TypedField<String> PAY_REMARK = new TypedField<>(String.class, "pay_remark");
        TypedField<String> ENTRY_SAP_TEXT = new TypedField<>(String.class, "entry_sap_text");
        TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "attachment_url");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> IMPREST_VOUCHER_NO = new TypedField<>(String.class, "imprest_voucher_no");
        TypedField<String> DOWNLOAD_USER_ID = new TypedField<>(String.class, "download_user_id");
        TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "download_user_name");
        TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "download_status");
        TypedField<LocalDateTime> PAY_LAST_DATE = new TypedField<>(LocalDateTime.class, "pay_last_date");
        TypedField<String> CURRENT_APPROVER = new TypedField<>(String.class, "current_approver");
        TypedField<String> APPROVAL_RECORD = new TypedField<>(String.class, "approval_record");
        TypedField<String> OTHER_REMARK = new TypedField<>(String.class, "other_remark");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "error_msg");
        TypedField<String> IMPREST_TYPE = new TypedField<>(String.class, "imprest_type");
        TypedField<String> PAYEE_BANK_ACCOUNT = new TypedField<>(String.class, "payee_bank_account");
    }
    public interface ApprovalRules {
        static Long id() {
            return 1508687311201861634L;
        }
        static String code() {
            return "approvalRules";
        }
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> NEXT_ROLE = new TypedField<>(String.class, "nextRole");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> NEXT_STATUS = new TypedField<>(String.class, "nextStatus");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> ROLE = new TypedField<>(String.class, "role");
        TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "initiateRole");
        TypedField<String> APPROVAL_STATUS = new TypedField<>(String.class, "approvalStatus");
    }
    public interface PurchaseOrderInit {
        static Long id() {
            return 1508695193221824514L;
        }
        static String code() {
            return "purchaseOrderInit";
        }
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> POST_STATUS_RAW = new TypedField<>(String.class, "postStatusRaw");
        TypedField<String> GENERAL_LEDGER_ACCOUNT = new TypedField<>(String.class, "generalLedgerAccount");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "payedAmount");
        TypedField<BigDecimal> INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "invoicedAmount");
        TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "waitForInvoiceAmount");
        TypedField<BigDecimal> DELIVERIED_AMOUNT = new TypedField<>(BigDecimal.class, "deliveriedAmount");
        TypedField<BigDecimal> PREPAY_AMOUNT = new TypedField<>(BigDecimal.class, "prepayAmount");
        TypedField<BigDecimal> UNPAYED_AMOUNT = new TypedField<>(BigDecimal.class, "unpayedAmount");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "failureReason");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "prepaidAmount");
        TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "buyerInvoiceID");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> IS_COORD = new TypedField<>(String.class, "isCoord");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<String> AMOUNT_WITH_TAX_RAW = new TypedField<>(String.class, "amountWithTaxRaw");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "contractID");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> VAT_CODE = new TypedField<>(String.class, "vatCode");
        TypedField<String> MATERIAL_SERVICES_TEAM = new TypedField<>(String.class, "materialServicesTeam");
        TypedField<String> PROFITS_CENTER = new TypedField<>(String.class, "profitsCenter");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<Long> ITEM = new TypedField<>(Long.class, "item");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "isDelete");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> POST_STATUS = new TypedField<>(String.class, "postStatus");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> SELLER = new TypedField<>(String.class, "seller");
        TypedField<String> IS_DELETE_RAW = new TypedField<>(String.class, "isDeleteRaw");
        TypedField<Long> PURCHASE_ORDER_ITEM_AND_WBS_RELATION_ID = new TypedField<>(Long.class, "purchaseOrderItemAndWbsRelationId");
        TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseBankNo");
        TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseBankName");
        TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseAddress");
        TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseTelephone");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "sellerTelephone");
        TypedField<String> WBS_SUB = new TypedField<>(String.class, "wbsSub");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> ASYNC_STATUS = new TypedField<>(String.class, "asyncStatus");
        TypedField<String> PO_AND_ITEM = new TypedField<>(String.class, "poAndItem");
        TypedField<String> FACTORY = new TypedField<>(String.class, "factory");
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        TypedField<Long> ASYNC_COUNT = new TypedField<>(Long.class, "asyncCount");
        TypedField<String> SAP_CREATE_DATE = new TypedField<>(String.class, "sapCreateDate");
        TypedField<String> SAP_UPDATE_DATE = new TypedField<>(String.class, "sapUpdateDate");
        TypedField<String> SAP_RELEASE_DATE = new TypedField<>(String.class, "sapReleaseDate");
    }
    public interface GoodsReceiptInit {
        static Long id() {
            return 1508697230223310849L;
        }
        static String code() {
            return "goodsReceiptInit";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> PURCHASER_ORDER_AND_GOODS_RECEIPT_ITEMS = new TypedField<>(Long.class, "purchaserOrderAndGoodsReceiptItems");
        TypedField<Long> PURCHASE_ORDER_ITEM_AND_GOODS_RECEIPT_ITEMS = new TypedField<>(Long.class, "purchaseOrderItemAndGoodsReceiptItems");
        TypedField<String> PO_N_O = new TypedField<>(String.class, "poNO");
        TypedField<String> PO_LINE_ITEM_N_O = new TypedField<>(String.class, "poLineItemNO");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> GR_NO = new TypedField<>(String.class, "grNo");
        TypedField<String> GR_ITEM_NO = new TypedField<>(String.class, "grItemNo");
        TypedField<String> ASYNC_STATUS = new TypedField<>(String.class, "asyncStatus");
        TypedField<String> GR_AND_ITEM = new TypedField<>(String.class, "grAndItem");
        TypedField<Long> ASYNC_COUNT = new TypedField<>(Long.class, "asyncCount");
    }
    public interface WbsInit {
        static Long id() {
            return 1508704765277863937L;
        }
        static String code() {
            return "wbsInit";
        }
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        TypedField<String> FIELD_W_B_S_NO = new TypedField<>(String.class, "fieldWBSNo");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> INSTALLATION_EXECUTION_BRANCH = new TypedField<>(String.class, "installationExecutionBranch");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> PROJECT_NAME_BY_ENGLISH = new TypedField<>(String.class, "projectNameByEnglish");
        TypedField<String> MFG_WBS_NO = new TypedField<>(String.class, "mfgWbsNo");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> SOLD_TO_PARTY = new TypedField<>(String.class, "soldToParty");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<String> PROJECT_SCALE = new TypedField<>(String.class, "projectScale");
        TypedField<String> EQUIPMENT_CONTRACT_NO = new TypedField<>(String.class, "equipmentContractNo");
        TypedField<String> INSTALLATION_CONTRACT_NO = new TypedField<>(String.class, "installationContractNo");
        TypedField<String> SYSTEM_STATE = new TypedField<>(String.class, "systemState");
        TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "ladderStatusCode");
        TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "ladderStatusDesc");
        TypedField<String> MANAGER_NAME = new TypedField<>(String.class, "managerName");
        TypedField<String> MANAGER_ID = new TypedField<>(String.class, "managerId");
        TypedField<String> EQUIPMENT_AMOUNT_W_ITH_TAX = new TypedField<>(String.class, "equipmentAmountWIthTax");
        TypedField<String> INSTALLATION_AMOUNT_WITH_TAX = new TypedField<>(String.class, "installationAmountWithTax");
        TypedField<String> FACTORY_FROM = new TypedField<>(String.class, "factoryFrom");
        TypedField<String> LADDER_SPECIES = new TypedField<>(String.class, "ladderSpecies");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "productModel");
        TypedField<String> RATED_LOAD_OF_KG = new TypedField<>(String.class, "ratedLoadOfKg");
        TypedField<String> RATED_SPEED = new TypedField<>(String.class, "ratedSpeed");
        TypedField<String> STROKE_HEIGHT = new TypedField<>(String.class, "strokeHeight");
        TypedField<String> FLOOR = new TypedField<>(String.class, "floor");
        TypedField<String> NUMBER_OF_STOPS = new TypedField<>(String.class, "numberOfStops");
        TypedField<String> TOTAL_SHAFT_HEIGHT = new TypedField<>(String.class, "totalShaftHeight");
        TypedField<String> LIFTING_HEIGHT = new TypedField<>(String.class, "liftingHeight");
        TypedField<String> STEP_WIDTH = new TypedField<>(String.class, "stepWidth");
        TypedField<String> ANGLE = new TypedField<>(String.class, "angle");
        TypedField<String> LENGTH = new TypedField<>(String.class, "length");
        TypedField<String> ORDER_DATE = new TypedField<>(String.class, "orderDate");
        TypedField<String> VALID_ORDER_DATE = new TypedField<>(String.class, "validOrderDate");
        TypedField<String> PM01_REALITY_DATE = new TypedField<>(String.class, "pm01RealityDate");
        TypedField<String> PM05_PLAN_DATE = new TypedField<>(String.class, "pm05PlanDate");
        TypedField<String> PM05_REALITY_DATE = new TypedField<>(String.class, "pm05RealityDate");
        TypedField<String> PM10_PLAN_DATE = new TypedField<>(String.class, "pm10PlanDate");
        TypedField<String> PM10_REALITY_DATE = new TypedField<>(String.class, "pm10RealityDate");
        TypedField<String> PM15_PLAN_DATE = new TypedField<>(String.class, "pm15PlanDate");
        TypedField<String> PM15_REALITY_DATE = new TypedField<>(String.class, "pm15RealityDate");
        TypedField<String> PM20_PLAN_DATE = new TypedField<>(String.class, "pm20PlanDate");
        TypedField<String> PM20_REALITY_DATE = new TypedField<>(String.class, "pm20RealityDate");
        TypedField<String> PM25_PLAN_DATE = new TypedField<>(String.class, "pm25PlanDate");
        TypedField<String> PM25_REALITY_DATE = new TypedField<>(String.class, "pm25RealityDate");
        TypedField<String> PM30_PLAN_DATE = new TypedField<>(String.class, "pm30PlanDate");
        TypedField<String> PM30_REALITY_DATE = new TypedField<>(String.class, "pm30RealityDate");
        TypedField<String> PM35_PLAN_DATE = new TypedField<>(String.class, "pm35PlanDate");
        TypedField<String> PM35_REALITY_DATE = new TypedField<>(String.class, "pm35RealityDate");
        TypedField<String> PM40_PLAN_DATE = new TypedField<>(String.class, "pm40PlanDate");
        TypedField<String> BI03_PLAN_DATE = new TypedField<>(String.class, "bi03PlanDate");
        TypedField<String> BI03_REALITY_DATE = new TypedField<>(String.class, "bi03RealityDate");
        TypedField<String> BI05_PLAN_DATE = new TypedField<>(String.class, "bi05PlanDate");
        TypedField<String> BI05_REALITY_DATE = new TypedField<>(String.class, "bi05RealityDate");
        TypedField<String> BI10_PLAN_DATE = new TypedField<>(String.class, "bi10PlanDate");
        TypedField<String> BI10_REALITY_DATE = new TypedField<>(String.class, "bi10RealityDate");
        TypedField<String> BI15_PLAN_DATE = new TypedField<>(String.class, "bi15PlanDate");
        TypedField<String> BI15_REALITY_DATE = new TypedField<>(String.class, "bi15RealityDate");
        TypedField<String> BI25_PLAN_DATE = new TypedField<>(String.class, "bi25PlanDate");
        TypedField<String> BI25_REALITY_DATE = new TypedField<>(String.class, "bi25RealityDate");
        TypedField<String> BI30_PLAN_DATE = new TypedField<>(String.class, "bi30PlanDate");
        TypedField<String> BI30_REALITY_DATE = new TypedField<>(String.class, "bi30RealityDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<String> PM40_REALITY_DATE = new TypedField<>(String.class, "pm40RealityDate");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ASYNC_STATUS = new TypedField<>(String.class, "asyncStatus");
    }
    public interface SellerInit {
        static Long id() {
            return 1508706602215243778L;
        }
        static String code() {
            return "sellerInit";
        }
        TypedField<String> SELLER = new TypedField<>(String.class, "seller");
        TypedField<String> ADDRESS = new TypedField<>(String.class, "address");
        TypedField<String> TEL1 = new TypedField<>(String.class, "tel1");
        TypedField<String> TEL2 = new TypedField<>(String.class, "tel2");
        TypedField<String> TAX_NO1 = new TypedField<>(String.class, "taxNo1");
        TypedField<String> TAX_NO2 = new TypedField<>(String.class, "taxNo2");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IS_PRIMARY_KEY_ABSENT = new TypedField<>(String.class, "isPrimaryKeyAbsent");
        TypedField<String> IS_REQUIRED_ABSENT = new TypedField<>(String.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<String> ASYNC_STATUS = new TypedField<>(String.class, "asyncStatus");
    }
    public interface PoForm {
        static Long id() {
            return 1510114054534144002L;
        }
        static String code() {
            return "poForm";
        }
        TypedField<Long> INSTALLMENT = new TypedField<>(Long.class, "installment");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> MAKE_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "makeInvoiceAmount");
    }
    public interface ApplyId {
        static Long id() {
            return 1511534862068150273L;
        }
        static String code() {
            return "applyId";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
    }
    public interface InvoiceDetailRelation {
        static Long id() {
            return 1511614716130160641L;
        }
        static String code() {
            return "invoiceDetailRelation";
        }
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> PRE_INVOICE_ID = new TypedField<>(String.class, "preInvoiceId");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbillItemNo");
        TypedField<String> PRE_INVOICE_ITEM_ID = new TypedField<>(String.class, "preInvoiceItemId");
        TypedField<String> SALESBILL_ITEM_ID = new TypedField<>(String.class, "salesbillItemId");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> CARGO_CODE = new TypedField<>(String.class, "cargoCode");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargoName");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<String> GOODS_NO_VER = new TypedField<>(String.class, "goodsNoVer");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> DISCOUNT_FLAG = new TypedField<>(String.class, "discountFlag");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> PRINT_CONTENT_FLAG = new TypedField<>(String.class, "printContentFlag");
        TypedField<String> INVOICE_ITEM_ID = new TypedField<>(String.class, "invoiceItemId");
        TypedField<String> INVOICE_NOTICE_NO = new TypedField<>(String.class, "invoiceNoticeNo");
        TypedField<String> INVOICE_NOTICE_ITEM_ID = new TypedField<>(String.class, "invoiceNoticeItemId");
        TypedField<String> INVOICE_NOTICE_ITEM_NO = new TypedField<>(String.class, "invoiceNoticeItemNo");
        TypedField<String> PURCHASE_ORDER_NO = new TypedField<>(String.class, "purchaseOrderNo");
        TypedField<String> PURCHASE_ORDER_ITEM_ID = new TypedField<>(String.class, "purchaseOrderItemId");
        TypedField<String> PURCHASE_ORDER_ITEM_NO = new TypedField<>(String.class, "purchaseOrderItemNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> DEDUCTION = new TypedField<>(BigDecimal.class, "deduction");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ITEM_RELATIONSHIP_ID = new TypedField<>(Long.class, "invoiceItemRelationship.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ITEM_RELATIONSHIP {
                static String code () {
                    return "invoiceItemRelationship" ;
                }
                TypedField<String> PRE_N_O = new TypedField<>(String.class, "invoiceItemRelationship.preNO");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceItemRelationship.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceItemRelationship.invoiceNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceItemRelationship.invoiceType");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceItemRelationship.invoiceStatus");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceItemRelationship.invoiceUrl");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.paperDrawDate");
                TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.sendDate");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.receiptDate");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.submitDate");
                TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.postingDate");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.paymentDate");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceItemRelationship.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceItemRelationship.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceItemRelationship.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceItemRelationship.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceItemRelationship.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceItemRelationship.delete_flag");
                TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "invoiceItemRelationship.expressNumber");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.amountWithoutTax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceItemRelationship.sellerNo");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceItemRelationship.buyerID");
                TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.applyPayAmount");
                TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "invoiceItemRelationship.voucherNo");
                TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "invoiceItemRelationship.voucherText");
                TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.payBaseDay");
                TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.actualPayDay");
                TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.authDate");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "invoiceItemRelationship.paymentNo");
                TypedField<String> PO_NO = new TypedField<>(String.class, "invoiceItemRelationship.poNo");
                TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "invoiceItemRelationship.accountStatus");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "invoiceItemRelationship.payStatus");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.paidAmount");
                TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.invoicePayAmount");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceItemRelationship.sellerTaxNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceItemRelationship.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceItemRelationship.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceItemRelationship.sellerTel");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "invoiceItemRelationship.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceItemRelationship.sellerBankName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceItemRelationship.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.purchaserName");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceItemRelationship.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceItemRelationship.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceItemRelationship.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceItemRelationship.purchaserBankName");
                TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "invoiceItemRelationship.purchaserBankNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceItemRelationship.remark");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.invoicerName");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceItemRelationship.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceItemRelationship.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceItemRelationship.redNotificationNo");
                TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.taxDeclarationPeriod");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.scanTime");
                TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "invoiceItemRelationship.scanDeductionImageUrl");
                TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "invoiceItemRelationship.scanInvoiceImageUrl");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceItemRelationship.purchaserNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceItemRelationship.status");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "invoiceItemRelationship.authStatus");
                TypedField<String> TAX_FLAG = new TypedField<>(String.class, "invoiceItemRelationship.taxFlag");
                TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "invoiceItemRelationship.scanStatus");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceItemRelationship.source");
                TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "invoiceItemRelationship.invoiceNoticeNos");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceItemRelationship.invoiceId");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "invoiceItemRelationship.purchasingTeam");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "invoiceItemRelationship.sendCount");
                TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "invoiceItemRelationship.backCount");
                TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "invoiceItemRelationship.recommendationFlag");
                TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.matchedAmount");
                TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.account_date");
                TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "invoiceItemRelationship.relationCount");
                TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "invoiceItemRelationship.lastSource");
                TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "invoiceItemRelationship.originFile");
                TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "invoiceItemRelationship.originFileUrl");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "invoiceItemRelationship.returnReason");
                TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.availableAmount");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "invoiceItemRelationship.serialNo");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "invoiceItemRelationship.isReplace");
                TypedField<String> REPLACE_SELLER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.replaceSellerName");
                TypedField<String> REPLACE_SELLER_TAX_NO = new TypedField<>(String.class, "invoiceItemRelationship.replaceSellerTaxNo");
                TypedField<String> ORIGIN_SELLER_NAME = new TypedField<>(String.class, "invoiceItemRelationship.originSellerName");
                TypedField<String> ORIGIN_SELLER_TAX_NO = new TypedField<>(String.class, "invoiceItemRelationship.originSellerTaxNo");
                TypedField<BigDecimal> AVAILABLE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.availableAmountWithoutTax");
                TypedField<String> IMAGE_ID = new TypedField<>(String.class, "invoiceItemRelationship.imageId");
                TypedField<String> COORDINATION_TYPE = new TypedField<>(String.class, "invoiceItemRelationship.coordinationType");
                TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceItemRelationship.matchedAmountWithoutTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceItemRelationship.taxRate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "invoiceItemRelationship.poNumbers");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "invoiceItemRelationship.dataSource");
                TypedField<String> SELLER_GROUP_ID = new TypedField<>(String.class, "invoiceItemRelationship.sellerGroupId");
                TypedField<Boolean> LOCK_FLAG = new TypedField<>(Boolean.class, "invoiceItemRelationship.lockFlag");
                TypedField<String> ARCHIVE_NO = new TypedField<>(String.class, "invoiceItemRelationship.archiveNo");
                TypedField<String> WITHDRAW_TYPE = new TypedField<>(String.class, "invoiceItemRelationship.withdrawType");
                TypedField<String> IRID = new TypedField<>(String.class, "invoiceItemRelationship.irid");
                TypedField<String> IS_REMOVED = new TypedField<>(String.class, "invoiceItemRelationship.isRemoved");
                TypedField<LocalDateTime> MATCH_UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemRelationship.matchUpdateTime");
            }
        }
    }
    public interface RpaResponse {
        static Long id() {
            return 1513777172487012354L;
        }
        static String code() {
            return "rpaResponse";
        }
        TypedField<String> TASK_NO = new TypedField<>(String.class, "taskNo");
        TypedField<String> TASK_TYPE = new TypedField<>(String.class, "taskType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RESPONSE = new TypedField<>(String.class, "response");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Boolean> IS_MANUAL = new TypedField<>(Boolean.class, "isManual");
        /**
         * 对一关联关系 关联对象 rpaTask
         */
        TypedField<Long> RPA_TASK_ANDRPA_RESPONSE_RELATION_ID = new TypedField<>(Long.class, "rpaTaskAndrpaResponseRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface RPA_TASK_ANDRPA_RESPONSE_RELATION {
                static String code () {
                    return "rpaTaskAndrpaResponseRelation" ;
                }
                TypedField<String> TASK_TYPE = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.taskType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.businessType");
                TypedField<LocalDateTime> WAREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "rpaTaskAndrpaResponseRelation.warehousingTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "rpaTaskAndrpaResponseRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "rpaTaskAndrpaResponseRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "rpaTaskAndrpaResponseRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "rpaTaskAndrpaResponseRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "rpaTaskAndrpaResponseRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "rpaTaskAndrpaResponseRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.delete_flag");
                TypedField<String> TASK_NO = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.taskNo");
                TypedField<String> BILL_N_O = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.billNO");
                TypedField<String> STATUS = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.status");
                TypedField<String> RESQUST_BODY = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.resqustBody");
                TypedField<String> REMARK = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.remark");
                TypedField<Long> RESPONSE_COUNT = new TypedField<>(Long.class, "rpaTaskAndrpaResponseRelation.responseCount");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "rpaTaskAndrpaResponseRelation.errorInfo");
            }
        }
    }
    public interface CostCenter {
        static Long id() {
            return 1513788704667267074L;
        }
        static String code() {
            return "costCenter";
        }
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> PERFORMANCE_BRANCH = new TypedField<>(String.class, "performanceBranch");
        TypedField<String> TAX_BRANCH = new TypedField<>(String.class, "taxBranch");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> CITY = new TypedField<>(String.class, "city");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> CTR_SHORT_TEXT = new TypedField<>(String.class, "ctrShortText");
        TypedField<String> CTR_LONG_TEXT = new TypedField<>(String.class, "ctrLongText");
        TypedField<String> CHINESE_SHORT_TEXT = new TypedField<>(String.class, "chineseShortText");
        TypedField<String> CHINESE_LONG_TEXT = new TypedField<>(String.class, "chineseLongText");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> LINE_ID = new TypedField<>(Long.class, "lineId");
    }
    public interface PayInvoNoBillRelation {
        static Long id() {
            return 1514519943961608194L;
        }
        static String code() {
            return "payInvoNoBillRelation";
        }
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> PAY_MENT_ID = new TypedField<>(Long.class, "payMentId");
        TypedField<Long> INVOICE_NOTICE_BILL_ID = new TypedField<>(Long.class, "invoiceNoticeBillId");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paidAmount");
        TypedField<Long> INVOICE_NOTICE_BILL_TEAM_ID = new TypedField<>(Long.class, "invoiceNoticeBillTeamId");
        TypedField<BigDecimal> PAID_QUANTITY = new TypedField<>(BigDecimal.class, "paidQuantity");
        TypedField<String> PRE_NO = new TypedField<>(String.class, "preNo");
        TypedField<String> ITEM_N_O = new TypedField<>(String.class, "itemNO");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<String> PAYMENT_STATUS_EXP = new TypedField<>(String.class, "paymentStatusExp");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> PAID_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "paidAmountWithoutTax");
        TypedField<String> EDIT_STATUS = new TypedField<>(String.class, "editStatus");
        /**
         * 对一关联关系 关联对象 invoiceNoticeBillItem
         */
        TypedField<Long> PAY_INVO_NO_BILL_ITEM_RELATION_ID = new TypedField<>(Long.class, "payInvoNoBillItemRelation.id");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> PAYMENT_INVO_NO_BILL_ITEM_RELATION_ID = new TypedField<>(Long.class, "paymentInvoNoBillItemRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PAY_INVO_NO_BILL_ITEM_RELATION {
                static String code () {
                    return "payInvoNoBillItemRelation" ;
                }
                TypedField<String> ITEM_N_O = new TypedField<>(String.class, "payInvoNoBillItemRelation.itemNO");
                TypedField<String> ITEM_NAME = new TypedField<>(String.class, "payInvoNoBillItemRelation.itemName");
                TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "payInvoNoBillItemRelation.itemSpec");
                TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "payInvoNoBillItemRelation.quantityUnit");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.quantity");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "payInvoNoBillItemRelation.goodsTaxNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "payInvoNoBillItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "payInvoNoBillItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "payInvoNoBillItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "payInvoNoBillItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "payInvoNoBillItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "payInvoNoBillItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "payInvoNoBillItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "payInvoNoBillItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "payInvoNoBillItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "payInvoNoBillItemRelation.delete_flag");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "payInvoNoBillItemRelation.invoiceType");
                TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "payInvoNoBillItemRelation.invoiceNoticeNO");
                TypedField<String> BILL_N_O = new TypedField<>(String.class, "payInvoNoBillItemRelation.billNO");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "payInvoNoBillItemRelation.costCenter");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "payInvoNoBillItemRelation.profitCenter");
                TypedField<String> WBS = new TypedField<>(String.class, "payInvoNoBillItemRelation.wbs");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "payInvoNoBillItemRelation.contractNo");
                TypedField<String> VIEW_ID = new TypedField<>(String.class, "payInvoNoBillItemRelation.viewId");
                TypedField<String> LADDER_STATUS = new TypedField<>(String.class, "payInvoNoBillItemRelation.ladderStatus");
                TypedField<String> PRE_NO = new TypedField<>(String.class, "payInvoNoBillItemRelation.preNo");
                TypedField<String> PRE_ITEM_NO = new TypedField<>(String.class, "payInvoNoBillItemRelation.preItemNo");
                TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "payInvoNoBillItemRelation.materialServices");
                TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "payInvoNoBillItemRelation.materialServicesName");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.taxRate");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.taxAmount");
                TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.totalPayQty");
                TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.totalPayAmount");
                TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "payInvoNoBillItemRelation.businessStatus");
                TypedField<String> BUSINESS_STATUS_EXPR = new TypedField<>(String.class, "payInvoNoBillItemRelation.businessStatusExpr");
                TypedField<BigDecimal> AMOUNT_WITH_TAX_RAW = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.amountWithTaxRaw");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.unitPrice");
                TypedField<String> EDIT_STATUS = new TypedField<>(String.class, "payInvoNoBillItemRelation.editStatus");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX_RAW = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.amountWithoutTaxRaw");
                TypedField<BigDecimal> ALL_PAY_QTY = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.allPayQty");
                TypedField<BigDecimal> ALL_PAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.allPayAmountWithTax");
                TypedField<BigDecimal> ALL_PAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "payInvoNoBillItemRelation.allPayAmountWithoutTax");
                TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "payInvoNoBillItemRelation.contractID");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "payInvoNoBillItemRelation.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "payInvoNoBillItemRelation.pmNode");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "payInvoNoBillItemRelation.projectDefinition");
            }
            interface PAYMENT_INVO_NO_BILL_ITEM_RELATION {
                static String code () {
                    return "paymentInvoNoBillItemRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "paymentInvoNoBillItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "paymentInvoNoBillItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "paymentInvoNoBillItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "paymentInvoNoBillItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "paymentInvoNoBillItemRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "paymentInvoNoBillItemRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "paymentInvoNoBillItemRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "paymentInvoNoBillItemRelation.salesPersonId");
            }
        }
    }
    public interface InvoiceNoticeBillRelation {
        static Long id() {
            return 1516356764589035522L;
        }
        static String code() {
            return "invoiceNoticeBillRelation";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<BigDecimal> DISTRIBUTE_ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "distributeOrderAmount");
        TypedField<String> INVOICE_NOTICE_NO = new TypedField<>(String.class, "invoiceNoticeNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> INVOICE_ID = new TypedField<>(Long.class, "invoiceId");
        TypedField<Long> INVOICE_NOTICE_BILL_ID = new TypedField<>(Long.class, "invoiceNoticeBillId");
        TypedField<String> INVOICE_REGISTER_STATUS = new TypedField<>(String.class, "invoiceRegisterStatus");
        TypedField<String> PURCHASE_ORDER_NO = new TypedField<>(String.class, "purchaseOrderNo");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "matchedAmountWithoutTax");
        /**
         * 对一关联关系 关联对象 invoiceNoticeBill
         */
        TypedField<Long> INVOICE_MATHER_RELATTIONSHIP_ID = new TypedField<>(Long.class, "invoiceMatherRelattionship.id");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_MATCH_RELATIONSHIP_ID = new TypedField<>(Long.class, "invoiceMatchRelationship.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_MATHER_RELATTIONSHIP {
                static String code () {
                    return "invoiceMatherRelattionship" ;
                }
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceMatherRelattionship.invoiceType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "invoiceMatherRelattionship.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceMatherRelattionship.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceMatherRelattionship.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceMatherRelattionship.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceMatherRelattionship.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMatherRelattionship.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMatherRelattionship.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceMatherRelattionship.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceMatherRelattionship.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceMatherRelattionship.delete_flag");
                TypedField<String> PRE_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.preNo");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "invoiceMatherRelattionship.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceMatherRelattionship.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "invoiceMatherRelattionship.priceMethod");
                TypedField<String> WBS = new TypedField<>(String.class, "invoiceMatherRelattionship.wbs");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "invoiceMatherRelattionship.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "invoiceMatherRelattionship.node");
                TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceMatherRelattionship.invoiceNoticeNO");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceMatherRelattionship.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "invoiceMatherRelattionship.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "invoiceMatherRelattionship.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "invoiceMatherRelattionship.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "invoiceMatherRelattionship.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "invoiceMatherRelattionship.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceMatherRelattionship.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceMatherRelattionship.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceMatherRelattionship.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "invoiceMatherRelattionship.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "invoiceMatherRelattionship.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "invoiceMatherRelattionship.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "invoiceMatherRelattionship.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "invoiceMatherRelattionship.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "invoiceMatherRelattionship.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceMatherRelattionship.invoiceCode");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "invoiceMatherRelattionship.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "invoiceMatherRelattionship.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "invoiceMatherRelattionship.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.hippedQuantity");
                TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceMatherRelattionship.matchedAmountWithoutTax");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "invoiceMatherRelattionship.projectDefinition");
                TypedField<Long> VALID_SELLEMENT_COUNT = new TypedField<>(Long.class, "invoiceMatherRelattionship.validSellementCount");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "invoiceMatherRelattionship.pmNode");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "invoiceMatherRelattionship.ladderNo");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "invoiceMatherRelattionship.dataSource");
                TypedField<String> GENERATE_SETTLE_STATUS = new TypedField<>(String.class, "invoiceMatherRelattionship.generateSettleStatus");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "invoiceMatherRelattionship.projectName");
                TypedField<String> IRID = new TypedField<>(String.class, "invoiceMatherRelattionship.irid");
            }
            interface INVOICE_MATCH_RELATIONSHIP {
                static String code () {
                    return "invoiceMatchRelationship" ;
                }
                TypedField<String> PRE_N_O = new TypedField<>(String.class, "invoiceMatchRelationship.preNO");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceMatchRelationship.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceMatchRelationship.invoiceNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceMatchRelationship.invoiceType");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceMatchRelationship.invoiceStatus");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceMatchRelationship.invoiceUrl");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.paperDrawDate");
                TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.sendDate");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.receiptDate");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.submitDate");
                TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.postingDate");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.paymentDate");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceMatchRelationship.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceMatchRelationship.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceMatchRelationship.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceMatchRelationship.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceMatchRelationship.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceMatchRelationship.delete_flag");
                TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "invoiceMatchRelationship.expressNumber");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.amountWithoutTax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceMatchRelationship.sellerNo");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceMatchRelationship.buyerID");
                TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.applyPayAmount");
                TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "invoiceMatchRelationship.voucherNo");
                TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "invoiceMatchRelationship.voucherText");
                TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.payBaseDay");
                TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.actualPayDay");
                TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.authDate");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "invoiceMatchRelationship.paymentNo");
                TypedField<String> PO_NO = new TypedField<>(String.class, "invoiceMatchRelationship.poNo");
                TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "invoiceMatchRelationship.accountStatus");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "invoiceMatchRelationship.payStatus");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.paidAmount");
                TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.invoicePayAmount");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMatchRelationship.sellerTaxNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceMatchRelationship.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceMatchRelationship.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceMatchRelationship.sellerTel");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "invoiceMatchRelationship.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.sellerBankName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserName");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserBankName");
                TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserBankNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceMatchRelationship.remark");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.invoicerName");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceMatchRelationship.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceMatchRelationship.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceMatchRelationship.redNotificationNo");
                TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.taxDeclarationPeriod");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.scanTime");
                TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "invoiceMatchRelationship.scanDeductionImageUrl");
                TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "invoiceMatchRelationship.scanInvoiceImageUrl");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceMatchRelationship.purchaserNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceMatchRelationship.status");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "invoiceMatchRelationship.authStatus");
                TypedField<String> TAX_FLAG = new TypedField<>(String.class, "invoiceMatchRelationship.taxFlag");
                TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "invoiceMatchRelationship.scanStatus");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceMatchRelationship.source");
                TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "invoiceMatchRelationship.invoiceNoticeNos");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceMatchRelationship.invoiceId");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "invoiceMatchRelationship.purchasingTeam");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "invoiceMatchRelationship.sendCount");
                TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "invoiceMatchRelationship.backCount");
                TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "invoiceMatchRelationship.recommendationFlag");
                TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.matchedAmount");
                TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.account_date");
                TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "invoiceMatchRelationship.relationCount");
                TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "invoiceMatchRelationship.lastSource");
                TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "invoiceMatchRelationship.originFile");
                TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "invoiceMatchRelationship.originFileUrl");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "invoiceMatchRelationship.returnReason");
                TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.availableAmount");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "invoiceMatchRelationship.serialNo");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "invoiceMatchRelationship.isReplace");
                TypedField<String> REPLACE_SELLER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.replaceSellerName");
                TypedField<String> REPLACE_SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMatchRelationship.replaceSellerTaxNo");
                TypedField<String> ORIGIN_SELLER_NAME = new TypedField<>(String.class, "invoiceMatchRelationship.originSellerName");
                TypedField<String> ORIGIN_SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMatchRelationship.originSellerTaxNo");
                TypedField<BigDecimal> AVAILABLE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.availableAmountWithoutTax");
                TypedField<String> IMAGE_ID = new TypedField<>(String.class, "invoiceMatchRelationship.imageId");
                TypedField<String> COORDINATION_TYPE = new TypedField<>(String.class, "invoiceMatchRelationship.coordinationType");
                TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceMatchRelationship.matchedAmountWithoutTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceMatchRelationship.taxRate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "invoiceMatchRelationship.poNumbers");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "invoiceMatchRelationship.dataSource");
                TypedField<String> SELLER_GROUP_ID = new TypedField<>(String.class, "invoiceMatchRelationship.sellerGroupId");
                TypedField<Boolean> LOCK_FLAG = new TypedField<>(Boolean.class, "invoiceMatchRelationship.lockFlag");
                TypedField<String> ARCHIVE_NO = new TypedField<>(String.class, "invoiceMatchRelationship.archiveNo");
                TypedField<String> WITHDRAW_TYPE = new TypedField<>(String.class, "invoiceMatchRelationship.withdrawType");
                TypedField<String> IRID = new TypedField<>(String.class, "invoiceMatchRelationship.irid");
                TypedField<String> IS_REMOVED = new TypedField<>(String.class, "invoiceMatchRelationship.isRemoved");
                TypedField<LocalDateTime> MATCH_UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMatchRelationship.matchUpdateTime");
            }
        }
    }
    public interface Wbs {
        static Long id() {
            return 1517328568354443266L;
        }
        static String code() {
            return "wbs";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> FIELD_W_B_S_NO = new TypedField<>(String.class, "fieldWBSNo");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "ladderStatusCode");
        TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "ladderStatusDesc");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface AddPO {
        static Long id() {
            return 1518414111234555906L;
        }
        static String code() {
            return "addPO";
        }
        TypedField<String> BILL_N_O = new TypedField<>(String.class, "billNO");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ReceiptInitFailedHistory {
        static Long id() {
            return 1518521062160588801L;
        }
        static String code() {
            return "receiptInitFailedHistory";
        }
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PO_N_O = new TypedField<>(String.class, "poNO");
        TypedField<String> PO_LINE_ITEM_N_O = new TypedField<>(String.class, "poLineItemNO");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> GR_NO = new TypedField<>(String.class, "grNo");
        TypedField<String> GR_ITEM_NO = new TypedField<>(String.class, "grItemNo");
    }
    public interface WbsInitFaieledHistory {
        static Long id() {
            return 1518521281917714433L;
        }
        static String code() {
            return "wbsInitFaieledHistory";
        }
        TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "projectDefinition");
        TypedField<String> FIELD_W_B_S_NO = new TypedField<>(String.class, "fieldWBSNo");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> INSTALLATION_EXECUTION_BRANCH = new TypedField<>(String.class, "installationExecutionBranch");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> PROJECT_NAME_BY_ENGLISH = new TypedField<>(String.class, "projectNameByEnglish");
        TypedField<String> MFG_WBS_NO = new TypedField<>(String.class, "mfgWbsNo");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> SOLD_TO_PARTY = new TypedField<>(String.class, "soldToParty");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<String> PROJECT_SCALE = new TypedField<>(String.class, "projectScale");
        TypedField<String> EQUIPMENT_CONTRACT_NO = new TypedField<>(String.class, "equipmentContractNo");
        TypedField<String> INSTALLATION_CONTRACT_NO = new TypedField<>(String.class, "installationContractNo");
        TypedField<String> SYSTEM_STATE = new TypedField<>(String.class, "systemState");
        TypedField<String> LADDER_STATUS_CODE = new TypedField<>(String.class, "ladderStatusCode");
        TypedField<String> LADDER_STATUS_DESC = new TypedField<>(String.class, "ladderStatusDesc");
        TypedField<String> MANAGER_NAME = new TypedField<>(String.class, "managerName");
        TypedField<String> MANAGER_ID = new TypedField<>(String.class, "managerId");
        TypedField<String> EQUIPMENT_AMOUNT_W_ITH_TAX = new TypedField<>(String.class, "equipmentAmountWIthTax");
        TypedField<String> INSTALLATION_AMOUNT_WITH_TAX = new TypedField<>(String.class, "installationAmountWithTax");
        TypedField<String> FACTORY_FROM = new TypedField<>(String.class, "factoryFrom");
        TypedField<String> LADDER_SPECIES = new TypedField<>(String.class, "ladderSpecies");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "productModel");
        TypedField<String> RATED_LOAD_OF_KG = new TypedField<>(String.class, "ratedLoadOfKg");
        TypedField<String> RATED_SPEED = new TypedField<>(String.class, "ratedSpeed");
        TypedField<String> STROKE_HEIGHT = new TypedField<>(String.class, "strokeHeight");
        TypedField<String> FLOOR = new TypedField<>(String.class, "floor");
        TypedField<String> NUMBER_OF_STOPS = new TypedField<>(String.class, "numberOfStops");
        TypedField<String> TOTAL_SHAFT_HEIGHT = new TypedField<>(String.class, "totalShaftHeight");
        TypedField<String> LIFTING_HEIGHT = new TypedField<>(String.class, "liftingHeight");
        TypedField<String> STEP_WIDTH = new TypedField<>(String.class, "stepWidth");
        TypedField<String> ANGLE = new TypedField<>(String.class, "angle");
        TypedField<String> LENGTH = new TypedField<>(String.class, "length");
        TypedField<String> ORDER_DATE = new TypedField<>(String.class, "orderDate");
        TypedField<String> VALID_ORDER_DATE = new TypedField<>(String.class, "validOrderDate");
        TypedField<String> PM01_REALITY_DATE = new TypedField<>(String.class, "pm01RealityDate");
        TypedField<String> PM05_PLAN_DATE = new TypedField<>(String.class, "pm05PlanDate");
        TypedField<String> PM05_REALITY_DATE = new TypedField<>(String.class, "pm05RealityDate");
        TypedField<String> PM10_PLAN_DATE = new TypedField<>(String.class, "pm10PlanDate");
        TypedField<String> PM10_REALITY_DATE = new TypedField<>(String.class, "pm10RealityDate");
        TypedField<String> PM15_PLAN_DATE = new TypedField<>(String.class, "pm15PlanDate");
        TypedField<String> PM15_REALITY_DATE = new TypedField<>(String.class, "pm15RealityDate");
        TypedField<String> PM20_PLAN_DATE = new TypedField<>(String.class, "pm20PlanDate");
        TypedField<String> PM20_REALITY_DATE = new TypedField<>(String.class, "pm20RealityDate");
        TypedField<String> PM25_PLAN_DATE = new TypedField<>(String.class, "pm25PlanDate");
        TypedField<String> PM25_REALITY_DATE = new TypedField<>(String.class, "pm25RealityDate");
        TypedField<String> PM30_PLAN_DATE = new TypedField<>(String.class, "pm30PlanDate");
        TypedField<String> PM30_REALITY_DATE = new TypedField<>(String.class, "pm30RealityDate");
        TypedField<String> PM35_PLAN_DATE = new TypedField<>(String.class, "pm35PlanDate");
        TypedField<String> PM35_REALITY_DATE = new TypedField<>(String.class, "pm35RealityDate");
        TypedField<String> PM40_PLAN_DATE = new TypedField<>(String.class, "pm40PlanDate");
        TypedField<String> PM405_REALITY_DATE = new TypedField<>(String.class, "pm405RealityDate");
        TypedField<String> BI03_PLAN_DATE = new TypedField<>(String.class, "bi03PlanDate");
        TypedField<String> BI03_REALITY_DATE = new TypedField<>(String.class, "bi03RealityDate");
        TypedField<String> BI05_PLAN_DATE = new TypedField<>(String.class, "bi05PlanDate");
        TypedField<String> BI05_REALITY_DATE = new TypedField<>(String.class, "bi05RealityDate");
        TypedField<String> BI10_PLAN_DATE = new TypedField<>(String.class, "bi10PlanDate");
        TypedField<String> BI10_REALITY_DATE = new TypedField<>(String.class, "bi10RealityDate");
        TypedField<String> BI15_PLAN_DATE = new TypedField<>(String.class, "bi15PlanDate");
        TypedField<String> BI15_REALITY_DATE = new TypedField<>(String.class, "bi15RealityDate");
        TypedField<String> BI25_PLAN_DATE = new TypedField<>(String.class, "bi25PlanDate");
        TypedField<String> BI25_REALITY_DATE = new TypedField<>(String.class, "bi25RealityDate");
        TypedField<String> BI30_PLAN_DATE = new TypedField<>(String.class, "bi30PlanDate");
        TypedField<String> BI30_REALITY_DATE = new TypedField<>(String.class, "bi30RealityDate");
        TypedField<String> IS_PRIMARY_KEY_ABSENT = new TypedField<>(String.class, "isPrimaryKeyAbsent");
        TypedField<String> IS_REQUIRED_ABSENT = new TypedField<>(String.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface SellerInitFailedHistory {
        static Long id() {
            return 1518521495130202113L;
        }
        static String code() {
            return "sellerInitFailedHistory";
        }
        TypedField<String> SELLER = new TypedField<>(String.class, "seller");
        TypedField<String> ADDRESS = new TypedField<>(String.class, "address");
        TypedField<String> TEL1 = new TypedField<>(String.class, "tel1");
        TypedField<String> TEL2 = new TypedField<>(String.class, "tel2");
        TypedField<String> TAX_NO1 = new TypedField<>(String.class, "taxNo1");
        TypedField<String> TAX_NO2 = new TypedField<>(String.class, "taxNo2");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<String> IS_PRIMARY_KEY_ABSENT = new TypedField<>(String.class, "isPrimaryKeyAbsent");
        TypedField<String> IS_REQUIRED_ABSENT = new TypedField<>(String.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ARPowerBiFailedHisTory {
        static Long id() {
            return 1518521784784642049L;
        }
        static String code() {
            return "aRPowerBiFailedHisTory";
        }
        TypedField<BigDecimal> COLLECTION_PERCENT = new TypedField<>(BigDecimal.class, "collectionPercent");
        TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<LocalDateTime> AREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "arehousingTime");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> IS_PRIMARY_KEY_ABSENT = new TypedField<>(String.class, "isPrimaryKeyAbsent");
        TypedField<String> IS_REQUIRED_ABSENT = new TypedField<>(String.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ARPowerBiInit {
        static Long id() {
            return 1518929813230133249L;
        }
        static String code() {
            return "aRPowerBiInit";
        }
        TypedField<BigDecimal> COLLECTION_PERCENT = new TypedField<>(BigDecimal.class, "collectionPercent");
        TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<LocalDateTime> AREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "arehousingTime");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> IS_PRIMARY_KEY_ABSENT = new TypedField<>(String.class, "isPrimaryKeyAbsent");
        TypedField<String> IS_REQUIRED_ABSENT = new TypedField<>(String.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ASYNC_STATUS = new TypedField<>(String.class, "asyncStatus");
    }
    public interface SellerInfo {
        static Long id() {
            return 1518935684056162305L;
        }
        static String code() {
            return "sellerInfo";
        }
        TypedField<String> SELLER = new TypedField<>(String.class, "seller");
        TypedField<String> ADDRESS = new TypedField<>(String.class, "address");
        TypedField<String> TEL1 = new TypedField<>(String.class, "tel1");
        TypedField<String> TEL2 = new TypedField<>(String.class, "tel2");
        TypedField<String> TAX_NO1 = new TypedField<>(String.class, "taxNo1");
        TypedField<String> TAX_NO2 = new TypedField<>(String.class, "taxNo2");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<String> IS_PRIMARY_KEY_ABSENT = new TypedField<>(String.class, "isPrimaryKeyAbsent");
        TypedField<String> IS_REQUIRED_ABSENT = new TypedField<>(String.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface AgentFeeReport {
        static Long id() {
            return 1519876310040965122L;
        }
        static String code() {
            return "agentFeeReport";
        }
        TypedField<String> LO_B = new TypedField<>(String.class, "loB");
        TypedField<String> SALES_REGION = new TypedField<>(String.class, "salesRegion");
        TypedField<String> EXECUTION_REGION = new TypedField<>(String.class, "executionRegion");
        TypedField<String> PROJECT_NAME_ZH = new TypedField<>(String.class, "projectNameZh");
        TypedField<String> PROJECT_NAME_EN = new TypedField<>(String.class, "projectNameEn");
        TypedField<String> SALES_CHANNEL = new TypedField<>(String.class, "salesChannel");
        TypedField<String> SALES_BRANCH_EN = new TypedField<>(String.class, "salesBranchEn");
        TypedField<String> EXECUTION_BRANCH_EN = new TypedField<>(String.class, "executionBranchEn");
        TypedField<String> IF_CROSS_BRANCH_PROJECT = new TypedField<>(String.class, "ifCrossBranchProject");
        TypedField<String> FIRST_O_I_DATE = new TypedField<>(String.class, "firstOIDate");
        TypedField<String> SALES_BRANCH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "salesBranchVIEWProjectId");
        TypedField<String> EXECUTION_BRANCH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "executionBranchVIEWProjectId");
        TypedField<String> DAPROH_PROJECT_ID = new TypedField<>(String.class, "daprohProjectId");
        TypedField<String> DAPROH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "daprohVIEWProjectId");
        TypedField<String> PROJECT_STATUS = new TypedField<>(String.class, "projectStatus");
        TypedField<String> AGENT_SUPPLIER_NAME = new TypedField<>(String.class, "agentSupplierName");
        TypedField<String> AGENT_SUPPLIER_G_M_D_S_NO = new TypedField<>(String.class, "agentSupplierGMDSNo");
        TypedField<String> PROJECT_EQUIPMENT_CONTRACT_VALUE = new TypedField<>(String.class, "projectEquipmentContractValue");
        TypedField<String> TOTAL_PROJECT_COLLECTED_MONEY = new TypedField<>(String.class, "totalProjectCollectedMoney");
        TypedField<String> COLLECTION_PERCENT = new TypedField<>(String.class, "collectionPercent");
        TypedField<String> CONTRACT_AMOUNT_VO = new TypedField<>(String.class, "contractAmountVo");
        TypedField<String> COLLECTION_AMOUNT_VO = new TypedField<>(String.class, "collectionAmountVo");
        TypedField<String> COLLECTION_PERCENT_VO = new TypedField<>(String.class, "collectionPercentVo");
        TypedField<String> AGENT_FEE_PO_NUMBER = new TypedField<>(String.class, "agentFeePoNumber");
        TypedField<String> TOTAL_AGENT_FEE_PO_AMOUNT = new TypedField<>(String.class, "totalAgentFeePoAmount");
        TypedField<String> TOTAL_ACCUMULATIVE_PAYABLE_AGENT_FEE = new TypedField<>(String.class, "totalAccumulativePayableAgentFee");
        TypedField<String> PO_STATUS = new TypedField<>(String.class, "poStatus");
        TypedField<String> TOTAL_AGENT_FEE_G_R_AMOUNT = new TypedField<>(String.class, "totalAgentFeeGRAmount");
        TypedField<String> TOTAL_VERIFIED_AGENT_FEE_INVOICE_AMOUNT_I_R = new TypedField<>(String.class, "totalVerifiedAgentFeeInvoiceAmountIR");
        TypedField<String> AGENT_FEE_LAST_INVOICE_DATE = new TypedField<>(String.class, "agentFeeLastInvoiceDate");
        TypedField<String> AGENT_FEE_INVOICE_GR_CHECK = new TypedField<>(String.class, "agentFeeInvoiceGrCheck");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> LIGHT = new TypedField<>(String.class, "light");
        TypedField<String> AGENT_FEE_PO_AMOUNT_WITH_TAX = new TypedField<>(String.class, "agentFeePoAmountWithTax");
        TypedField<String> AGENT_FEE_TOTAL_G_R_AMOUNT_WITH_TAX = new TypedField<>(String.class, "agentFeeTotalGRAmountWithTax");
        TypedField<String> TOTAL_ACCUMULATIVE_PAYABLE_AGENT_FEE_WITH_TAX = new TypedField<>(String.class, "totalAccumulativePayableAgentFeeWithTax");
        TypedField<String> TOTAL_VERIFIED_INVOICE_AMOUNT_IR_WITH_TAX = new TypedField<>(String.class, "totalVerifiedInvoiceAmountIrWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface AgentPaymentTerm {
        static Long id() {
            return 1519879328397336578L;
        }
        static String code() {
            return "agentPaymentTerm";
        }
        TypedField<String> PROJECT_ID = new TypedField<>(String.class, "projectId");
        TypedField<String> AGENT_ID = new TypedField<>(String.class, "agentId");
        TypedField<String> CONTRACT_PAYMENT_TERM_KEY = new TypedField<>(String.class, "contractPaymentTermKey");
        TypedField<String> CONTRACT_PAYMENT_TERM = new TypedField<>(String.class, "contractPaymentTerm");
        TypedField<String> PAYMENT_TERM = new TypedField<>(String.class, "paymentTerm");
        TypedField<String> PAYMENT_TERM_DES_LOCAL = new TypedField<>(String.class, "paymentTermDesLocal");
        TypedField<String> PAYMENT_TERM_DES_EN = new TypedField<>(String.class, "paymentTermDesEn");
        TypedField<String> VALUE = new TypedField<>(String.class, "value");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
    }
    public interface AgentFeeReportInit {
        static Long id() {
            return 1522824285693222913L;
        }
        static String code() {
            return "agentFeeReportInit";
        }
        TypedField<String> LO_B = new TypedField<>(String.class, "loB");
        TypedField<String> SALES_REGION = new TypedField<>(String.class, "salesRegion");
        TypedField<String> EXECUTION_REGION = new TypedField<>(String.class, "executionRegion");
        TypedField<String> PROJECT_NAME_ZH = new TypedField<>(String.class, "projectNameZh");
        TypedField<String> PROJECT_NAME_EN = new TypedField<>(String.class, "projectNameEn");
        TypedField<String> SALES_CHANNEL = new TypedField<>(String.class, "salesChannel");
        TypedField<String> SALES_BRANCH_EN = new TypedField<>(String.class, "salesBranchEn");
        TypedField<String> EXECUTION_BRANCH_EN = new TypedField<>(String.class, "executionBranchEn");
        TypedField<String> IF_CROSS_BRANCH_PROJECT = new TypedField<>(String.class, "ifCrossBranchProject");
        TypedField<String> FIRST_O_I_DATE = new TypedField<>(String.class, "firstOIDate");
        TypedField<String> SALES_BRANCH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "salesBranchVIEWProjectId");
        TypedField<String> EXECUTION_BRANCH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "executionBranchVIEWProjectId");
        TypedField<String> DAPROH_PROJECT_ID = new TypedField<>(String.class, "daprohProjectId");
        TypedField<String> DAPROH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "daprohVIEWProjectId");
        TypedField<String> PROJECT_STATUS = new TypedField<>(String.class, "projectStatus");
        TypedField<String> AGENT_SUPPLIER_NAME = new TypedField<>(String.class, "agentSupplierName");
        TypedField<String> AGENT_SUPPLIER_G_M_D_S_NO = new TypedField<>(String.class, "agentSupplierGMDSNo");
        TypedField<String> PROJECT_EQUIPMENT_CONTRACT_VALUE = new TypedField<>(String.class, "projectEquipmentContractValue");
        TypedField<String> TOTAL_PROJECT_COLLECTED_MONEY = new TypedField<>(String.class, "totalProjectCollectedMoney");
        TypedField<String> COLLECTION_PERCENT = new TypedField<>(String.class, "collectionPercent");
        TypedField<String> CONTRACT_AMOUNT_VO = new TypedField<>(String.class, "contractAmountVo");
        TypedField<String> COLLECTION_AMOUNT_VO = new TypedField<>(String.class, "collectionAmountVo");
        TypedField<String> COLLECTION_PERCENT_VO = new TypedField<>(String.class, "collectionPercentVo");
        TypedField<String> AGENT_FEE_PO_NUMBER = new TypedField<>(String.class, "agentFeePoNumber");
        TypedField<String> TOTAL_AGENT_FEE_PO_AMOUNT = new TypedField<>(String.class, "totalAgentFeePoAmount");
        TypedField<String> TOTAL_ACCUMULATIVE_PAYABLE_AGENT_FEE = new TypedField<>(String.class, "totalAccumulativePayableAgentFee");
        TypedField<String> PO_STATUS = new TypedField<>(String.class, "poStatus");
        TypedField<String> TOTAL_AGENT_FEE_G_R_AMOUNT = new TypedField<>(String.class, "totalAgentFeeGRAmount");
        TypedField<String> TOTAL_VERIFIED_AGENT_FEE_INVOICE_AMOUNT_I_R = new TypedField<>(String.class, "totalVerifiedAgentFeeInvoiceAmountIR");
        TypedField<String> AGENT_FEE_LAST_INVOICE_DATE = new TypedField<>(String.class, "agentFeeLastInvoiceDate");
        TypedField<String> AGENT_FEE_INVOICE_GR_CHECK = new TypedField<>(String.class, "agentFeeInvoiceGrCheck");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> LIGHT = new TypedField<>(String.class, "light");
        TypedField<String> AGENT_FEE_PO_AMOUNT_WITH_TAX = new TypedField<>(String.class, "agentFeePoAmountWithTax");
        TypedField<String> AGENT_FEE_TOTAL_G_R_AMOUNT_WITH_TAX = new TypedField<>(String.class, "agentFeeTotalGRAmountWithTax");
        TypedField<String> TOTAL_ACCUMULATIVE_PAYABLE_AGENT_FEE_WITH_TAX = new TypedField<>(String.class, "totalAccumulativePayableAgentFeeWithTax");
        TypedField<String> TOTAL_VERIFIED_INVOICE_AMOUNT_IR_WITH_TAX = new TypedField<>(String.class, "totalVerifiedInvoiceAmountIrWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<String> ASYNC_STATUS = new TypedField<>(String.class, "asyncStatus");
    }
    public interface AgentPaymentTermInit {
        static Long id() {
            return 1522824510931542018L;
        }
        static String code() {
            return "agentPaymentTermInit";
        }
        TypedField<String> PROJECT_ID = new TypedField<>(String.class, "projectId");
        TypedField<String> AGENT_ID = new TypedField<>(String.class, "agentId");
        TypedField<String> CONTRACT_PAYMENT_TERM_KEY = new TypedField<>(String.class, "contractPaymentTermKey");
        TypedField<String> CONTRACT_PAYMENT_TERM = new TypedField<>(String.class, "contractPaymentTerm");
        TypedField<String> PAYMENT_TERM = new TypedField<>(String.class, "paymentTerm");
        TypedField<String> PAYMENT_TERM_DES_LOCAL = new TypedField<>(String.class, "paymentTermDesLocal");
        TypedField<String> PAYMENT_TERM_DES_EN = new TypedField<>(String.class, "paymentTermDesEn");
        TypedField<String> VALUE = new TypedField<>(String.class, "value");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<String> ASYNC_STATUS = new TypedField<>(String.class, "asyncStatus");
        TypedField<String> CHECK_FIELD = new TypedField<>(String.class, "checkField");
    }
    public interface PurchaseInitFailedHistory {
        static Long id() {
            return 1525448730214404097L;
        }
        static String code() {
            return "purchaseInitFailedHistory";
        }
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> POST_STATUS_RAW = new TypedField<>(String.class, "postStatusRaw");
        TypedField<String> GENERAL_LEDGER_ACCOUNT = new TypedField<>(String.class, "generalLedgerAccount");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "payedAmount");
        TypedField<BigDecimal> INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "invoicedAmount");
        TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "waitForInvoiceAmount");
        TypedField<BigDecimal> DELIVERIED_AMOUNT = new TypedField<>(BigDecimal.class, "deliveriedAmount");
        TypedField<BigDecimal> PREPAY_AMOUNT = new TypedField<>(BigDecimal.class, "prepayAmount");
        TypedField<BigDecimal> UNPAYED_AMOUNT = new TypedField<>(BigDecimal.class, "unpayedAmount");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "failureReason");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "prepaidAmount");
        TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "buyerInvoiceID");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> IS_COORD = new TypedField<>(String.class, "isCoord");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<String> AMOUNT_WITH_TAX_RAW = new TypedField<>(String.class, "amountWithTaxRaw");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "contractID");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> VAT_CODE = new TypedField<>(String.class, "vatCode");
        TypedField<String> MATERIAL_SERVICES_TEAM = new TypedField<>(String.class, "materialServicesTeam");
        TypedField<String> PROFITS_CENTER = new TypedField<>(String.class, "profitsCenter");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<Long> ITEM = new TypedField<>(Long.class, "item");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "isDelete");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> POST_STATUS = new TypedField<>(String.class, "postStatus");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> SELLER = new TypedField<>(String.class, "seller");
        TypedField<String> IS_DELETE_RAW = new TypedField<>(String.class, "isDeleteRaw");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "sellerTelephone");
        TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseBankNo");
        TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseBankName");
        TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseAddress");
        TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseTelephone");
        TypedField<String> WBS_SUB = new TypedField<>(String.class, "wbsSub");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> FACTORY = new TypedField<>(String.class, "factory");
    }
    public interface AgentFeeReportInitFailedHistory {
        static Long id() {
            return 1526407382572208130L;
        }
        static String code() {
            return "agentFeeReportInitFailedHistory";
        }
        TypedField<String> LO_B = new TypedField<>(String.class, "loB");
        TypedField<String> SALES_REGION = new TypedField<>(String.class, "salesRegion");
        TypedField<String> EXECUTION_REGION = new TypedField<>(String.class, "executionRegion");
        TypedField<String> PROJECT_NAME_ZH = new TypedField<>(String.class, "projectNameZh");
        TypedField<String> PROJECT_NAME_EN = new TypedField<>(String.class, "projectNameEn");
        TypedField<String> SALES_CHANNEL = new TypedField<>(String.class, "salesChannel");
        TypedField<String> SALES_BRANCH_EN = new TypedField<>(String.class, "salesBranchEn");
        TypedField<String> EXECUTION_BRANCH_EN = new TypedField<>(String.class, "executionBranchEn");
        TypedField<String> IF_CROSS_BRANCH_PROJECT = new TypedField<>(String.class, "ifCrossBranchProject");
        TypedField<String> FIRST_O_I_DATE = new TypedField<>(String.class, "firstOIDate");
        TypedField<String> SALES_BRANCH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "salesBranchVIEWProjectId");
        TypedField<String> EXECUTION_BRANCH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "executionBranchVIEWProjectId");
        TypedField<String> DAPROH_PROJECT_ID = new TypedField<>(String.class, "daprohProjectId");
        TypedField<String> DAPROH_V_I_E_W_PROJECT_ID = new TypedField<>(String.class, "daprohVIEWProjectId");
        TypedField<String> PROJECT_STATUS = new TypedField<>(String.class, "projectStatus");
        TypedField<String> AGENT_SUPPLIER_NAME = new TypedField<>(String.class, "agentSupplierName");
        TypedField<String> AGENT_SUPPLIER_G_M_D_S_NO = new TypedField<>(String.class, "agentSupplierGMDSNo");
        TypedField<String> PROJECT_EQUIPMENT_CONTRACT_VALUE = new TypedField<>(String.class, "projectEquipmentContractValue");
        TypedField<String> TOTAL_PROJECT_COLLECTED_MONEY = new TypedField<>(String.class, "totalProjectCollectedMoney");
        TypedField<String> COLLECTION_PERCENT = new TypedField<>(String.class, "collectionPercent");
        TypedField<String> CONTRACT_AMOUNT_VO = new TypedField<>(String.class, "contractAmountVo");
        TypedField<String> COLLECTION_AMOUNT_VO = new TypedField<>(String.class, "collectionAmountVo");
        TypedField<String> COLLECTION_PERCENT_VO = new TypedField<>(String.class, "collectionPercentVo");
        TypedField<String> AGENT_FEE_PO_NUMBER = new TypedField<>(String.class, "agentFeePoNumber");
        TypedField<String> TOTAL_AGENT_FEE_PO_AMOUNT = new TypedField<>(String.class, "totalAgentFeePoAmount");
        TypedField<String> TOTAL_ACCUMULATIVE_PAYABLE_AGENT_FEE = new TypedField<>(String.class, "totalAccumulativePayableAgentFee");
        TypedField<String> PO_STATUS = new TypedField<>(String.class, "poStatus");
        TypedField<String> TOTAL_AGENT_FEE_G_R_AMOUNT = new TypedField<>(String.class, "totalAgentFeeGRAmount");
        TypedField<String> TOTAL_VERIFIED_AGENT_FEE_INVOICE_AMOUNT_I_R = new TypedField<>(String.class, "totalVerifiedAgentFeeInvoiceAmountIR");
        TypedField<String> AGENT_FEE_LAST_INVOICE_DATE = new TypedField<>(String.class, "agentFeeLastInvoiceDate");
        TypedField<String> AGENT_FEE_INVOICE_GR_CHECK = new TypedField<>(String.class, "agentFeeInvoiceGrCheck");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> LIGHT = new TypedField<>(String.class, "light");
        TypedField<String> AGENT_FEE_PO_AMOUNT_WITH_TAX = new TypedField<>(String.class, "agentFeePoAmountWithTax");
        TypedField<String> AGENT_FEE_TOTAL_G_R_AMOUNT_WITH_TAX = new TypedField<>(String.class, "agentFeeTotalGRAmountWithTax");
        TypedField<String> TOTAL_ACCUMULATIVE_PAYABLE_AGENT_FEE_WITH_TAX = new TypedField<>(String.class, "totalAccumulativePayableAgentFeeWithTax");
        TypedField<String> TOTAL_VERIFIED_INVOICE_AMOUNT_IR_WITH_TAX = new TypedField<>(String.class, "totalVerifiedInvoiceAmountIrWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
    }
    public interface AgentPaymentTermInitFailedHistory {
        static Long id() {
            return 1526407577857884161L;
        }
        static String code() {
            return "agentPaymentTermInitFailedHistory";
        }
        TypedField<String> PROJECT_ID = new TypedField<>(String.class, "projectId");
        TypedField<String> AGENT_ID = new TypedField<>(String.class, "agentId");
        TypedField<String> CONTRACT_PAYMENT_TERM_KEY = new TypedField<>(String.class, "contractPaymentTermKey");
        TypedField<String> CONTRACT_PAYMENT_TERM = new TypedField<>(String.class, "contractPaymentTerm");
        TypedField<String> PAYMENT_TERM = new TypedField<>(String.class, "paymentTerm");
        TypedField<String> PAYMENT_TERM_DES_LOCAL = new TypedField<>(String.class, "paymentTermDesLocal");
        TypedField<String> PAYMENT_TERM_DES_EN = new TypedField<>(String.class, "paymentTermDesEn");
        TypedField<String> VALUE = new TypedField<>(String.class, "value");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_PRIMARY_KEY_ABSENT = new TypedField<>(Boolean.class, "isPrimaryKeyAbsent");
        TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "isRequiredAbsent");
        TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "absentMsg");
    }
    public interface InvoiceOperationLog {
        static Long id() {
            return 1528986133217607681L;
        }
        static String code() {
            return "invoiceOperationLog";
        }
        TypedField<String> OPERATION = new TypedField<>(String.class, "operation");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXPLAIN = new TypedField<>(String.class, "explain");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> BUSINESS_VALUE = new TypedField<>(String.class, "businessValue");
        TypedField<String> ORIGIN_STATUS = new TypedField<>(String.class, "originStatus");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_OPERATION_RELATION_ID = new TypedField<>(Long.class, "invoiceOperationRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_OPERATION_RELATION {
                static String code () {
                    return "invoiceOperationRelation" ;
                }
                TypedField<String> PRE_N_O = new TypedField<>(String.class, "invoiceOperationRelation.preNO");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOperationRelation.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOperationRelation.invoiceNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOperationRelation.invoiceType");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceOperationRelation.invoiceStatus");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOperationRelation.invoiceUrl");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.paperDrawDate");
                TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.sendDate");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.receiptDate");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.submitDate");
                TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.postingDate");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.paymentDate");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOperationRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOperationRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOperationRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOperationRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOperationRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOperationRelation.delete_flag");
                TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "invoiceOperationRelation.expressNumber");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.amountWithoutTax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOperationRelation.sellerNo");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceOperationRelation.buyerID");
                TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.applyPayAmount");
                TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "invoiceOperationRelation.voucherNo");
                TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "invoiceOperationRelation.voucherText");
                TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.payBaseDay");
                TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.actualPayDay");
                TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.authDate");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "invoiceOperationRelation.paymentNo");
                TypedField<String> PO_NO = new TypedField<>(String.class, "invoiceOperationRelation.poNo");
                TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "invoiceOperationRelation.accountStatus");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "invoiceOperationRelation.payStatus");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.paidAmount");
                TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.invoicePayAmount");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOperationRelation.sellerTaxNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOperationRelation.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOperationRelation.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOperationRelation.sellerTel");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "invoiceOperationRelation.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOperationRelation.sellerBankName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOperationRelation.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.purchaserName");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOperationRelation.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOperationRelation.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOperationRelation.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOperationRelation.purchaserBankName");
                TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "invoiceOperationRelation.purchaserBankNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOperationRelation.remark");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.invoicerName");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOperationRelation.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOperationRelation.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOperationRelation.redNotificationNo");
                TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.taxDeclarationPeriod");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.scanTime");
                TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "invoiceOperationRelation.scanDeductionImageUrl");
                TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "invoiceOperationRelation.scanInvoiceImageUrl");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOperationRelation.purchaserNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceOperationRelation.status");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "invoiceOperationRelation.authStatus");
                TypedField<String> TAX_FLAG = new TypedField<>(String.class, "invoiceOperationRelation.taxFlag");
                TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "invoiceOperationRelation.scanStatus");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOperationRelation.source");
                TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "invoiceOperationRelation.invoiceNoticeNos");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOperationRelation.invoiceId");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "invoiceOperationRelation.purchasingTeam");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "invoiceOperationRelation.sendCount");
                TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "invoiceOperationRelation.backCount");
                TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "invoiceOperationRelation.recommendationFlag");
                TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.matchedAmount");
                TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.account_date");
                TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "invoiceOperationRelation.relationCount");
                TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "invoiceOperationRelation.lastSource");
                TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "invoiceOperationRelation.originFile");
                TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "invoiceOperationRelation.originFileUrl");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "invoiceOperationRelation.returnReason");
                TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.availableAmount");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "invoiceOperationRelation.serialNo");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "invoiceOperationRelation.isReplace");
                TypedField<String> REPLACE_SELLER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.replaceSellerName");
                TypedField<String> REPLACE_SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOperationRelation.replaceSellerTaxNo");
                TypedField<String> ORIGIN_SELLER_NAME = new TypedField<>(String.class, "invoiceOperationRelation.originSellerName");
                TypedField<String> ORIGIN_SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOperationRelation.originSellerTaxNo");
                TypedField<BigDecimal> AVAILABLE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.availableAmountWithoutTax");
                TypedField<String> IMAGE_ID = new TypedField<>(String.class, "invoiceOperationRelation.imageId");
                TypedField<String> COORDINATION_TYPE = new TypedField<>(String.class, "invoiceOperationRelation.coordinationType");
                TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOperationRelation.matchedAmountWithoutTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOperationRelation.taxRate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "invoiceOperationRelation.poNumbers");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "invoiceOperationRelation.dataSource");
                TypedField<String> SELLER_GROUP_ID = new TypedField<>(String.class, "invoiceOperationRelation.sellerGroupId");
                TypedField<Boolean> LOCK_FLAG = new TypedField<>(Boolean.class, "invoiceOperationRelation.lockFlag");
                TypedField<String> ARCHIVE_NO = new TypedField<>(String.class, "invoiceOperationRelation.archiveNo");
                TypedField<String> WITHDRAW_TYPE = new TypedField<>(String.class, "invoiceOperationRelation.withdrawType");
                TypedField<String> IRID = new TypedField<>(String.class, "invoiceOperationRelation.irid");
                TypedField<String> IS_REMOVED = new TypedField<>(String.class, "invoiceOperationRelation.isRemoved");
                TypedField<LocalDateTime> MATCH_UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOperationRelation.matchUpdateTime");
            }
        }
    }
    public interface PrepaymentWriteRelation {
        static Long id() {
            return 1532032039881617409L;
        }
        static String code() {
            return "prepaymentWriteRelation";
        }
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> IMP_APPLY_ID = new TypedField<>(String.class, "impApplyId");
        TypedField<BigDecimal> PREPAYMENT_WRITE_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteAmount");
        TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "prepaymentWriteVoucher");
        TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentPaymentVoucher");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<String> XXX = new TypedField<>(String.class, "xxx");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> PREPAYMENT_WRITE_RELATION_ID = new TypedField<>(Long.class, "prepaymentWriteRelation.id");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> PAYMENT_ID = new TypedField<>(Long.class, "payment.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PREPAYMENT_WRITE_RELATION {
                static String code () {
                    return "prepaymentWriteRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "prepaymentWriteRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "prepaymentWriteRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "prepaymentWriteRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "prepaymentWriteRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "prepaymentWriteRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentWriteRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentWriteRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "prepaymentWriteRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "prepaymentWriteRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "prepaymentWriteRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "prepaymentWriteRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "prepaymentWriteRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "prepaymentWriteRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "prepaymentWriteRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "prepaymentWriteRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "prepaymentWriteRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "prepaymentWriteRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "prepaymentWriteRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "prepaymentWriteRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "prepaymentWriteRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "prepaymentWriteRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "prepaymentWriteRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "prepaymentWriteRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "prepaymentWriteRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "prepaymentWriteRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "prepaymentWriteRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "prepaymentWriteRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "prepaymentWriteRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "prepaymentWriteRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "prepaymentWriteRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "prepaymentWriteRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "prepaymentWriteRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "prepaymentWriteRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "prepaymentWriteRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentWriteRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "prepaymentWriteRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "prepaymentWriteRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "prepaymentWriteRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentWriteRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "prepaymentWriteRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "prepaymentWriteRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "prepaymentWriteRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "prepaymentWriteRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "prepaymentWriteRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "prepaymentWriteRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "prepaymentWriteRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "prepaymentWriteRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "prepaymentWriteRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "prepaymentWriteRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "prepaymentWriteRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "prepaymentWriteRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "prepaymentWriteRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "prepaymentWriteRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "prepaymentWriteRelation.salesPersonId");
            }
            interface PAYMENT {
                static String code () {
                    return "payment" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "payment.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "payment.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "payment.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "payment.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "payment.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "payment.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "payment.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "payment.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "payment.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "payment.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "payment.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "payment.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "payment.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "payment.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "payment.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "payment.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "payment.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "payment.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "payment.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "payment.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "payment.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "payment.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "payment.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "payment.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "payment.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "payment.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "payment.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "payment.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "payment.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "payment.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "payment.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "payment.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "payment.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "payment.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "payment.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "payment.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "payment.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "payment.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "payment.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "payment.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "payment.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "payment.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "payment.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "payment.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "payment.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "payment.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "payment.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "payment.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "payment.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "payment.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "payment.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "payment.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "payment.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "payment.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "payment.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "payment.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "payment.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "payment.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "payment.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "payment.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "payment.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "payment.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "payment.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "payment.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "payment.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "payment.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "payment.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "payment.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "payment.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "payment.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "payment.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "payment.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "payment.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "payment.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "payment.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "payment.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "payment.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "payment.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "payment.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "payment.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "payment.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "payment.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "payment.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "payment.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "payment.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "payment.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "payment.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "payment.salesPersonId");
            }
        }
    }
    public interface SettlementOrder {
        static Long id() {
            return 1534112872124350465L;
        }
        static String code() {
            return "settlementOrder";
        }
        TypedField<String> ORDER_N_O = new TypedField<>(String.class, "orderNO");
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        /**
         * 对一关联关系 关联对象 invoiceNoticeBill
         */
        TypedField<Long> INVOICE_NOTICE_BILL_ANDORDER_RELATION_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndorderRelation.id");
        /**
         * 对一关联关系 关联对象 settlement
         */
        TypedField<Long> SETTLEMENT_NOTICE_BILL_RELATION_ID = new TypedField<>(Long.class, "settlementNoticeBillRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_NOTICE_BILL_ANDORDER_RELATION {
                static String code () {
                    return "invoiceNoticeBillAndorderRelation" ;
                }
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.invoiceType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceNoticeBillAndorderRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndorderRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillAndorderRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillAndorderRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndorderRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndorderRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.delete_flag");
                TypedField<String> PRE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.preNo");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "invoiceNoticeBillAndorderRelation.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.priceMethod");
                TypedField<String> WBS = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.wbs");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.node");
                TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.invoiceNoticeNO");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.invoiceCode");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.hippedQuantity");
                TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndorderRelation.matchedAmountWithoutTax");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.projectDefinition");
                TypedField<Long> VALID_SELLEMENT_COUNT = new TypedField<>(Long.class, "invoiceNoticeBillAndorderRelation.validSellementCount");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.pmNode");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.ladderNo");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.dataSource");
                TypedField<String> GENERATE_SETTLE_STATUS = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.generateSettleStatus");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.projectName");
                TypedField<String> IRID = new TypedField<>(String.class, "invoiceNoticeBillAndorderRelation.irid");
            }
            interface SETTLEMENT_NOTICE_BILL_RELATION {
                static String code () {
                    return "settlementNoticeBillRelation" ;
                }
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlementNoticeBillRelation.settlementNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementNoticeBillRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementNoticeBillRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementNoticeBillRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementNoticeBillRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementNoticeBillRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementNoticeBillRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementNoticeBillRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementNoticeBillRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementNoticeBillRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementNoticeBillRelation.delete_flag");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementNoticeBillRelation.amountWithTax");
                TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlementNoticeBillRelation.settlementStatus");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "settlementNoticeBillRelation.amountWithoutTax");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "settlementNoticeBillRelation.sellerTaxNo");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "settlementNoticeBillRelation.dataSource");
                TypedField<String> IRID = new TypedField<>(String.class, "settlementNoticeBillRelation.irid");
            }
        }
    }
    public interface EventRecord {
        static Long id() {
            return 1539437023041085442L;
        }
        static String code() {
            return "eventRecord";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EVENT_TYPE = new TypedField<>(String.class, "eventType");
        TypedField<String> EVENT_OBJECT = new TypedField<>(String.class, "eventObject");
        TypedField<Long> EVENT_OBJECT_ID = new TypedField<>(Long.class, "eventObjectId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> IS_RETRY = new TypedField<>(String.class, "isRetry");
        TypedField<String> TRACE_ID = new TypedField<>(String.class, "traceId");
        TypedField<String> EVENT_OBJECT_FIELD_VALUE = new TypedField<>(String.class, "eventObjectFieldValue");
        TypedField<String> EVENT_OBJECT_FIELD_KEY = new TypedField<>(String.class, "eventObjectFieldKey");
    }
    public interface Settlement {
        static Long id() {
            return 1541228258192707586L;
        }
        static String code() {
            return "settlement";
        }
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlementNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlementStatus");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "dataSource");
        TypedField<String> IRID = new TypedField<>(String.class, "irid");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface CodeGenerator {
        static Long id() {
            return 1544931985123766274L;
        }
        static String code() {
            return "codeGenerator";
        }
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> PREFIX = new TypedField<>(String.class, "prefix");
        TypedField<String> VALUE = new TypedField<>(String.class, "value");
        TypedField<String> SUFFIX = new TypedField<>(String.class, "suffix");
        TypedField<String> VERSION = new TypedField<>(String.class, "version");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1546387394325032961L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1546387395033870338L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        /**
         * 对一关联关系 关联对象 flowInstanceLog
         */
        TypedField<Long> ONETOMANY_ID = new TypedField<>(Long.class, "onetomany.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONETOMANY {
                static String code () {
                    return "onetomany" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "onetomany.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "onetomany.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "onetomany.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "onetomany.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "onetomany.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "onetomany.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "onetomany.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "onetomany.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "onetomany.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "onetomany.delete_flag");
                TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "onetomany.instanceId");
                TypedField<String> FLOW_CODE = new TypedField<>(String.class, "onetomany.flowCode");
                TypedField<String> ERROR_MSG = new TypedField<>(String.class, "onetomany.errorMsg");
                TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "onetomany.exceptionTrace");
                TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "onetomany.errorNodeId");
                TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "onetomany.rollback");
                TypedField<String> SNAPSHOT = new TypedField<>(String.class, "onetomany.snapshot");
                TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "onetomany.snapshotFormat");
                TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "onetomany.rollbackNodeId");
                TypedField<String> FLOW_NAME = new TypedField<>(String.class, "onetomany.flowName");
                TypedField<String> STATUS = new TypedField<>(String.class, "onetomany.status");
                TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "onetomany.startSnapshot");
                TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "onetomany.startSnapshotFormat");
            }
        }
    }
    public interface EmailRecord {
        static Long id() {
            return 1556470271474843650L;
        }
        static String code() {
            return "emailRecord";
        }
        TypedField<String> SUBJECT = new TypedField<>(String.class, "subject");
        TypedField<String> RECEIVER_EMAIL = new TypedField<>(String.class, "receiverEmail");
        TypedField<String> SUCCEED_OR_ERROR = new TypedField<>(String.class, "succeedOrError");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<Long> COUNT = new TypedField<>(Long.class, "count");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EMAIL_SEND_SCENE = new TypedField<>(String.class, "emailSendScene");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<Long> RECEIVER_USER_ID = new TypedField<>(Long.class, "receiverUserId");
    }
    public interface OrderHandleRecord {
        static Long id() {
            return 1557733373289111553L;
        }
        static String code() {
            return "orderHandleRecord";
        }
        TypedField<String> ORDER_TYPE_CODE = new TypedField<>(String.class, "orderTypeCode");
        TypedField<String> ORDER_ID = new TypedField<>(String.class, "orderId");
        TypedField<String> ORDER_CODE = new TypedField<>(String.class, "orderCode");
        TypedField<String> ORIGIN_VALUE = new TypedField<>(String.class, "originValue");
        TypedField<String> CURRENT_VALUE = new TypedField<>(String.class, "currentValue");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface BuyerMapping {
        static Long id() {
            return 1570591743094022146L;
        }
        static String code() {
            return "buyerMapping";
        }
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> FACTORY = new TypedField<>(String.class, "factory");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
    }
    public interface PaymentPowerBiInit {
        static Long id() {
            return 1594880202276605954L;
        }
        static String code() {
            return "paymentPowerBiInit";
        }
        TypedField<String> PROJECT_ID = new TypedField<>(String.class, "projectId");
        TypedField<String> AGENT_ID = new TypedField<>(String.class, "agentId");
        TypedField<String> CONTRACT_PAYMENT_TERM = new TypedField<>(String.class, "contractPaymentTerm");
        TypedField<String> PAYMENT_TERM = new TypedField<>(String.class, "paymentTerm");
        TypedField<String> PAYMENT_TERM_DES_LOCAL = new TypedField<>(String.class, "paymentTermDesLocal");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> PAYMENT_ID = new TypedField<>(Long.class, "paymentId");
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<Long> AGENT_PAYMENT_TERM_ID = new TypedField<>(Long.class, "agentPaymentTermId");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> PAYMENT_AND_POWER_BI_RELATION_ID = new TypedField<>(Long.class, "paymentAndPowerBiRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PAYMENT_AND_POWER_BI_RELATION {
                static String code () {
                    return "paymentAndPowerBiRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "paymentAndPowerBiRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "paymentAndPowerBiRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "paymentAndPowerBiRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "paymentAndPowerBiRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "paymentAndPowerBiRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "paymentAndPowerBiRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "paymentAndPowerBiRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "paymentAndPowerBiRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "paymentAndPowerBiRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "paymentAndPowerBiRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "paymentAndPowerBiRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "paymentAndPowerBiRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "paymentAndPowerBiRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "paymentAndPowerBiRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "paymentAndPowerBiRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "paymentAndPowerBiRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "paymentAndPowerBiRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "paymentAndPowerBiRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "paymentAndPowerBiRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "paymentAndPowerBiRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "paymentAndPowerBiRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "paymentAndPowerBiRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "paymentAndPowerBiRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "paymentAndPowerBiRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "paymentAndPowerBiRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "paymentAndPowerBiRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "paymentAndPowerBiRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "paymentAndPowerBiRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "paymentAndPowerBiRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndPowerBiRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "paymentAndPowerBiRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "paymentAndPowerBiRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "paymentAndPowerBiRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndPowerBiRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "paymentAndPowerBiRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "paymentAndPowerBiRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndPowerBiRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "paymentAndPowerBiRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "paymentAndPowerBiRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "paymentAndPowerBiRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "paymentAndPowerBiRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "paymentAndPowerBiRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "paymentAndPowerBiRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "paymentAndPowerBiRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "paymentAndPowerBiRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "paymentAndPowerBiRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "paymentAndPowerBiRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "paymentAndPowerBiRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "paymentAndPowerBiRelation.salesPersonId");
            }
        }
    }
    public interface Producer {
        static Long id() {
            return 1600765861355909121L;
        }
        static String code() {
            return "producer";
        }
        TypedField<String> PRODUCE_OBJ = new TypedField<>(String.class, "produceObj");
        TypedField<String> PRODUCE_STATUS = new TypedField<>(String.class, "produceStatus");
        TypedField<String> PRODUCE_TYPE = new TypedField<>(String.class, "produceType");
        TypedField<String> PRODUCE_SOURCE = new TypedField<>(String.class, "produceSource");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCE_MESSAGE = new TypedField<>(String.class, "produceMessage");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "businessKey");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface Customer {
        static Long id() {
            return 1600765861968277506L;
        }
        static String code() {
            return "customer";
        }
        TypedField<String> CUSTOMER_MESSAGE = new TypedField<>(String.class, "customerMessage");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCE_OBJ = new TypedField<>(String.class, "produceObj");
        TypedField<String> PRODUCE_TYPE = new TypedField<>(String.class, "produceType");
        TypedField<String> PRODUCE_SOURCE = new TypedField<>(String.class, "produceSource");
        TypedField<String> CUSTOMER_OBJ = new TypedField<>(String.class, "customerObj");
        TypedField<String> CUSTOMER_STATUS = new TypedField<>(String.class, "customerStatus");
        TypedField<String> CUSTOMER_TYPE = new TypedField<>(String.class, "customerType");
        TypedField<String> CUSTOMER_SOURCE = new TypedField<>(String.class, "customerSource");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "businessKey");
        TypedField<String> MESSAGE = new TypedField<>(String.class, "message");
        /**
         * 对一关联关系 关联对象 producer
         */
        TypedField<Long> PRODUCER_TO_MANY_CONSUMER_ID = new TypedField<>(Long.class, "producerToManyConsumer.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PRODUCER_TO_MANY_CONSUMER {
                static String code () {
                    return "producerToManyConsumer" ;
                }
                TypedField<String> PRODUCE_OBJ = new TypedField<>(String.class, "producerToManyConsumer.produceObj");
                TypedField<String> PRODUCE_STATUS = new TypedField<>(String.class, "producerToManyConsumer.produceStatus");
                TypedField<String> PRODUCE_TYPE = new TypedField<>(String.class, "producerToManyConsumer.produceType");
                TypedField<String> PRODUCE_SOURCE = new TypedField<>(String.class, "producerToManyConsumer.produceSource");
                TypedField<Long> ID = new TypedField<>(Long.class, "producerToManyConsumer.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "producerToManyConsumer.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "producerToManyConsumer.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "producerToManyConsumer.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "producerToManyConsumer.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "producerToManyConsumer.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "producerToManyConsumer.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "producerToManyConsumer.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "producerToManyConsumer.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "producerToManyConsumer.delete_flag");
                TypedField<String> PRODUCE_MESSAGE = new TypedField<>(String.class, "producerToManyConsumer.produceMessage");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "producerToManyConsumer.serialNo");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "producerToManyConsumer.businessKey");
            }
        }
    }
    public interface DispatcherRuleConfig {
        static Long id() {
            return 1600765862400290818L;
        }
        static String code() {
            return "dispatcherRuleConfig";
        }
        TypedField<String> PRODUCE_OBJ = new TypedField<>(String.class, "produceObj");
        TypedField<String> PRODUCE_TYPE = new TypedField<>(String.class, "produceType");
        TypedField<String> PRODUCE_SOURCE = new TypedField<>(String.class, "produceSource");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> IS_OPEN = new TypedField<>(Boolean.class, "isOpen");
        TypedField<String> CONSUMER_OBJ = new TypedField<>(String.class, "consumerObj");
        TypedField<String> CONSUMER_TYPE = new TypedField<>(String.class, "consumerType");
        TypedField<String> CONSUMER_SOURCE = new TypedField<>(String.class, "consumerSource");
    }
    public interface NoticeBillHandleRecord {
        static Long id() {
            return 1606926445262262274L;
        }
        static String code() {
            return "noticeBillHandleRecord";
        }
        TypedField<String> INVOICE_NOTICE_NO = new TypedField<>(String.class, "invoiceNoticeNo");
        TypedField<String> HANDLE_PERSON = new TypedField<>(String.class, "handlePerson");
        TypedField<String> HANDLE_TYPE = new TypedField<>(String.class, "handleType");
        TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "handleRemark");
        TypedField<String> ORIGIN_STATUS = new TypedField<>(String.class, "originStatus");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 invoiceNoticeBill
         */
        TypedField<Long> INVOICE_NOTICE_BILL_RECORD_ID = new TypedField<>(Long.class, "invoiceNoticeBillRecord.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_NOTICE_BILL_RECORD {
                static String code () {
                    return "invoiceNoticeBillRecord" ;
                }
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceNoticeBillRecord.invoiceType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "invoiceNoticeBillRecord.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceNoticeBillRecord.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceNoticeBillRecord.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceNoticeBillRecord.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceNoticeBillRecord.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillRecord.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillRecord.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillRecord.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillRecord.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceNoticeBillRecord.delete_flag");
                TypedField<String> PRE_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.preNo");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "invoiceNoticeBillRecord.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceNoticeBillRecord.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "invoiceNoticeBillRecord.priceMethod");
                TypedField<String> WBS = new TypedField<>(String.class, "invoiceNoticeBillRecord.wbs");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "invoiceNoticeBillRecord.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "invoiceNoticeBillRecord.node");
                TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeBillRecord.invoiceNoticeNO");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceNoticeBillRecord.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "invoiceNoticeBillRecord.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "invoiceNoticeBillRecord.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "invoiceNoticeBillRecord.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceNoticeBillRecord.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceNoticeBillRecord.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceNoticeBillRecord.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillRecord.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "invoiceNoticeBillRecord.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillRecord.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "invoiceNoticeBillRecord.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceNoticeBillRecord.invoiceCode");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "invoiceNoticeBillRecord.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "invoiceNoticeBillRecord.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "invoiceNoticeBillRecord.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.hippedQuantity");
                TypedField<BigDecimal> MATCHED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillRecord.matchedAmountWithoutTax");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "invoiceNoticeBillRecord.projectDefinition");
                TypedField<Long> VALID_SELLEMENT_COUNT = new TypedField<>(Long.class, "invoiceNoticeBillRecord.validSellementCount");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "invoiceNoticeBillRecord.pmNode");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "invoiceNoticeBillRecord.ladderNo");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "invoiceNoticeBillRecord.dataSource");
                TypedField<String> GENERATE_SETTLE_STATUS = new TypedField<>(String.class, "invoiceNoticeBillRecord.generateSettleStatus");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "invoiceNoticeBillRecord.projectName");
                TypedField<String> IRID = new TypedField<>(String.class, "invoiceNoticeBillRecord.irid");
            }
        }
    }
    public interface AutoGoodsRecode {
        static Long id() {
            return 1615171416332238850L;
        }
        static String code() {
            return "autoGoodsRecode";
        }
        TypedField<String> TASK_ID = new TypedField<>(String.class, "taskId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "autoGoodsType");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "approvalBody");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "autoBatchNo");
        /**
         * 对一关联关系 关联对象 paymentManage
         */
        TypedField<Long> PAYMENT_AND_AUTO_GOODS_RELATION_ID = new TypedField<>(Long.class, "paymentAndAutoGoodsRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PAYMENT_AND_AUTO_GOODS_RELATION {
                static String code () {
                    return "paymentAndAutoGoodsRelation" ;
                }
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.applyId");
                TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.applyUserName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.businessType");
                TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.prepaymentType");
                TypedField<String> BOND_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.bondType");
                TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentObjectId");
                TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentObject");
                TypedField<BigDecimal> APPLY_PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.applyPaymentAmount");
                TypedField<BigDecimal> APPLY_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.applyPaidAmount");
                TypedField<BigDecimal> ORDER_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.orderAmount");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.invoiceAmount");
                TypedField<BigDecimal> COLLECTION_ACCUMULATION = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.collectionAccumulation");
                TypedField<BigDecimal> PAYMENT_ACCUMULATION = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.paymentAccumulation");
                TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.prepaymentRequestNo");
                TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.prepaymentWriteVoucher");
                TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentVoucher");
                TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentPaymentVoucher");
                TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentClearingVoucher");
                TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.currentStatus");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.errorInfo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.profitCenter");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.costCenter");
                TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentUserType");
                TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.paymentDueDate");
                TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentBankType");
                TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.collectionBank");
                TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.collectionAccount");
                TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.collectionName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.contractNo");
                TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.contractName");
                TypedField<BigDecimal> CONTRACT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.contractAmount");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.contractType");
                TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.startDate");
                TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.endDate");
                TypedField<String> TEXT = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.text");
                TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.paymentRemark");
                TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.approvalHistory");
                TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.downloadUserName");
                TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.downloadStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "paymentAndAutoGoodsRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "paymentAndAutoGoodsRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "paymentAndAutoGoodsRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "paymentAndAutoGoodsRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.delete_flag");
                TypedField<LocalDateTime> CONTRACT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.contractSignDate");
                TypedField<String> INVOICE_NOTICE_N_OS = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.invoiceNoticeNOs");
                TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.approvalRole");
                TypedField<String> COMPANY_ID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.companyId");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.companyName");
                TypedField<String> PURCHASER_ID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.purchaserId");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.purchaserName");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.approvalBody");
                TypedField<String> AGENT_PAYMENT_TERM = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.agentPaymentTerm");
                TypedField<String> PETTY_CASH_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.pettyCashType");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.purchasingOrg");
                TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.procurementGroup");
                TypedField<Boolean> FREEZE_PAYMENT = new TypedField<>(Boolean.class, "paymentAndAutoGoodsRelation.freezePayment");
                TypedField<String> COMMERCIAL_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.commercialPaymentVoucher");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_APPLY_ID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.previousApplyId");
                TypedField<String> NEXT_APPLY_ID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.nextApplyId");
                TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.prepaymentPaymentVoucher");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.paymentDate");
                TypedField<BigDecimal> PREPAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.prepaymentAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.payedAmount");
                TypedField<BigDecimal> MARGIN_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.marginAmount");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.projectName");
                TypedField<String> INITIATE_ROLE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.initiateRole");
                TypedField<String> PO_NOS = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.poNos");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAndAutoGoodsRelation.prepaidAmount");
                TypedField<String> PO_NO = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.poNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.sellerTaxNo");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.submitDate");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "paymentAndAutoGoodsRelation.accountingDate");
                TypedField<String> PO_NUMBERS = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.poNumbers");
                TypedField<String> COLLECTION_BANK_CODE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.collectionBankCode");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.orderType");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.dataSource");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.autoBatchNo");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.autoGoodsType");
                TypedField<String> OVER_PAY_TYPE = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.overPayType");
                TypedField<String> IRID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.irid");
                TypedField<String> ORIGIN_TEXT = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.originText");
                TypedField<String> SALES_PERSON_NAME = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.salesPersonName");
                TypedField<String> SALES_PERSON_ID = new TypedField<>(String.class, "paymentAndAutoGoodsRelation.salesPersonId");
            }
        }
    }
    public interface AutoGoodsRecodeItem {
        static Long id() {
            return 1615174516867121153L;
        }
        static String code() {
            return "autoGoodsRecodeItem";
        }
        TypedField<String> GR_NO = new TypedField<>(String.class, "grNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> GR_ITEM_NO = new TypedField<>(String.class, "grItemNo");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> PO_ITEM_NO = new TypedField<>(String.class, "poItemNo");
        TypedField<String> INVOICE_NOTICE_NO = new TypedField<>(String.class, "invoiceNoticeNo");
        TypedField<String> INVOICE_NOTICE_ITEM_NO = new TypedField<>(String.class, "invoiceNoticeItemNo");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> MESSAGE_TYPE = new TypedField<>(String.class, "messageType");
        TypedField<String> MESSAGE_TEXT = new TypedField<>(String.class, "messageText");
        TypedField<String> BALANCE_QTY = new TypedField<>(String.class, "balanceQty");
        TypedField<String> BALANCE_AMT = new TypedField<>(String.class, "balanceAmt");
        /**
         * 对一关联关系 关联对象 goodsReceiptItem
         */
        TypedField<Long> GOODS_RECEIPT_ITEM_AND_RECOD_RELATION_ID = new TypedField<>(Long.class, "goodsReceiptItemAndRecodRelation.id");
        /**
         * 对一关联关系 关联对象 autoGoodsRecode
         */
        TypedField<Long> DETAIL_RELATION_ID = new TypedField<>(Long.class, "detailRelation.id");
        /**
         * 对一关联关系 关联对象 invoiceNoticeBillItem
         */
        TypedField<Long> INVOICE_NOTICE_BILL_ITEM_AND_AUTO_GOODS_ITEM_RELATION_ID = new TypedField<>(Long.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface GOODS_RECEIPT_ITEM_AND_RECOD_RELATION {
                static String code () {
                    return "goodsReceiptItemAndRecodRelation" ;
                }
                TypedField<String> PO_N_O = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.poNO");
                TypedField<String> PO_LINE_ITEM_N_O = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.poLineItemNO");
                TypedField<Long> ID = new TypedField<>(Long.class, "goodsReceiptItemAndRecodRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "goodsReceiptItemAndRecodRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "goodsReceiptItemAndRecodRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "goodsReceiptItemAndRecodRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "goodsReceiptItemAndRecodRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "goodsReceiptItemAndRecodRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.delete_flag");
                TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.materialServices");
                TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.materialServicesName");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "goodsReceiptItemAndRecodRelation.quantity");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "goodsReceiptItemAndRecodRelation.amount");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.absentMsg");
                TypedField<Boolean> IS_REQUIRED_ABSENT = new TypedField<>(Boolean.class, "goodsReceiptItemAndRecodRelation.isRequiredAbsent");
                TypedField<BigDecimal> AMOUNT_AGGREGATION = new TypedField<>(BigDecimal.class, "goodsReceiptItemAndRecodRelation.amountAggregation");
                TypedField<String> GR_NO = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.grNo");
                TypedField<BigDecimal> QUANTITY_AGGREGATION = new TypedField<>(BigDecimal.class, "goodsReceiptItemAndRecodRelation.quantityAggregation");
                TypedField<String> GR_ITEM_NO = new TypedField<>(String.class, "goodsReceiptItemAndRecodRelation.grItemNo");
            }
            interface DETAIL_RELATION {
                static String code () {
                    return "detailRelation" ;
                }
                TypedField<String> TASK_ID = new TypedField<>(String.class, "detailRelation.taskId");
                TypedField<Long> ID = new TypedField<>(Long.class, "detailRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "detailRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "detailRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "detailRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "detailRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "detailRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "detailRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "detailRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "detailRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "detailRelation.delete_flag");
                TypedField<String> AUTO_GOODS_TYPE = new TypedField<>(String.class, "detailRelation.autoGoodsType");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "detailRelation.quantity");
                TypedField<String> APPLY_ID = new TypedField<>(String.class, "detailRelation.applyId");
                TypedField<String> STATUS = new TypedField<>(String.class, "detailRelation.status");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "detailRelation.errorInfo");
                TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "detailRelation.approvalBody");
                TypedField<String> PO_NO = new TypedField<>(String.class, "detailRelation.poNo");
                TypedField<String> AUTO_BATCH_NO = new TypedField<>(String.class, "detailRelation.autoBatchNo");
            }
            interface INVOICE_NOTICE_BILL_ITEM_AND_AUTO_GOODS_ITEM_RELATION {
                static String code () {
                    return "invoiceNoticeBillItemAndAutoGoodsItemRelation" ;
                }
                TypedField<String> ITEM_N_O = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.itemNO");
                TypedField<String> ITEM_NAME = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.itemName");
                TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.itemSpec");
                TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.quantityUnit");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.quantity");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.goodsTaxNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.delete_flag");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.invoiceType");
                TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.invoiceNoticeNO");
                TypedField<String> BILL_N_O = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.billNO");
                TypedField<String> COST_CENTER = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.costCenter");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.profitCenter");
                TypedField<String> WBS = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.wbs");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.contractNo");
                TypedField<String> VIEW_ID = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.viewId");
                TypedField<String> LADDER_STATUS = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.ladderStatus");
                TypedField<String> PRE_NO = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.preNo");
                TypedField<String> PRE_ITEM_NO = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.preItemNo");
                TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.materialServices");
                TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.materialServicesName");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.taxRate");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.taxAmount");
                TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.totalPayQty");
                TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.totalPayAmount");
                TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.businessStatus");
                TypedField<String> BUSINESS_STATUS_EXPR = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.businessStatusExpr");
                TypedField<BigDecimal> AMOUNT_WITH_TAX_RAW = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.amountWithTaxRaw");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.unitPrice");
                TypedField<String> EDIT_STATUS = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.editStatus");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX_RAW = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.amountWithoutTaxRaw");
                TypedField<BigDecimal> ALL_PAY_QTY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.allPayQty");
                TypedField<BigDecimal> ALL_PAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.allPayAmountWithTax");
                TypedField<BigDecimal> ALL_PAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.allPayAmountWithoutTax");
                TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.contractID");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.pmNode");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "invoiceNoticeBillItemAndAutoGoodsItemRelation.projectDefinition");
            }
        }
    }
    public interface DeleteRecord {
        static Long id() {
            return 1625063411984470017L;
        }
        static String code() {
            return "deleteRecord";
        }
        TypedField<String> ENTITY_CODE = new TypedField<>(String.class, "entityCode");
        TypedField<String> ENTITY_DATA_ID = new TypedField<>(String.class, "entityDataId");
        TypedField<String> OPERATOR = new TypedField<>(String.class, "operator");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ENTITY_DATA = new TypedField<>(String.class, "entityData");
    }
    public interface ApprovalTemplate {
        static Long id() {
            return 1650329756644773889L;
        }
        static String code() {
            return "approvalTemplate";
        }
        TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "prepaymentType");
        TypedField<String> BOND_TYPE = new TypedField<>(String.class, "bondType");
        TypedField<Long> ROLE_SERIAL_NUMBER = new TypedField<>(Long.class, "roleSerialNumber");
        TypedField<String> ROLE_TYPE = new TypedField<>(String.class, "roleType");
        TypedField<String> ROLE_ENGLISH_DESCRIPTION = new TypedField<>(String.class, "roleEnglishDescription");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> VALIDITY_PERIOD_LOWER_LIMIT = new TypedField<>(BigDecimal.class, "validityPeriodLowerLimit");
        TypedField<Boolean> IS_INCLUDE_VALIDITY_PERIOD_LOWER_LIMIT = new TypedField<>(Boolean.class, "isIncludeValidityPeriodLowerLimit");
        TypedField<BigDecimal> VALIDITY_PERIOD_UPPER_LIMIT = new TypedField<>(BigDecimal.class, "validityPeriodUpperLimit");
        TypedField<Boolean> IS_INCLUDE_VALIDITY_PERIOD_UPPER_LIMIT = new TypedField<>(Boolean.class, "isIncludeValidityPeriodUpperLimit");
        TypedField<BigDecimal> AMOUNT_RATIO_LOWER_LIMIT = new TypedField<>(BigDecimal.class, "amountRatioLowerLimit");
        TypedField<Boolean> IS_INCLUDE_AMOUNT_RATIO_LOWER_LIMIT = new TypedField<>(Boolean.class, "isIncludeAmountRatioLowerLimit");
        TypedField<BigDecimal> AMOUNT_RATIO_UPPER_LIMIT = new TypedField<>(BigDecimal.class, "amountRatioUpperLimit");
        TypedField<Boolean> IS_INCLUDE_AMOUNT_RATIO_UPPER_LIMIT = new TypedField<>(Boolean.class, "isIncludeAmountRatioUpperLimit");
        TypedField<BigDecimal> AMOUNT_LOWER_LIMIT = new TypedField<>(BigDecimal.class, "amountLowerLimit");
        TypedField<Boolean> IS_INCLUDE_AMOUNT_LOWER_LIMIT = new TypedField<>(Boolean.class, "isIncludeAmountLowerLimit");
        TypedField<BigDecimal> AMOUNT_UPPER_LIMIT = new TypedField<>(BigDecimal.class, "amountUpperLimit");
        TypedField<Boolean> IS_INCLUDE_AMOUNT_UPPER_LIMIT = new TypedField<>(Boolean.class, "isIncludeAmountUpperLimit");
    }
    public interface DataMirgrationRecord {
        static Long id() {
            return 1660816252248567809L;
        }
        static String code() {
            return "dataMirgrationRecord";
        }
        TypedField<String> IRID = new TypedField<>(String.class, "irid");
        TypedField<String> PURCHASE_ORDER_NOS = new TypedField<>(String.class, "purchaseOrderNos");
        TypedField<String> SALES_ORDER_NOS = new TypedField<>(String.class, "salesOrderNos");
        TypedField<String> SETTLEMENT_NOS = new TypedField<>(String.class, "settlementNos");
        TypedField<String> INVOICE_NOS = new TypedField<>(String.class, "invoiceNos");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> REMOVED = new TypedField<>(String.class, "removed");
    }
    public interface PurchaseOrderOperationLog {
        static Long id() {
            return 1663373839877378049L;
        }
        static String code() {
            return "purchaseOrderOperationLog";
        }
        TypedField<String> OPERATION = new TypedField<>(String.class, "operation");
        TypedField<String> EXPLAIN = new TypedField<>(String.class, "explain");
        TypedField<String> ORIGIN_STATUS = new TypedField<>(String.class, "originStatus");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> HANDLE_PERSON = new TypedField<>(String.class, "handlePerson");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        /**
         * 对一关联关系 关联对象 purchaseOrder
         */
        TypedField<Long> PURCHASE_ORDER_OPERATION_LOG_ID = new TypedField<>(Long.class, "purchaseOrderOperationLog.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PURCHASE_ORDER_OPERATION_LOG {
                static String code () {
                    return "purchaseOrderOperationLog" ;
                }
                TypedField<String> PO_NUMBER = new TypedField<>(String.class, "purchaseOrderOperationLog.poNumber");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.buyerName");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "purchaseOrderOperationLog.businessType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "purchaseOrderOperationLog.orderType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "purchaseOrderOperationLog.buyerID");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderOperationLog.orderStatus");
                TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "purchaseOrderOperationLog.failureReason");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchaseOrderOperationLog.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchaseOrderOperationLog.purchasingOrg");
                TypedField<Long> ID = new TypedField<>(Long.class, "purchaseOrderOperationLog.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "purchaseOrderOperationLog.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "purchaseOrderOperationLog.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderOperationLog.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderOperationLog.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderOperationLog.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderOperationLog.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "purchaseOrderOperationLog.delete_flag");
                TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "purchaseOrderOperationLog.buyerInvoiceID");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "purchaseOrderOperationLog.buyerInvoiceTitle");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "purchaseOrderOperationLog.invoiceType");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.purchaserName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.purchaserTaxNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.sellerTaxNo");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.purchaserNo");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "purchaseOrderOperationLog.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "purchaseOrderOperationLog.sellerTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.purchaseBankName");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseOrderOperationLog.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseOrderOperationLog.purchaseTelephone");
                TypedField<String> VIRTUAL_PO_TYPE = new TypedField<>(String.class, "purchaseOrderOperationLog.virtualPoType");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "purchaseOrderOperationLog.projectName");
                TypedField<BigDecimal> DELIVERIED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.deliveriedAmount");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.waitForInvoiceAmount");
                TypedField<BigDecimal> UNPAYED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.unpayedAmount");
                TypedField<String> ABSENT_MSG = new TypedField<>(String.class, "purchaseOrderOperationLog.absentMsg");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.amountWithTax");
                TypedField<BigDecimal> INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.invoicedAmount");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.negativePaymentNo");
                TypedField<String> ALTER_INVOICE_INDICATOR = new TypedField<>(String.class, "purchaseOrderOperationLog.alterInvoiceIndicator");
                TypedField<String> PREVIOUS_P_O_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.previousPONo");
                TypedField<String> NEXT_P_O_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.nextPONo");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.amountWithoutTax");
                TypedField<BigDecimal> INVOICE_NOTICE_BILL_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.invoiceNoticeBillAmount");
                TypedField<BigDecimal> PAYED_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.payedAmount");
                TypedField<BigDecimal> PREPAY_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.prepayAmount");
                TypedField<BigDecimal> ALL_PAID_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.allPaidAmount");
                TypedField<BigDecimal> WRITE_OFF_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.writeOffAmount");
                TypedField<BigDecimal> PREPAID_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.prepaidAmount");
                TypedField<String> PRE_ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderOperationLog.preOrderStatus");
                TypedField<BigDecimal> TEST_AMOUNT = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.testAmount");
                TypedField<BigDecimal> INVOICED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.invoicedAmountWithoutTax");
                TypedField<BigDecimal> WAIT_FOR_INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "purchaseOrderOperationLog.waitForInvoiceAmountWithoutTax");
                TypedField<Boolean> IS_SYNERGY = new TypedField<>(Boolean.class, "purchaseOrderOperationLog.isSynergy");
                TypedField<String> EAMIL_PROCESS_STATUS = new TypedField<>(String.class, "purchaseOrderOperationLog.eamilProcessStatus");
                TypedField<String> EAMIL_PROCESS_STATUS_RAW = new TypedField<>(String.class, "purchaseOrderOperationLog.eamilProcessStatusRaw");
                TypedField<String> PROJECT_DEFINITION = new TypedField<>(String.class, "purchaseOrderOperationLog.projectDefinition");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "purchaseOrderOperationLog.ladderNo");
                TypedField<String> PM_NODE = new TypedField<>(String.class, "purchaseOrderOperationLog.pmNode");
            }
        }
    }
    public interface UltramanSysBoUserSetting {
        static Long id() {
            return 1664469185032925185L;
        }
        static String code() {
            return "ultramanSysBoUserSetting";
        }
        TypedField<String> CONFIG = new TypedField<>(String.class, "config");
        TypedField<String> STORE_KEY = new TypedField<>(String.class, "store_key");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ClosingDate {
        static Long id() {
            return 1750068751216152577L;
        }
        static String code() {
            return "closingDate";
        }
        TypedField<String> PLAN_STATUS = new TypedField<>(String.class, "planStatus");
        TypedField<LocalDateTime> CLOSING_START_DATE = new TypedField<>(LocalDateTime.class, "closingStartDate");
        TypedField<LocalDateTime> CLOSING_END_DATE = new TypedField<>(LocalDateTime.class, "closingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
