package com.xforceplus.ultraman.app.jctke.metadata.validator;

import com.xforceplus.ultraman.app.jctke.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jctke.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-01-24
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(PoStatus.class)) {
            isValid = null != PoStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PoStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaseOrderType.class)) {
            isValid = null != PurchaseOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PurchaseOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(PrepaymentType.class)) {
            isValid = null != PrepaymentType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PrepaymentType.class.getSimpleName());
            }
        }
        if(clazz.equals(ENumReceiptType.class)) {
            isValid = null != ENumReceiptType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ENumReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = null != BusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApprovalStatus.class)) {
            isValid = null != ApprovalStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApprovalStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessStatus.class)) {
            isValid = null != BusinessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExpenseType.class)) {
            isValid = null != ExpenseType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExpenseType.class.getSimpleName());
            }
        }
        if(clazz.equals(RoleType.class)) {
            isValid = null != RoleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RoleType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = null != TaskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(ResqustStatus.class)) {
            isValid = null != ResqustStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ResqustStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentType.class)) {
            isValid = null != PaymentType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentType.class.getSimpleName());
            }
        }
        if(clazz.equals(LedgerType.class)) {
            isValid = null != LedgerType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LedgerType.class.getSimpleName());
            }
        }
        if(clazz.equals(PrePaymentIdentification.class)) {
            isValid = null != PrePaymentIdentification.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PrePaymentIdentification.class.getSimpleName());
            }
        }
        if(clazz.equals(IsFrozen.class)) {
            isValid = null != IsFrozen.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsFrozen.class.getSimpleName());
            }
        }
        if(clazz.equals(AgencyFeeType.class)) {
            isValid = null != AgencyFeeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AgencyFeeType.class.getSimpleName());
            }
        }
        if(clazz.equals(BondType.class)) {
            isValid = null != BondType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BondType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChangeTicketType.class)) {
            isValid = null != ChangeTicketType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChangeTicketType.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrentStatus.class)) {
            isValid = null != CurrentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CurrentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentUserType.class)) {
            isValid = null != PaymentUserType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentUserType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentBankType.class)) {
            isValid = null != PaymentBankType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentBankType.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractType.class)) {
            isValid = null != ContractType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ContractType.class.getSimpleName());
            }
        }
        if(clazz.equals(DownloadStatus.class)) {
            isValid = null != DownloadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DownloadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceNoticeStatus.class)) {
            isValid = null != InvoiceNoticeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceNoticeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ErrorCode.class)) {
            isValid = null != ErrorCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErrorCode.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountStatus.class)) {
            isValid = null != AccountStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AccountStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = null != PayStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceNoticeType.class)) {
            isValid = null != InvoiceNoticeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceNoticeType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceRegisterStatus.class)) {
            isValid = null != InvoiceRegisterStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceRegisterStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TrueStatus.class)) {
            isValid = null != TrueStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TrueStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ScanStatus.class)) {
            isValid = null != ScanStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ScanStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaResponseStatus.class)) {
            isValid = null != RpaResponseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RpaResponseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VirtualPoType.class)) {
            isValid = null != VirtualPoType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VirtualPoType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = null != InvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(SucceedOrError.class)) {
            isValid = null != SucceedOrError.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SucceedOrError.class.getSimpleName());
            }
        }
        if(clazz.equals(MultiValues.class)) {
            isValid = null != MultiValues.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MultiValues.class.getSimpleName());
            }
        }
        if(clazz.equals(PettyCashType.class)) {
            isValid = null != PettyCashType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PettyCashType.class.getSimpleName());
            }
        }
        if(clazz.equals(PostStatus.class)) {
            isValid = null != PostStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PostStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOperation.class)) {
            isValid = null != InvoiceOperation.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceOperation.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementOrderStatus.class)) {
            isValid = null != SettlementOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoToEn.class)) {
            isValid = null != NoToEn.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoToEn.class.getSimpleName());
            }
        }
        if(clazz.equals(EventType.class)) {
            isValid = null != EventType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EventType.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = null != YesOrNo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(CodeType.class)) {
            isValid = null != CodeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CodeType.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormat.class)) {
            isValid = null != SnaphostFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnaphostFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailSendScene.class)) {
            isValid = null != EmailSendScene.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EmailSendScene.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormatZnHUx9ie3DZpRo5T2c6zpK.class)) {
            isValid = null != SnaphostFormatZnHUx9ie3DZpRo5T2c6zpK.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnaphostFormatZnHUx9ie3DZpRo5T2c6zpK.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatusIYpahCP6HYtYaCemDzEJJR.class)) {
            isValid = null != FlowStatusIYpahCP6HYtYaCemDzEJJR.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatusIYpahCP6HYtYaCemDzEJJR.class.getSimpleName());
            }
        }
        if(clazz.equals(AmountLeftBorderSymbol.class)) {
            isValid = null != AmountLeftBorderSymbol.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AmountLeftBorderSymbol.class.getSimpleName());
            }
        }
        if(clazz.equals(AmountRightBorderSymbol.class)) {
            isValid = null != AmountRightBorderSymbol.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AmountRightBorderSymbol.class.getSimpleName());
            }
        }
        if(clazz.equals(AsyncStatus.class)) {
            isValid = null != AsyncStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AsyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaStatus.class)) {
            isValid = null != RpaStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RpaStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EamilProcessStatus.class)) {
            isValid = null != EamilProcessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EamilProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceObj.class)) {
            isValid = null != ProduceObj.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceObj.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceStatus.class)) {
            isValid = null != ProduceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceType.class)) {
            isValid = null != ProduceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceSource.class)) {
            isValid = null != ProduceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoGoodsType.class)) {
            isValid = null != AutoGoodsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoGoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = null != DataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(BorderSymbol.class)) {
            isValid = null != BorderSymbol.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BorderSymbol.class.getSimpleName());
            }
        }
        if(clazz.equals(WithdrawType.class)) {
            isValid = null != WithdrawType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WithdrawType.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchInvoiceQueryMethod.class)) {
            isValid = null != MatchInvoiceQueryMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchInvoiceQueryMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(Removed.class)) {
            isValid = null != Removed.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Removed.class.getSimpleName());
            }
        }
        if(clazz.equals(OverPayType.class)) {
            isValid = null != OverPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OverPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(EntityCode.class)) {
            isValid = null != EntityCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EntityCode.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaseOrderOperation.class)) {
            isValid = null != PurchaseOrderOperation.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PurchaseOrderOperation.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(PlanStatus.class)) {
            isValid = null != PlanStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PlanStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
