package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * over_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-29
 */
public enum OverPayType {

    _0("0", "无"),
    _1("1", "差额征税");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OverPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OverPayType fromCode(String code) {
        return Stream.of(OverPayType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
