package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * plan_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-29
 */
public enum PlanStatus {

    _0("0", "已过期"),
    _1("1", "计划中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PlanStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PlanStatus fromCode(String code) {
        return Stream.of(PlanStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
