package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * download_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-29
 */
public enum DownloadStatus {

    _0("0", "默认"),
    _1("1", "已下载"),
    _2("2", "未下载");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DownloadStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DownloadStatus fromCode(String code) {
        return Stream.of(DownloadStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
