package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_notice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-29
 */
public enum InvoiceNoticeType {

    _0("0", "非协同"),
    _2("2", "协同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceNoticeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceNoticeType fromCode(String code) {
        return Stream.of(InvoiceNoticeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
