package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mark_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-29
 */
public enum MarkType {

    _1("1", "已退回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MarkType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MarkType fromCode(String code) {
        return Stream.of(MarkType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
