package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * po_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-29
 */
public enum PoStatus {

    _2("2", "已关闭"),
    _3("3", "已锁定"),
    _4("4", "待处理"),
    _5("5", "待提交"),
    _99("99", "已作废"),
    _0("0", "数据异常"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PoStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PoStatus fromCode(String code) {
        return Stream.of(PoStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
